/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.GlobData;
import org.mozilla.javascript.regexp.MatchData;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.ReplaceData;
import org.mozilla.javascript.regexp.SubString;

public class RegExpImpl
implements RegExpProxy {
    String input;
    boolean multiline;
    Vector parens = new Vector(9);
    SubString lastMatch;
    SubString lastParen;
    SubString leftContext;
    SubString rightContext;

    public int find_split(Scriptable scriptable, String string, String string2, Object object, int[] nArray, int[] nArray2, boolean[] blArray, String[][] stringArray) {
        int n;
        SubString subString;
        int n2;
        block6: {
            int n3;
            block5: {
                n3 = nArray[0];
                int n4 = string.length();
                Context context = Context.getCurrentContext();
                int n5 = context.getLanguageVersion();
                NativeRegExp nativeRegExp = (NativeRegExp)object;
                do {
                    n2 = nArray[0];
                    nArray[0] = ++n3;
                    Object object2 = nativeRegExp.executeRegExp(context, scriptable, this, string, nArray, 0);
                    if (object2 != Boolean.TRUE) {
                        nArray[0] = n2;
                        nArray2[0] = 1;
                        blArray[0] = false;
                        return n4;
                    }
                    n3 = nArray[0];
                    nArray[0] = n2;
                    blArray[0] = true;
                    subString = this.lastMatch;
                    nArray2[0] = subString.length;
                    if (nArray2[0] != 0 || n3 != nArray[0]) break block5;
                } while (n3 != n4);
                if (n5 == 120) {
                    nArray2[0] = 1;
                    n = n3;
                } else {
                    n = -1;
                }
                break block6;
            }
            n = n3 - nArray2[0];
        }
        n2 = this.parens.size();
        stringArray[0] = new String[n2];
        int n6 = 0;
        while (n6 < n2) {
            subString = this.getParenSubString(n6);
            stringArray[0][n6] = subString.toString();
            ++n6;
        }
        return n;
    }

    SubString getParenSubString(int n) {
        if (n >= this.parens.size()) {
            return SubString.emptySubString;
        }
        return (SubString)this.parens.elementAt(n);
    }

    public boolean isRegExp(Object object) {
        return object instanceof NativeRegExp;
    }

    public Object match(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        MatchData matchData = new MatchData();
        matchData.optarg = 1;
        matchData.mode = 1;
        matchData.parent = ScriptableObject.getTopLevelScope(scriptable);
        Object object = RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, matchData, false);
        return matchData.arrayobj == null ? object : matchData.arrayobj;
    }

    private static Object matchOrReplace(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, RegExpImpl regExpImpl, GlobData globData, boolean bl) throws JavaScriptException {
        Object object;
        Object object2;
        NativeRegExp nativeRegExp;
        String string;
        globData.str = string = ScriptRuntime.toString(scriptable2);
        Scriptable scriptable3 = ScriptableObject.getTopLevelScope(scriptable);
        if (objectArray.length == 0) {
            nativeRegExp = new NativeRegExp(context, scriptable3, "", "", false);
        } else if (objectArray[0] instanceof NativeRegExp) {
            nativeRegExp = (NativeRegExp)objectArray[0];
        } else {
            object2 = ScriptRuntime.toString(objectArray[0]);
            if (globData.optarg < objectArray.length) {
                objectArray[0] = object2;
                object = ScriptRuntime.toString(objectArray[globData.optarg]);
            } else {
                object = null;
            }
            nativeRegExp = new NativeRegExp(context, scriptable3, (String)object2, (String)object, bl);
        }
        globData.regexp = nativeRegExp;
        globData.global = (nativeRegExp.getFlags() & 1) != 0;
        object2 = new int[1];
        object = null;
        if (globData.mode == 3) {
            object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, (int[])object2, 0);
            object = object != null && object.equals(Boolean.TRUE) ? new Integer(regExpImpl.leftContext.length) : new Integer(-1);
        } else if (globData.global) {
            nativeRegExp.setLastIndex(0);
            int n = 0;
            while (object2[0] <= string.length()) {
                object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, (int[])object2, 0);
                if (object == null || !object.equals(Boolean.TRUE)) break;
                globData.doGlobal(context, scriptable, n, regExpImpl);
                if (regExpImpl.lastMatch.length == 0) {
                    if (object2[0] == string.length()) break;
                    Object object3 = object2;
                    object3[0] = object3[0] + true;
                }
                ++n;
            }
        } else {
            object = nativeRegExp.executeRegExp(context, scriptable, regExpImpl, string, (int[])object2, globData.mode == 2 ? 0 : 1);
        }
        return object;
    }

    public Object newRegExp(Context context, Scriptable scriptable, String string, String string2, boolean bl) {
        return new NativeRegExp(context, scriptable, string, string2, bl);
    }

    public Object replace(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        char[] cArray;
        int n;
        Scriptable scriptable3 = objectArray.length < 2 ? Undefined.instance : objectArray[1];
        String string = null;
        Function function = null;
        if (scriptable3 instanceof Function) {
            function = (Function)scriptable3;
        } else {
            string = ScriptRuntime.toString(scriptable3);
        }
        ReplaceData replaceData = new ReplaceData();
        replaceData.optarg = 2;
        replaceData.mode = (byte)2;
        replaceData.lambda = function;
        replaceData.repstr = string == null ? null : string.toCharArray();
        replaceData.dollar = string == null ? -1 : string.indexOf(36);
        replaceData.charArray = null;
        replaceData.length = 0;
        replaceData.index = 0;
        replaceData.leftIndex = 0;
        Object object = RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, replaceData, true);
        if (replaceData.charArray == null) {
            if (replaceData.global || object == null || !object.equals(Boolean.TRUE)) {
                return replaceData.str;
            }
            int n2 = this.leftContext.length;
            n = n2 + replaceData.findReplen(context, this);
            cArray = new char[n];
            SubString subString = this.leftContext;
            System.arraycopy(subString.charArray, subString.index, cArray, 0, n2);
            replaceData.doReplace(context, this, cArray, n2);
            replaceData.charArray = cArray;
            replaceData.length = n;
        }
        SubString subString = this.rightContext;
        n = subString.length;
        int n3 = replaceData.length + n;
        cArray = new char[n3];
        System.arraycopy(replaceData.charArray, 0, cArray, 0, replaceData.charArray.length);
        System.arraycopy(subString.charArray, subString.index, cArray, replaceData.length, n);
        return new String(cArray, 0, n3);
    }

    public Object search(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        MatchData matchData = new MatchData();
        matchData.optarg = 1;
        matchData.mode = (byte)3;
        matchData.parent = ScriptableObject.getTopLevelScope(scriptable);
        return RegExpImpl.matchOrReplace(context, scriptable, scriptable2, objectArray, this, matchData, false);
    }
}

