/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableEngine;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.ContextHelper;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.CreateFileWindow;
import org.mozilla.javascript.tools.debugger.EnterInterrupt;
import org.mozilla.javascript.tools.debugger.EvalWindow;
import org.mozilla.javascript.tools.debugger.ExitInterrupt;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.OpenFile;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SetFilePosition;
import org.mozilla.javascript.tools.debugger.SetFileText;
import org.mozilla.javascript.tools.debugger.UpdateContext;

public class Main
extends JFrame
implements Debugger,
ContextListener {
    HashSet contexts = new HashSet();
    static Thread mainThread;
    boolean breakFlag = false;
    static final int STEP_OVER = 0;
    static final int STEP_INTO = 1;
    static final int STEP_OUT = 2;
    static final int GO = 3;
    static final int BREAK = 4;
    static final int RUN_TO_CURSOR = 5;
    static final int EXIT = 6;
    private Hashtable threadState = new Hashtable();
    private Thread runToCursorThread;
    private int runToCursorLine;
    private String runToCursorFile;
    private Hashtable sourceNames = new Hashtable();
    Hashtable functionMap = new Hashtable();
    Hashtable breakpointsMap = new Hashtable();
    JDesktopPane desk;
    ContextWindow context;
    Menubar menubar;
    JToolBar toolBar;
    JSInternalConsole console;
    EvalWindow evalWindow;
    JSplitPane split1;
    JLabel statusBar;
    ScopeProvider scopeProvider;
    Runnable exitAction;
    int frameIndex = -1;
    boolean isInterrupted = false;
    boolean nonDispatcherWaiting = false;
    int dispatcherIsWaiting = 0;
    Context currentContext = null;
    JFileChooser dlg;
    Hashtable fileWindows = new Hashtable();
    FileWindow currentWindow;
    Object monitor = new Object();
    Object swingMonitor = new Object();
    int returnValue = -1;
    boolean breakOnExceptions;
    Hashtable toplevels = new Hashtable();
    static /* synthetic */ Class class$javax$swing$JSplitPane;

    public Main(String string) {
        super(string);
        this.init();
    }

    void Exit() {
        this.returnValue = 6;
        if (this.exitAction != null) {
            Main.swingInvokeLater(this.exitAction);
        }
    }

    void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        int n = -1;
        if (string.equals("Cut") || string.equals("Copy") || string.equals("Paste")) {
            object = this.getSelectedFrame();
            if (object != null && object instanceof ActionListener) {
                ((ActionListener)object).actionPerformed(actionEvent);
            }
        } else if (string.equals("Step Over")) {
            n = 0;
        } else if (string.equals("Step Into")) {
            n = 1;
        } else if (string.equals("Step Out")) {
            n = 2;
        } else if (string.equals("Go")) {
            n = 3;
        } else if (string.equals("Break")) {
            this.doBreak();
        } else if (string.equals("Run to Cursor")) {
            n = 5;
        } else if (string.equals("Exit")) {
            this.Exit();
        } else if (string.equals("Open")) {
            object = this.getScope();
            if (object == null) {
                MessageDialogWrapper.showMessageDialog(this, "Can't compile scripts: no scope available", "Open", 0);
            } else {
                String string2 = this.chooseFile("Select a file to compile");
                if (string2 != null) {
                    new Thread(new OpenFile(this, (Scriptable)object, string2)).start();
                }
            }
        } else if (string.equals("Load")) {
            object = this.getScope();
            if (object == null) {
                MessageDialogWrapper.showMessageDialog(this, "Can't run scripts: no scope available", "Run", 0);
            } else {
                String string3 = this.chooseFile("Select a file to execute");
                if (string3 != null) {
                    new Thread(new LoadFile(this, (Scriptable)object, string3)).start();
                }
            }
        } else if (string.equals("More Windows...")) {
            object = new MoreWindows(this, this.fileWindows, "Window", "Files");
            ((MoreWindows)object).showDialog(this);
        } else if (string.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(string.equals("Cut") || string.equals("Copy") || string.equals("Paste"))) {
            if (string.equals("Go to function...")) {
                object = new FindFunction(this, this.functionMap, "Go to function", "Function");
                ((FindFunction)object).showDialog(this);
            } else if (string.equals("Tile")) {
                object = this.desk.getAllFrames();
                int n2 = ((JInternalFrame[])object).length;
                int n3 = (int)Math.sqrt(n2);
                int n4 = n3;
                if (n4 * n3 < n2 && n4 * ++n3 < n2) {
                    ++n4;
                }
                Dimension dimension = this.desk.getSize();
                int n5 = dimension.width / n3;
                int n6 = dimension.height / n4;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = 0;
                    while (n10 < n3) {
                        int n11 = n9 * n3 + n10;
                        if (n11 >= ((Object)object).length) break;
                        Object object2 = object[n11];
                        try {
                            ((JInternalFrame)object2).setIcon(false);
                            ((JInternalFrame)object2).setMaximum(false);
                        }
                        catch (Exception exception) {}
                        this.desk.getDesktopManager().setBoundsForFrame((JComponent)object2, n7, n8, n5, n6);
                        n7 += n5;
                        ++n10;
                    }
                    n8 += n6;
                    n7 = 0;
                    ++n9;
                }
            } else if (string.equals("Cascade")) {
                object = this.desk.getAllFrames();
                int n12 = ((Object)object).length;
                int n13 = 0;
                int n14 = 0;
                int n15 = this.desk.getHeight();
                int n16 = n15 / n12;
                if (n16 > 30) {
                    n16 = 30;
                }
                int n17 = n12 - 1;
                while (n17 >= 0) {
                    Object object3 = object[n17];
                    try {
                        ((JInternalFrame)object3).setIcon(false);
                        ((JInternalFrame)object3).setMaximum(false);
                    }
                    catch (Exception exception) {}
                    Dimension dimension = ((JComponent)object3).getPreferredSize();
                    int n18 = dimension.width;
                    n15 = dimension.height;
                    this.desk.getDesktopManager().setBoundsForFrame((JComponent)object3, n14, n13, n18, n15);
                    --n17;
                    n14 += n16;
                    n13 += n16;
                }
            } else {
                object = this.getFileWindow(string);
                if (object != null) {
                    FileWindow fileWindow = (FileWindow)object;
                    try {
                        if (fileWindow.isIcon()) {
                            fileWindow.setIcon(false);
                        }
                        fileWindow.setVisible(true);
                        fileWindow.moveToFront();
                        fileWindow.setSelected(true);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (n != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            object = this.monitor;
            synchronized (object) {
                this.returnValue = n;
                this.monitor.notify();
            }
        }
    }

    void addTopLevel(String string, JFrame jFrame) {
        if (jFrame != this) {
            this.toplevels.put(string, jFrame);
        }
    }

    String chooseFile(String string) {
        int n;
        this.dlg.setDialogTitle(string);
        File file = null;
        String string2 = System.getProperty("user.dir");
        if (string2 != null) {
            file = new File(string2);
        }
        if (file != null) {
            this.dlg.setCurrentDirectory(file);
        }
        if ((n = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String string3 = this.dlg.getSelectedFile().getCanonicalPath();
                file = this.dlg.getSelectedFile().getParentFile();
                System.setProperty("user.dir", file.getPath());
                return string3;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearAllBreakpoints() {
        this.doClearBreakpoints();
    }

    void clearBreakPoint(String string, int n) {
        Vector vector = (Vector)this.sourceNames.get(string);
        if (vector == null) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            SourceEntry sourceEntry = (SourceEntry)vector.elementAt(n2);
            sourceEntry.fnOrScript.removeBreakpoint(n);
            ++n2;
        }
    }

    public void contextCreated(Context context) {
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            DebuggableEngine debuggableEngine = context.getDebuggableEngine();
            debuggableEngine.setDebugger(this);
            context.setGeneratingDebug(true);
            context.setOptimizationLevel(-1);
            if (this.breakFlag || Thread.currentThread() == mainThread) {
                debuggableEngine.setBreakNextLine(true);
            }
        }
    }

    public void contextEntered(Context context) {
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            if (!this.contexts.contains(context) && context.getDebuggableEngine().getDebugger() == this) {
                this.contexts.add(context);
            }
        }
    }

    public void contextExited(Context context) {
    }

    public void contextReleased(Context context) {
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            this.contexts.remove(context);
        }
    }

    void contextSwitch(int n) {
        Context context = this.getCurrentContext();
        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
        ContextHelper contextHelper = new ContextHelper();
        contextHelper.attach(context);
        if (context != null) {
            int n2 = debuggableEngine.getFrameCount();
            if (n < 0 || n >= n2) {
                contextHelper.reset();
                return;
            }
            this.frameIndex = n;
            DebugFrame debugFrame = debuggableEngine.getFrame(n);
            String string = debugFrame.getSourceName();
            if (string == null || string.equals("<stdin>")) {
                this.console.show();
                contextHelper.reset();
                return;
            }
            if (string == "<eval>") {
                contextHelper.reset();
                return;
            }
            int n3 = debugFrame.getLineNumber();
            this.frameIndex = n;
            FileWindow fileWindow = this.getFileWindow(string);
            if (fileWindow != null) {
                SetFilePosition setFilePosition = new SetFilePosition(this, fileWindow, n3);
                setFilePosition.run();
            } else {
                Vector vector = (Vector)this.sourceNames.get(string);
                String string2 = ((SourceEntry)vector.elementAt((int)0)).source.toString();
                CreateFileWindow createFileWindow = new CreateFileWindow(this, string, string2, n3);
                createFileWindow.run();
            }
            contextHelper.reset();
        }
    }

    public void doBreak() {
        this.breakFlag = true;
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            Iterator iterator = this.contexts.iterator();
            while (iterator.hasNext()) {
                Context context = (Context)iterator.next();
                context.getDebuggableEngine().setBreakNextLine(true);
            }
        }
    }

    void doClearBreakpoints() {
        Enumeration enumeration = this.breakpointsMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Hashtable hashtable = (Hashtable)this.breakpointsMap.get(string);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                Integer n = (Integer)hashtable.get(enumeration2.nextElement());
                this.clearBreakPoint(string, n);
            }
        }
    }

    String eval(String string) {
        String string2;
        Context context = this.getCurrentContext();
        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
        if (context == null) {
            return "undefined";
        }
        ContextHelper contextHelper = new ContextHelper();
        contextHelper.attach(context);
        if (this.frameIndex >= debuggableEngine.getFrameCount()) {
            contextHelper.reset();
            return "undefined";
        }
        debuggableEngine.setDebugger(null);
        context.setGeneratingDebug(false);
        context.setOptimizationLevel(-1);
        boolean bl = debuggableEngine.getBreakNextLine();
        debuggableEngine.setBreakNextLine(false);
        try {
            Object object;
            Scriptable scriptable = debuggableEngine.getFrame(this.frameIndex).getVariableObject();
            if (scriptable instanceof NativeCall) {
                NativeCall nativeCall = (NativeCall)scriptable;
                object = NativeGlobal.evalSpecial(context, nativeCall, nativeCall.getThisObj(), new Object[]{string}, "", 1);
            } else {
                object = context.evaluateString(scriptable, string, "", 0, null);
            }
            if (object == Undefined.instance) {
                object = "";
            }
            try {
                string2 = ScriptRuntime.toString(object);
            }
            catch (Exception exception) {
                string2 = object.toString();
            }
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        if (string2 == null) {
            string2 = "null";
        }
        debuggableEngine.setDebugger(this);
        context.setGeneratingDebug(true);
        context.setOptimizationLevel(-1);
        debuggableEngine.setBreakNextLine(bl);
        contextHelper.reset();
        return string2;
    }

    Context getCurrentContext() {
        return this.currentContext;
    }

    public PrintStream getErr() {
        return this.console.getErr();
    }

    FileWindow getFileWindow(String string) {
        if (string == null || string.equals("<stdin>") || string.equals("<eval>")) {
            return null;
        }
        String string2 = string;
        Enumeration enumeration = this.fileWindows.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string2.equals(string3)) continue;
            FileWindow fileWindow = (FileWindow)this.fileWindows.get(string3);
            fileWindow.setUrl(string);
            return fileWindow;
        }
        return (FileWindow)this.fileWindows.get(string);
    }

    public InputStream getIn() {
        return this.console.getIn();
    }

    public PrintStream getOut() {
        return this.console.getOut();
    }

    Scriptable getScope() {
        return this.scopeProvider != null ? this.scopeProvider.getScope() : null;
    }

    JInternalFrame getSelectedFrame() {
        JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            if (jInternalFrameArray[n].isShowing()) {
                return jInternalFrameArray[n];
            }
            ++n;
        }
        return jInternalFrameArray[jInternalFrameArray.length - 1];
    }

    JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    public void handleBreakpointHit(Context context) {
        this.breakFlag = false;
        this.interrupted(context);
    }

    public void handleCompilationDone(Context context, DebuggableScript debuggableScript, StringBuffer stringBuffer) {
        NativeFunction nativeFunction;
        String string;
        Vector<SourceEntry> vector;
        String string2 = debuggableScript.getSourceName();
        if (string2 == null) {
            string2 = "<stdin>";
        }
        if ((vector = (Vector<SourceEntry>)this.sourceNames.get(string2)) == null) {
            vector = new Vector<SourceEntry>();
            this.sourceNames.put(string2, vector);
        }
        SourceEntry sourceEntry = new SourceEntry(stringBuffer, debuggableScript);
        vector.addElement(sourceEntry);
        if (debuggableScript.getScriptable() instanceof NativeFunction && (string = (nativeFunction = (NativeFunction)debuggableScript.getScriptable()).getFunctionName()).length() > 0 && !string.equals("anonymous")) {
            this.functionMap.put(string, sourceEntry);
        }
        this.loadedFile(string2, stringBuffer.toString());
    }

    public void handleExceptionThrown(Context context, Object object) {
        if (this.breakOnExceptions) {
            String string;
            DebuggableEngine debuggableEngine = context.getDebuggableEngine();
            DebugFrame debugFrame = debuggableEngine.getFrame(0);
            String string2 = debugFrame.getSourceName();
            int n = debugFrame.getLineNumber();
            FileWindow fileWindow = null;
            if (string2 == null) {
                string2 = n == -1 ? "<eval>" : "<stdin>";
            } else {
                fileWindow = this.getFileWindow(string2);
            }
            if (object instanceof NativeJavaObject) {
                object = ((NativeJavaObject)object).unwrap();
            }
            if ((string = object.toString()) == null || string.length() == 0) {
                string = object.getClass().toString();
            }
            string = String.valueOf(string) + " (" + string2 + ", line " + n + ")";
            if (fileWindow != null) {
                Main.swingInvoke(new SetFilePosition(this, fileWindow, n));
            }
            MessageDialogWrapper.showMessageDialog(this, string, "Exception in Script", 0);
            this.interrupted(context);
        }
    }

    void init() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] stringArray = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int n = 0;
        JButton jButton7 = jButton6 = (jButton5 = new JButton("Break"));
        jButton6.setToolTipText("Break");
        jButton6.setActionCommand("Break");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(true);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton4 = new JButton("Go");
        jButton6.setToolTipText("Go");
        jButton6.setActionCommand("Go");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton3 = new JButton("Step Into");
        jButton6.setToolTipText("Step Into");
        jButton6.setActionCommand("Step Into");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton2 = new JButton("Step Over");
        jButton6.setToolTipText("Step Over");
        jButton6.setActionCommand("Step Over");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton = new JButton("Step Out");
        jButton6.setToolTipText("Step Out");
        jButton6.setActionCommand("Step Out");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        Dimension dimension = jButton2.getPreferredSize();
        jButton5.setPreferredSize(dimension);
        jButton5.setMinimumSize(dimension);
        jButton5.setMaximumSize(dimension);
        jButton5.setSize(dimension);
        jButton4.setPreferredSize(dimension);
        jButton4.setMinimumSize(dimension);
        jButton4.setMaximumSize(dimension);
        jButton3.setPreferredSize(dimension);
        jButton3.setMinimumSize(dimension);
        jButton3.setMaximumSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton2.setMinimumSize(dimension);
        jButton2.setMaximumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
        this.toolBar.add(jButton5);
        this.toolBar.add(jButton4);
        this.toolBar.add(jButton3);
        this.toolBar.add(jButton2);
        this.toolBar.add(jButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.console = new JSInternalConsole("JavaScript Console");
        this.desk.add(this.console);
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        Main.setResizeWeight(this.split1, 0.66);
        jPanel.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        jPanel.add((Component)this.statusBar, "South");
        this.dlg = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String string;
                if (file.isDirectory()) {
                    return true;
                }
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                return n > 0 && n < string2.length() - 1 && (string = string2.substring(n + 1).toLowerCase()).equals("js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(fileFilter);
        Main main = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Main.this.Exit();
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void interrupted(Context var1_1) {
        block58: {
            var2_2 = this.swingMonitor;
            synchronized (var2_2) {
                block59: {
                    if (!EventQueue.isDispatchThread()) ** GOTO lbl-1000
                    ++this.dispatcherIsWaiting;
                    if (!this.nonDispatcherWaiting) break block59;
                    var4_3 = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    while (this.nonDispatcherWaiting) {
                        try {
                            var5_4 = var4_3.getNextEvent();
                            if (var5_4 instanceof ActiveEvent) {
                                ((ActiveEvent)var5_4).dispatch();
                            } else {
                                var6_6 = var5_4.getSource();
                                if (var6_6 instanceof Component) {
                                    var7_9 = (Component)var6_6;
                                    var7_9.dispatchEvent(var5_4);
                                } else if (var6_6 instanceof MenuComponent) {
                                    ((MenuComponent)var6_6).dispatchEvent(var5_4);
                                }
                            }
                            if (this.returnValue == 6) {
                                var3_11 = null;
                                return;
                            }
                            this.swingMonitor.wait(1L);
                        }
                        catch (InterruptedException v0) {
                            var3_12 = null;
                            return;
                        }
                    }
                    break block59;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.swingMonitor.wait();
                            continue;
                        }
                        catch (InterruptedException v1) {
                            var3_13 = null;
                            return;
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** while (this.isInterrupted || this.dispatcherIsWaiting > 0)
                    }
lbl41:
                    // 1 sources

                    this.nonDispatcherWaiting = true;
                }
                this.isInterrupted = true;
            }
            this.currentContext = var1_1;
            var2_2 = var1_1.getDebuggableEngine();
            var3_14 = Thread.currentThread();
            this.statusBar.setText("Thread: " + var3_14.toString());
            var4_3 = (ThreadState)this.threadState.get(var3_14);
            var5_5 = -1;
            if (var4_3 != null) {
                var5_5 = ThreadState.access$0((ThreadState)var4_3);
            }
            if (this.runToCursorFile != null && var3_14 == this.runToCursorThread && (var6_7 = var2_2.getFrameCount()) > 0 && (var8_15 = (var7_9 = var2_2.getFrame(0)).getSourceName()) != null && var8_15.equals(this.runToCursorFile)) {
                var9_16 = var7_9.getLineNumber();
                if (var9_16 == this.runToCursorLine) {
                    var5_5 = -1;
                    this.runToCursorFile = null;
                } else {
                    var10_18 = this.getFileWindow((String)var8_15);
                    if (var10_18 == null || !var10_18.isBreakPoint(var9_16)) {
                        return;
                    }
                    this.runToCursorFile = null;
                }
            }
            if (var5_5 <= 0 || var2_2.getFrameCount() <= var5_5) {
                if (var4_3 != null) {
                    ThreadState.access$1((ThreadState)var4_3, -1);
                }
                this.threadState.remove(var3_14);
                var6_8 = var2_2.getFrameCount();
                this.frameIndex = var6_8 - 1;
                var7_10 = 0;
                if (var6_8 != 0) {
                    var8_15 = var2_2.getFrame(0);
                    var9_17 = var8_15.getSourceName();
                    var2_2.setBreakNextLine(false);
                    var7_10 = var8_15.getLineNumber();
                    var10_19 = 0;
                    var11_20 = EventQueue.isDispatchThread();
                    if (!var11_20) {
                        Context.exit();
                        while (Context.getCurrentContext() != null) {
                            Context.exit();
                            ++var10_19;
                        }
                    }
                    if (var9_17 != null && !var9_17.equals("<stdin>")) {
                        var12_21 /* !! */  = this.getFileWindow(var9_17);
                        if (var12_21 /* !! */  != null) {
                            var13_23 = new SetFilePosition(this, (FileWindow)var12_21 /* !! */ , var7_10);
                            Main.swingInvoke((Runnable)var13_23);
                        } else {
                            var13_23 = (Vector)this.sourceNames.get(var9_17);
                            var14_24 = ((SourceEntry)var13_23.elementAt((int)0)).source.toString();
                            var15_25 = new CreateFileWindow(this, var9_17, (String)var14_24, var7_10);
                            Main.swingInvoke((Runnable)var15_25);
                        }
                    } else if (this.console.isVisible()) {
                        var12_21 /* !! */  = this.console;
                        Main.swingInvoke(new Runnable(){

                            public void run() {
                                var12_21.show();
                            }
                        });
                    }
                    Main.swingInvoke(new EnterInterrupt(this, var1_1));
                    Main.swingInvoke(new UpdateContext(this, var1_1));
                    if (!var11_20) {
                        var13_23 = this.monitor;
                        synchronized (var13_23) {
                            this.returnValue = -1;
                            try {
                                while (this.returnValue == -1) {
                                    this.monitor.wait();
                                }
                                var12_22 = this.returnValue;
                            }
                            catch (InterruptedException v3) {
                                var14_24 = null;
                                break block58;
                            }
                        }
                    }
                    var13_23 = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    this.returnValue = -1;
                    while (this.returnValue == -1) {
                        try {
                            var14_24 = var13_23.getNextEvent();
                            if (var14_24 instanceof ActiveEvent) {
                                ((ActiveEvent)var14_24).dispatch();
                                continue;
                            }
                            var15_25 = var14_24.getSource();
                            if (var15_25 instanceof Component) {
                                var16_26 = (Component)var15_25;
                                var16_26.dispatchEvent((AWTEvent)var14_24);
                                continue;
                            }
                            if (!(var15_25 instanceof MenuComponent)) continue;
                            ((MenuComponent)var15_25).dispatchEvent((AWTEvent)var14_24);
                        }
                        catch (InterruptedException v5) {}
                    }
                    var12_22 = this.returnValue;
                    Main.swingInvoke(new ExitInterrupt(this));
                    if (!var11_20) {
                        var13_23 = Context.enter(var1_1);
                        if (var13_23 != var1_1) {
                            System.out.println("debugger error: cx = " + var1_1 + " current = " + var13_23);
                        }
                        while (var10_19 > 0) {
                            Context.enter();
                            --var10_19;
                        }
                    }
                    switch (var12_22) {
                        case 0: {
                            var2_2.setBreakNextLine(true);
                            var5_5 = var2_2.getFrameCount();
                            if (var4_3 == null) {
                                var4_3 = new ThreadState();
                            }
                            ThreadState.access$1((ThreadState)var4_3, var5_5);
                            this.threadState.put(var3_14, var4_3);
                            break;
                        }
                        case 1: {
                            var2_2.setBreakNextLine(true);
                            if (var4_3 == null) break;
                            ThreadState.access$1((ThreadState)var4_3, -1);
                            break;
                        }
                        case 2: {
                            var5_5 = var2_2.getFrameCount() - 1;
                            if (var5_5 <= 0) break;
                            var2_2.setBreakNextLine(true);
                            if (var4_3 == null) {
                                var4_3 = new ThreadState();
                            }
                            ThreadState.access$1((ThreadState)var4_3, var5_5);
                            this.threadState.put(var3_14, var4_3);
                            break;
                        }
                        case 5: {
                            var2_2.setBreakNextLine(true);
                            if (var4_3 == null) break;
                            ThreadState.access$1((ThreadState)var4_3, -1);
                            break;
                        }
                    }
                }
            }
        }
        var2_2 = this.swingMonitor;
        synchronized (var2_2) {
            this.isInterrupted = false;
            if (EventQueue.isDispatchThread()) {
                --this.dispatcherIsWaiting;
            } else {
                this.nonDispatcherWaiting = false;
            }
            this.swingMonitor.notifyAll();
        }
    }

    void loadedFile(String string, String string2) {
        FileWindow fileWindow = this.getFileWindow(string);
        if (fileWindow != null) {
            Main.swingInvoke(new SetFileText(fileWindow, string2));
            fileWindow.show();
        } else if (!string.equals("<stdin>")) {
            Main.swingInvoke(new CreateFileWindow(this, string, string2, -1));
        }
    }

    public static void main(String[] stringArray) {
        try {
            mainThread = Thread.currentThread();
            Main main = new Main("Rhino JavaScript Debugger");
            Main.swingInvoke(new Runnable(){

                public void run() {
                    Main.this.pack();
                    ((Component)Main.this).setSize(600, 460);
                    Main.this.setVisible(true);
                }
            });
            main.setExitAction(new Runnable(){

                public void run() {
                    System.exit(0);
                }
            });
            System.setIn(main.getIn());
            System.setOut(main.getOut());
            System.setErr(main.getErr());
            Context.addContextListener(main);
            main.setScopeProvider(new ScopeProvider(){

                public Scriptable getScope() {
                    return org.mozilla.javascript.tools.shell.Main.getScope();
                }
            });
            org.mozilla.javascript.tools.shell.Main.exec(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void removeWindow(FileWindow fileWindow) {
        this.fileWindows.remove(fileWindow.getUrl());
        JMenu jMenu = this.getWindowMenu();
        int n = jMenu.getItemCount();
        JMenuItem jMenuItem = jMenu.getItem(n - 1);
        String string = new File(fileWindow.getUrl()).getName();
        int n2 = 5;
        while (n2 < n) {
            int n3;
            String string2;
            JMenuItem jMenuItem2 = jMenu.getItem(n2);
            if (jMenuItem2 != null && (string2 = jMenuItem2.getText()).substring((n3 = string2.indexOf(32)) + 1).equals(string)) {
                jMenu.remove(jMenuItem2);
                if (n == 6) {
                    jMenu.remove(4);
                    break;
                }
                int n4 = n2 - 4;
                while (n2 < n - 1) {
                    JMenuItem jMenuItem3 = jMenu.getItem(n2);
                    if (jMenuItem3 != null) {
                        string2 = jMenuItem3.getText();
                        if (string2.equals("More Windows...")) break;
                        n3 = string2.indexOf(32);
                        jMenuItem3.setText(String.valueOf((char)(48 + n4)) + " " + string2.substring(n3 + 1));
                        jMenuItem3.setMnemonic(48 + n4);
                        ++n4;
                    }
                    ++n2;
                }
                if (n - 6 != 0 || jMenuItem == jMenuItem2 || !jMenuItem.getText().equals("More Windows...")) break;
                jMenu.remove(jMenuItem);
                break;
            }
            ++n2;
        }
        jMenu.revalidate();
    }

    void runToCursor(String string, int n, ActionEvent actionEvent) {
        Vector vector = (Vector)this.sourceNames.get(string);
        if (vector == null) {
            System.out.println("debugger error: Couldn't find source: " + string);
        }
        SourceEntry sourceEntry = null;
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            sourceEntry = (SourceEntry)vector.elementAt(n2);
            if (sourceEntry.fnOrScript.removeBreakpoint(n)) {
                sourceEntry.fnOrScript.placeBreakpoint(n);
                break;
            }
            if (sourceEntry.fnOrScript.placeBreakpoint(n)) {
                sourceEntry.fnOrScript.removeBreakpoint(n);
                break;
            }
            --n2;
        }
        if (n2 >= 0) {
            this.runToCursorFile = string;
            this.runToCursorLine = n;
            this.actionPerformed(actionEvent);
        }
    }

    void setBreakOnExceptions(boolean bl) {
        this.breakOnExceptions = bl;
    }

    int setBreakPoint(String string, int n) {
        Vector vector = (Vector)this.sourceNames.get(string);
        if (vector == null) {
            return -1;
        }
        int n2 = 0;
        int n3 = -1;
        n2 = vector.size() - 1;
        while (n2 >= 0) {
            SourceEntry sourceEntry = (SourceEntry)vector.elementAt(n2);
            if (sourceEntry.fnOrScript.placeBreakpoint(n)) {
                n3 = n;
            }
            --n2;
        }
        return n3;
    }

    public void setExitAction(Runnable runnable) {
        this.exitAction = runnable;
    }

    static void setResizeWeight(JSplitPane jSplitPane, double d) {
        try {
            Method method = (class$javax$swing$JSplitPane != null ? class$javax$swing$JSplitPane : (class$javax$swing$JSplitPane = Main.class$("javax.swing.JSplitPane"))).getMethod("setResizeWeight", Double.TYPE);
            method.invoke((Object)jSplitPane, new Double(d));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public void setVisible(boolean bl) {
        block2: {
            super.setVisible(bl);
            if (!bl) break block2;
            this.console.consoleTextArea.requestFocus();
            this.context.split.setDividerLocation(0.5);
            try {
                this.console.setMaximum(true);
                this.console.setSelected(true);
                this.console.show();
                this.console.consoleTextArea.requestFocus();
            }
            catch (Exception exception) {}
        }
    }

    boolean shouldDispatchTo(Component component) {
        Component component2 = SwingUtilities.getRoot(component);
        if (component2 == this) {
            return true;
        }
        Enumeration enumeration = this.toplevels.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            JFrame jFrame = (JFrame)this.toplevels.get(k);
            if (component2 != jFrame) continue;
            return true;
        }
        return false;
    }

    boolean stringIsCompilableUnit(String string) {
        Context context = Context.enter();
        boolean bl = context.stringIsCompilableUnit(string);
        Context.exit();
        return bl;
    }

    static void swingInvoke(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void swingInvokeLater(Runnable runnable) {
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class ThreadState {
        private int stopAtFrameDepth = -1;

        ThreadState() {
        }

        static /* synthetic */ int access$0(ThreadState threadState) {
            return threadState.stopAtFrameDepth;
        }

        static /* synthetic */ void access$1(ThreadState threadState, int n) {
            threadState.stopAtFrameDepth = n;
        }
    }

    class SourceEntry {
        StringBuffer source;
        DebuggableScript fnOrScript;

        SourceEntry(StringBuffer stringBuffer, DebuggableScript debuggableScript) {
            this.source = stringBuffer;
            this.fnOrScript = debuggableScript;
        }
    }
}

