/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.python.core.AbstractArray;
import org.python.core.ArgParser;
import org.python.core.ByteSwapper;
import org.python.core.Py;
import org.python.core.PyArrayDerived;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyGetSetDescr;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaClass;
import org.python.core.PyList;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyType;

public class PyArray
extends PySequence
implements Cloneable {
    public static final String exposed_name = "array";
    public static final Class exposed_base = PyObject.class;
    private Object data;
    private Class type;
    private String typecode;
    private ArrayDelegate delegate;

    public static void typeSetup(PyObject pyObject, PyType.Newstyle newstyle) {
        class Exposed___ne__
        extends PyBuiltinMethodNarrow {
            Exposed___ne__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___ne__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyArray)this.self).seq___ne__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__ne__", (PyObject)new PyMethodDescr("__ne__", PyArray.class, 1, 1, new Exposed___ne__(null, null)));
        class Exposed___eq__
        extends PyBuiltinMethodNarrow {
            Exposed___eq__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___eq__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyArray)this.self).seq___eq__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__eq__", (PyObject)new PyMethodDescr("__eq__", PyArray.class, 1, 1, new Exposed___eq__(null, null)));
        class Exposed___lt__
        extends PyBuiltinMethodNarrow {
            Exposed___lt__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___lt__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyArray)this.self).seq___lt__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__lt__", (PyObject)new PyMethodDescr("__lt__", PyArray.class, 1, 1, new Exposed___lt__(null, null)));
        class Exposed___le__
        extends PyBuiltinMethodNarrow {
            Exposed___le__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___le__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyArray)this.self).seq___le__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__le__", (PyObject)new PyMethodDescr("__le__", PyArray.class, 1, 1, new Exposed___le__(null, null)));
        class Exposed___gt__
        extends PyBuiltinMethodNarrow {
            Exposed___gt__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___gt__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyArray)this.self).seq___gt__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__gt__", (PyObject)new PyMethodDescr("__gt__", PyArray.class, 1, 1, new Exposed___gt__(null, null)));
        class Exposed___ge__
        extends PyBuiltinMethodNarrow {
            Exposed___ge__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___ge__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyArray)this.self).seq___ge__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__ge__", (PyObject)new PyMethodDescr("__ge__", PyArray.class, 1, 1, new Exposed___ge__(null, null)));
        class Exposed___getitem__
        extends PyBuiltinMethodNarrow {
            Exposed___getitem__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___getitem__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyArray)this.self).seq___finditem__(pyObject);
                if (pyObject2 == null) {
                    throw Py.IndexError("index out of range: " + pyObject);
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__getitem__", (PyObject)new PyMethodDescr("__getitem__", PyArray.class, 1, 1, new Exposed___getitem__(null, null)));
        class Exposed___contains__
        extends PyBuiltinMethodNarrow {
            Exposed___contains__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___contains__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                return Py.newBoolean(((PyArray)this.self).object___contains__(pyObject));
            }
        }
        pyObject.__setitem__("__contains__", (PyObject)new PyMethodDescr("__contains__", PyArray.class, 1, 1, new Exposed___contains__(null, null)));
        class Exposed___delitem__
        extends PyBuiltinMethodNarrow {
            Exposed___delitem__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___delitem__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                ((PyArray)this.self).seq___delitem__(pyObject);
                return Py.None;
            }
        }
        pyObject.__setitem__("__delitem__", (PyObject)new PyMethodDescr("__delitem__", PyArray.class, 1, 1, new Exposed___delitem__(null, null)));
        class Exposed___setitem__
        extends PyBuiltinMethodNarrow {
            Exposed___setitem__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___setitem__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                ((PyArray)this.self).seq___setitem__(pyObject, pyObject2);
                return Py.None;
            }
        }
        pyObject.__setitem__("__setitem__", (PyObject)new PyMethodDescr("__setitem__", PyArray.class, 2, 2, new Exposed___setitem__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinMethodNarrow {
            Exposed___nonzero__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___nonzero__(pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(((PyArray)this.self).seq___nonzero__());
            }
        }
        pyObject.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyArray.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___getslice__
        extends PyBuiltinMethodNarrow {
            Exposed___getslice__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___getslice__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
                return ((PyArray)this.self).seq___getslice__(pyObject, pyObject2, pyObject3);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                return ((PyArray)this.self).seq___getslice__(pyObject, pyObject2);
            }
        }
        pyObject.__setitem__("__getslice__", (PyObject)new PyMethodDescr("__getslice__", PyArray.class, 2, 3, new Exposed___getslice__(null, null)));
        class Exposed___delslice__
        extends PyBuiltinMethodNarrow {
            Exposed___delslice__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___delslice__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
                ((PyArray)this.self).seq___delslice__(pyObject, pyObject2, pyObject3);
                return Py.None;
            }
        }
        pyObject.__setitem__("__delslice__", (PyObject)new PyMethodDescr("__delslice__", PyArray.class, 3, 3, new Exposed___delslice__(null, null)));
        class Exposed___setslice__
        extends PyBuiltinMethodNarrow {
            Exposed___setslice__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___setslice__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
                ((PyArray)this.self).seq___setslice__(pyObject, pyObject2, pyObject3, pyObject4);
                return Py.None;
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
                ((PyArray)this.self).seq___setslice__(pyObject, pyObject2, pyObject3);
                return Py.None;
            }
        }
        pyObject.__setitem__("__setslice__", (PyObject)new PyMethodDescr("__setslice__", PyArray.class, 3, 4, new Exposed___setslice__(null, null)));
        pyObject.__setitem__("itemsize", (PyObject)new PyGetSetDescr("itemsize", PyArray.class, "getItemsize", null, null));
        pyObject.__setitem__("typecode", (PyObject)new PyGetSetDescr("typecode", PyArray.class, "getTypecode", null, null));
        class Exposed_append
        extends PyBuiltinMethodNarrow {
            Exposed_append(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_append(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                ((PyArray)this.self).array_append(pyObject);
                return Py.None;
            }
        }
        pyObject.__setitem__("append", (PyObject)new PyMethodDescr("append", PyArray.class, 1, 1, new Exposed_append(null, null)));
        class Exposed_byteswap
        extends PyBuiltinMethodNarrow {
            Exposed_byteswap(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_byteswap(pyObject, this.info);
            }

            public PyObject __call__() {
                ((PyArray)this.self).array_byteswap();
                return Py.None;
            }
        }
        pyObject.__setitem__("byteswap", (PyObject)new PyMethodDescr("byteswap", PyArray.class, 0, 0, new Exposed_byteswap(null, null)));
        class Exposed_count
        extends PyBuiltinMethodNarrow {
            Exposed_count(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_count(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                return Py.newInteger(((PyArray)this.self).array_count(pyObject));
            }
        }
        pyObject.__setitem__("count", (PyObject)new PyMethodDescr("count", PyArray.class, 1, 1, new Exposed_count(null, null)));
        class Exposed_extend
        extends PyBuiltinMethodNarrow {
            Exposed_extend(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_extend(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                ((PyArray)this.self).array_extend(pyObject);
                return Py.None;
            }
        }
        pyObject.__setitem__("extend", (PyObject)new PyMethodDescr("extend", PyArray.class, 1, 1, new Exposed_extend(null, null)));
        class Exposed_fromfile
        extends PyBuiltinMethodNarrow {
            Exposed_fromfile(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_fromfile(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                try {
                    ((PyArray)this.self).array_fromfile(pyObject, pyObject2.asInt(1));
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 1: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }
        }
        pyObject.__setitem__("fromfile", (PyObject)new PyMethodDescr("fromfile", PyArray.class, 2, 2, new Exposed_fromfile(null, null)));
        class Exposed_fromlist
        extends PyBuiltinMethodNarrow {
            Exposed_fromlist(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_fromlist(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                ((PyArray)this.self).array_fromlist(pyObject);
                return Py.None;
            }
        }
        pyObject.__setitem__("fromlist", (PyObject)new PyMethodDescr("fromlist", PyArray.class, 1, 1, new Exposed_fromlist(null, null)));
        class Exposed_index
        extends PyBuiltinMethodNarrow {
            Exposed_index(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_index(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                return Py.newInteger(((PyArray)this.self).array_index(pyObject));
            }
        }
        pyObject.__setitem__("index", (PyObject)new PyMethodDescr("index", PyArray.class, 1, 1, new Exposed_index(null, null)));
        class Exposed_insert
        extends PyBuiltinMethodNarrow {
            Exposed_insert(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_insert(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                try {
                    ((PyArray)this.self).array_insert(pyObject.asInt(0), pyObject2);
                    return Py.None;
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }
        }
        pyObject.__setitem__("insert", (PyObject)new PyMethodDescr("insert", PyArray.class, 2, 2, new Exposed_insert(null, null)));
        class Exposed_pop
        extends PyBuiltinMethodNarrow {
            Exposed_pop(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_pop(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                try {
                    return ((PyArray)this.self).array_pop(pyObject.asInt(0));
                }
                catch (PyObject.ConversionException conversionException) {
                    String string;
                    switch (conversionException.index) {
                        case 0: {
                            string = "expected an integer";
                            break;
                        }
                        default: {
                            string = "xxx";
                        }
                    }
                    throw Py.TypeError(string);
                }
            }

            public PyObject __call__() {
                return ((PyArray)this.self).array_pop();
            }
        }
        pyObject.__setitem__("pop", (PyObject)new PyMethodDescr("pop", PyArray.class, 0, 1, new Exposed_pop(null, null)));
        class Exposed_remove
        extends PyBuiltinMethodNarrow {
            Exposed_remove(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_remove(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                ((PyArray)this.self).array_remove(pyObject);
                return Py.None;
            }
        }
        pyObject.__setitem__("remove", (PyObject)new PyMethodDescr("remove", PyArray.class, 1, 1, new Exposed_remove(null, null)));
        class Exposed_reverse
        extends PyBuiltinMethodNarrow {
            Exposed_reverse(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_reverse(pyObject, this.info);
            }

            public PyObject __call__() {
                ((PyArray)this.self).array_reverse();
                return Py.None;
            }
        }
        pyObject.__setitem__("reverse", (PyObject)new PyMethodDescr("reverse", PyArray.class, 0, 0, new Exposed_reverse(null, null)));
        class Exposed_tofile
        extends PyBuiltinMethodNarrow {
            Exposed_tofile(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_tofile(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                ((PyArray)this.self).array_tofile(pyObject);
                return Py.None;
            }
        }
        pyObject.__setitem__("tofile", (PyObject)new PyMethodDescr("tofile", PyArray.class, 1, 1, new Exposed_tofile(null, null)));
        class Exposed_tolist
        extends PyBuiltinMethodNarrow {
            Exposed_tolist(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_tolist(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyArray)this.self).array_tolist();
            }
        }
        pyObject.__setitem__("tolist", (PyObject)new PyMethodDescr("tolist", PyArray.class, 0, 0, new Exposed_tolist(null, null)));
        class Exposed_tostring
        extends PyBuiltinMethodNarrow {
            Exposed_tostring(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_tostring(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyArray)this.self).array_tostring();
            }
        }
        pyObject.__setitem__("tostring", (PyObject)new PyMethodDescr("tostring", PyArray.class, 0, 0, new Exposed_tostring(null, null)));
        class Exposed_write
        extends PyBuiltinMethodNarrow {
            Exposed_write(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed_write(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                ((PyArray)this.self).array_write(pyObject);
                return Py.None;
            }
        }
        pyObject.__setitem__("write", (PyObject)new PyMethodDescr("write", PyArray.class, 1, 1, new Exposed_write(null, null)));
        class Exposed___init__
        extends PyBuiltinMethod {
            Exposed___init__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___init__(pyObject, this.info);
            }

            public PyObject __call__(PyObject[] pyObjectArray) {
                return this.__call__(pyObjectArray, Py.NoKeywords);
            }

            public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
                ((PyArray)this.self).array_init(pyObjectArray, stringArray);
                return Py.None;
            }
        }
        pyObject.__setitem__("__init__", (PyObject)new PyMethodDescr("__init__", PyArray.class, -1, -1, new Exposed___init__(null, null)));
        pyObject.__setitem__("__new__", (PyObject)new PyNewWrapper(PyArray.class, "__new__", -1, -1){

            public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
                PyArray pyArray;
                if (this.for_type == pyType) {
                    pyArray = new PyArray();
                    if (bl) {
                        pyArray.array_init(pyObjectArray, stringArray);
                    }
                } else {
                    pyArray = new PyArrayDerived(pyType);
                }
                return pyArray;
            }
        });
    }

    private PyArray() {
    }

    public PyArray(PyType pyType) {
        super(pyType);
    }

    public PyArray(PyArray pyArray) {
        this.data = pyArray.delegate.copyArray();
        this.delegate = new ArrayDelegate(this);
        this.type = pyArray.type;
    }

    public PyArray(Class clazz, Object object) {
        this.type = clazz;
        this.data = object;
        this.delegate = new ArrayDelegate(this);
    }

    public PyArray(Class clazz, int n) {
        this(clazz, Array.newInstance(clazz, n));
    }

    private void array_init(PyObject[] pyObjectArray, String[] stringArray) {
        Object object;
        ArgParser argParser = new ArgParser(exposed_name, pyObjectArray, stringArray, new String[]{"typecode", "seq"}, 1);
        PyObject pyObject = argParser.getPyObject(0);
        if (pyObject instanceof PyString) {
            object = pyObject.toString();
            if (((String)object).length() != 1) {
                throw Py.ValueError("typecode must be in [zcbhilfd]");
            }
            this.type = PyArray.char2class(((String)object).charAt(0));
            this.typecode = object;
        } else if (pyObject instanceof PyJavaClass) {
            this.type = ((PyJavaClass)pyObject).proxyClass;
            this.typecode = this.type.getName();
        }
        this.data = Array.newInstance(this.type, 0);
        this.delegate = new ArrayDelegate(this);
        object = argParser.getPyObject(1, null);
        if (object == null) {
            return;
        }
        this.extendInternal((PyObject)object);
    }

    public static PyArray zeros(int n, char c) {
        PyArray pyArray = PyArray.zeros(n, PyArray.char2class(c));
        pyArray.typecode = "" + c;
        return pyArray;
    }

    public static PyArray zeros(int n, Class clazz) {
        PyArray pyArray = new PyArray(clazz, n);
        pyArray.typecode = clazz.getName();
        return pyArray;
    }

    public static PyArray array(PyObject pyObject, char c) {
        PyArray pyArray = PyArray.array(pyObject, PyArray.char2class(c));
        pyArray.typecode = "" + c;
        return pyArray;
    }

    public static PyArray array(PyObject pyObject, Class clazz) {
        PyArray pyArray = new PyArray(clazz, 0);
        pyArray.typecode = clazz.getName();
        pyArray.extendInternal(pyObject);
        return pyArray;
    }

    public PyObject __add__(PyObject pyObject) {
        PyArray pyArray = null;
        if (!(pyObject instanceof PyArray)) {
            throw Py.TypeError("can only append another array to an array");
        }
        pyArray = (PyArray)pyObject;
        if (!pyArray.type.equals(this.type)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + pyArray.type);
        }
        PyArray pyArray2 = new PyArray(this);
        pyArray2.delegate.appendArray(pyArray.delegate.copyArray());
        return pyArray2;
    }

    public PyObject __findattr__(String string) {
        if ("typecode".equals(string)) {
            return new PyString(this.getTypecode());
        }
        return super.__findattr__(string);
    }

    public int __len__() {
        return this.delegate.getSize();
    }

    public PyString __repr__() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("array(").append(PyArray.class2char(this.type)).append(",[");
        for (int i = 0; i < this.__len__() - 1; ++i) {
            stringBuffer.append(this.pyget(i).__repr__().toString());
            stringBuffer.append(", ");
        }
        if (this.__len__() > 0) {
            stringBuffer.append(this.pyget(this.__len__() - 1).__repr__().toString());
        }
        stringBuffer.append("]) ");
        return new PyString(stringBuffer.toString());
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Object.class || clazz.isArray() && clazz.getComponentType().isAssignableFrom(this.type)) {
            return this.data;
        }
        if (clazz.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    public void array_append(PyObject pyObject) {
        this.append(pyObject);
    }

    public void append(PyObject pyObject) {
        int n = this.delegate.getSize();
        this.delegate.makeInsertSpace(n);
        try {
            this.set(n, pyObject);
        }
        catch (PyException pyException) {
            this.delegate.setSize(n);
            throw new PyException(pyException.type, pyException.value);
        }
    }

    public void array_byteswap() {
        this.byteswap();
    }

    public void byteswap() {
        if (this.getItemsize() == 0) {
            throw Py.RuntimeError("don't know how to byteswap this array type");
        }
        ByteSwapper.swap(this.data);
    }

    public Object clone() {
        return new PyArray(this);
    }

    public static Class char2class(char c) throws PyIgnoreMethodTag {
        switch (c) {
            case 'z': {
                return Boolean.TYPE;
            }
            case 'c': {
                return Character.TYPE;
            }
            case 'b': {
                return Byte.TYPE;
            }
            case 'h': {
                return Short.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'f': {
                return Float.TYPE;
            }
            case 'd': {
                return Double.TYPE;
            }
        }
        throw Py.ValueError("typecode must be in [zcbhilfd]");
    }

    private static String class2char(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return "'z'";
        }
        if (clazz.equals(Character.TYPE)) {
            return "'c'";
        }
        if (clazz.equals(Byte.TYPE)) {
            return "'b'";
        }
        if (clazz.equals(Short.TYPE)) {
            return "'h'";
        }
        if (clazz.equals(Integer.TYPE)) {
            return "'i'";
        }
        if (clazz.equals(Long.TYPE)) {
            return "'l'";
        }
        if (clazz.equals(Float.TYPE)) {
            return "'f'";
        }
        if (clazz.equals(Double.TYPE)) {
            return "'d'";
        }
        return clazz.getName();
    }

    public int array_count(PyObject pyObject) {
        int n = 0;
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!pyObject.equals(Py.java2py(Array.get(this.data, i)))) continue;
            ++n;
        }
        return n;
    }

    public PyInteger count(PyObject pyObject) {
        return Py.newInteger(this.array_count(pyObject));
    }

    protected void del(int n) {
        this.delegate.remove(n);
    }

    protected void delRange(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        if (n3 == 1) {
            this.delegate.remove(n, n2);
        } else {
            int n4 = PyArray.sliceLength(n, n2, n3);
            int n5 = n;
            for (int i = 0; i < n4; ++i) {
                this.delegate.remove(n5);
                n5 += n3;
            }
        }
    }

    public void array_extend(PyObject pyObject) {
        this.extendInternal(pyObject);
    }

    public void extend(PyObject pyObject) {
        this.extendInternal(pyObject);
    }

    private void extendInternal(PyObject pyObject) {
        if (pyObject instanceof PyString) {
            this.fromstring(((PyString)pyObject).toString());
        } else if (pyObject instanceof PyArray) {
            PyArray pyArray = (PyArray)pyObject;
            if (!pyArray.type.equals(this.type)) {
                throw Py.TypeError("can only extend with an array of the same kind");
            }
            this.delegate.appendArray(pyArray.delegate.copyArray());
        } else {
            this.extendInternalIter(pyObject);
        }
    }

    private void extendInternalIter(PyObject pyObject) {
        PyObject pyObject2 = pyObject.__iter__();
        PyObject pyObject3 = null;
        if (pyObject.__findattr__("__len__") == null) {
            int n = 0;
            while ((pyObject3 = pyObject2.__iternext__()) != null) {
                this.append(pyObject3);
                ++n;
            }
        } else {
            int n = this.delegate.getSize();
            this.delegate.ensureCapacity(n + pyObject.__len__());
            int n2 = n;
            while ((pyObject3 = pyObject2.__iternext__()) != null) {
                this.set(n2, pyObject3);
                ++this.delegate.size;
                ++n2;
            }
        }
    }

    private void array_fromfile(PyObject pyObject, int n) {
        this.fromfile(pyObject, n);
    }

    public void fromfile(PyObject pyObject, int n) {
        if (!(pyObject instanceof PyFile)) {
            throw Py.TypeError("arg1 must be open file");
        }
        PyFile pyFile = (PyFile)pyObject;
        if (pyFile.mode.indexOf("r") == -1) {
            throw Py.TypeError("file needs to be in read mode");
        }
        int n2 = n * this.getItemsize();
        String string = pyFile.read(n2).toString();
        this.fromstring(string);
        if (string.length() < n2) {
            int n3 = string.length() / this.getItemsize();
            throw Py.EOFError("not enough items in file. " + Integer.toString(n) + " requested, " + Integer.toString(n3) + " actually read");
        }
    }

    public void array_fromlist(PyObject pyObject) {
        this.fromlist(pyObject);
    }

    public void fromlist(PyObject pyObject) {
        if (!(pyObject instanceof PyList)) {
            throw Py.TypeError("expected list argument");
        }
        int n = this.delegate.getSize();
        try {
            this.extendInternalIter(pyObject);
        }
        catch (PyException pyException) {
            this.delegate.setSize(n);
            throw new PyException(pyException.type, pyException.value);
        }
    }

    private int fromStream(InputStream inputStream) throws IOException, EOFException {
        return this.fromStream(inputStream, inputStream.available() / this.getItemsize());
    }

    private int fromStream(InputStream inputStream, int n) throws IOException, EOFException {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n3 = n2 = this.delegate.getSize();
        this.delegate.ensureCapacity(n3 + n);
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                int n4 = 0;
                while (n4 < n) {
                    Array.setBoolean(this.data, n3, dataInputStream.readBoolean());
                    ++this.delegate.size;
                    ++n4;
                    ++n3;
                }
            } else if (this.type == Byte.TYPE) {
                int n5 = 0;
                while (n5 < n) {
                    Array.setByte(this.data, n3, dataInputStream.readByte());
                    ++this.delegate.size;
                    ++n5;
                    ++n3;
                }
            } else if (this.type == Character.TYPE) {
                int n6 = 0;
                while (n6 < n) {
                    Array.setChar(this.data, n3, (char)dataInputStream.readByte());
                    ++this.delegate.size;
                    ++n6;
                    ++n3;
                }
            } else if (this.type == Integer.TYPE) {
                int n7 = 0;
                while (n7 < n) {
                    Array.setInt(this.data, n3, dataInputStream.readInt());
                    ++this.delegate.size;
                    ++n7;
                    ++n3;
                }
            } else if (this.type == Short.TYPE) {
                int n8 = 0;
                while (n8 < n) {
                    Array.setShort(this.data, n3, dataInputStream.readShort());
                    ++this.delegate.size;
                    ++n8;
                    ++n3;
                }
            } else if (this.type == Long.TYPE) {
                int n9 = 0;
                while (n9 < n) {
                    Array.setLong(this.data, n3, dataInputStream.readLong());
                    ++this.delegate.size;
                    ++n9;
                    ++n3;
                }
            } else if (this.type == Float.TYPE) {
                int n10 = 0;
                while (n10 < n) {
                    Array.setFloat(this.data, n3, dataInputStream.readFloat());
                    ++this.delegate.size;
                    ++n10;
                    ++n3;
                }
            } else if (this.type == Double.TYPE) {
                int n11 = 0;
                while (n11 < n) {
                    Array.setDouble(this.data, n3, dataInputStream.readDouble());
                    ++this.delegate.size;
                    ++n11;
                    ++n3;
                }
            }
        }
        dataInputStream.close();
        return n3 - n2;
    }

    public void fromstring(String string) {
        int n = this.getItemsize();
        int n2 = string.length();
        if (n2 % n != 0) {
            throw Py.ValueError("string length not a multiple of item size");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(PyString.to_bytes(string));
        int n3 = this.delegate.getSize();
        try {
            this.fromStream(byteArrayInputStream);
        }
        catch (EOFException eOFException) {
            throw Py.EOFError("not enough items in string");
        }
        catch (IOException iOException) {
            this.delegate.setSize(n3);
            throw Py.IOError(iOException);
        }
    }

    protected PyObject pyget(int n) {
        return Py.java2py(Array.get(this.data, n));
    }

    public Object getArray() throws PyIgnoreMethodTag {
        return this.delegate.copyArray();
    }

    public int getItemsize() {
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                return 1;
            }
            if (this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE) {
                return 1;
            }
            if (this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE) {
                return 8;
            }
            if (this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Double.TYPE) {
                return 8;
            }
        }
        return 0;
    }

    protected PyObject getslice(int n, int n2, int n3) {
        if (n3 > 0 && n2 < n) {
            n2 = n;
        }
        int n4 = PyArray.sliceLength(n, n2, n3);
        PyArray pyArray = new PyArray(this.type, n4);
        if (n3 == 1) {
            System.arraycopy(this.data, n, pyArray.data, 0, n4);
            return pyArray;
        }
        int n5 = n;
        for (int i = 0; i < n4; ++i) {
            Array.set(pyArray.data, i, Array.get(this.data, n5));
            n5 += n3;
        }
        return pyArray;
    }

    public String getTypecode() throws PyIgnoreMethodTag {
        return this.typecode;
    }

    public int array_index(PyObject pyObject) {
        int n = this.indexInternal(pyObject);
        if (n != -1) {
            return n;
        }
        throw Py.ValueError("array.index(" + pyObject + "): " + pyObject + " not found in array");
    }

    public PyObject index(PyObject pyObject) {
        return Py.newInteger(this.array_index(pyObject));
    }

    private int indexInternal(PyObject pyObject) {
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            if (!pyObject.equals(Py.java2py(Array.get(this.data, i)))) continue;
            return i;
        }
        return -1;
    }

    public void array_insert(int n, PyObject pyObject) {
        this.insert(n, pyObject);
    }

    public void insert(int n, PyObject pyObject) {
        this.delegate.makeInsertSpace(n);
        Array.set(this.data, n, Py.tojava(pyObject, this.type));
    }

    public PyObject array_pop() {
        return this.pop();
    }

    public PyObject array_pop(int n) {
        return this.pop(n);
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        n = n < 0 ? this.delegate.getSize() + n : n;
        PyObject pyObject = Py.java2py(Array.get(this.data, n));
        this.delegate.remove(n);
        return pyObject;
    }

    public void array_remove(PyObject pyObject) {
        this.remove(pyObject);
    }

    public void remove(PyObject pyObject) {
        int n = this.indexInternal(pyObject);
        if (n != -1) {
            this.delegate.remove(n);
            return;
        }
        throw Py.ValueError("array.remove(" + pyObject + "): " + pyObject + " not found in array");
    }

    protected PyObject repeat(int n) {
        Object object = this.delegate.copyArray();
        PyArray pyArray = new PyArray(this.type, 0);
        for (int i = 0; i < n; ++i) {
            pyArray.delegate.appendArray(object);
        }
        return pyArray;
    }

    public void array_reverse() {
        this.reverse();
    }

    public void reverse() {
        Object object = Array.newInstance(this.type, Array.getLength(this.data));
        int n = this.delegate.getSize() - 1;
        for (int i = 0; i <= n; ++i) {
            Array.set(object, n - i, Array.get(this.data, i));
        }
        this.data = object;
    }

    protected void set(int n, PyObject pyObject) {
        Object object;
        if (this.type == Byte.TYPE) {
            long l;
            try {
                l = (Long)pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (l < -128L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (l > 127L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Short.TYPE) {
            long l;
            try {
                l = (Long)pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (l < -32768L) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (l > 32767L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Integer.TYPE) {
            long l;
            try {
                l = (Long)pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (l < Integer.MIN_VALUE) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (l > Integer.MAX_VALUE) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Long.TYPE) {
            Object object2;
            try {
                object2 = pyObject.__tojava__(Long.TYPE);
            }
            catch (ClassCastException classCastException) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (object2 == Py.NoConversion) {
                throw Py.OverflowError("value out of range for long");
            }
        }
        if ((object = Py.tojava(pyObject, this.type)) == Py.NoConversion) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.set(this.data, n, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setslice(int n, int n2, int n3, PyObject pyObject) {
        if (this.type == Character.TYPE && pyObject instanceof PyString) {
            char[] cArray = null;
            if (n3 != 1) {
                throw Py.ValueError("invalid bounds for setting from string");
            }
            cArray = pyObject.toString().toCharArray();
            int n4 = cArray.length - (n2 - n);
            if (n4 > 0) {
                this.delegate.makeInsertSpace(n, n4);
            } else if (n4 < 0) {
                this.delegate.remove(n, -n4 + n - 1);
            }
            this.delegate.replaceSubArray(cArray, n);
            return;
        }
        if (pyObject instanceof PyString && this.type == Byte.TYPE) {
            byte[] byArray = ((PyString)pyObject).toBytes();
            if (byArray.length != n2 - n || n3 != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(byArray, 0, this.data, n, byArray.length);
            return;
        }
        if (!(pyObject instanceof PyArray)) return;
        PyArray pyArray = (PyArray)pyObject;
        int n5 = pyArray.delegate.getSize() - (n2 - n);
        Object object = pyArray.delegate.copyArray();
        if (n5 > 0) {
            this.delegate.makeInsertSpace(n, n5);
        } else if (n5 < 0) {
            this.delegate.remove(n, -n5 + n - 1);
        }
        try {
            this.delegate.replaceSubArray(object, n);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Py.TypeError("Slice typecode '" + pyArray.typecode + "' is not compatible with this array (typecode '" + this.typecode + "')");
        }
    }

    public void array_tofile(PyObject pyObject) {
        this.tofile(pyObject);
    }

    public void array_write(PyObject pyObject) {
        this.tofile(pyObject);
    }

    public void tofile(PyObject pyObject) {
        if (!(pyObject instanceof PyFile)) {
            throw Py.TypeError("arg must be open file");
        }
        PyFile pyFile = (PyFile)pyObject;
        if (pyFile.mode.indexOf("w") == -1 && pyFile.mode.indexOf("a") == -1) {
            throw Py.TypeError("file needs to be in write or append mode");
        }
        pyFile.write(this.tostring());
    }

    public PyObject array_tolist() {
        return this.tolist();
    }

    public PyObject tolist() {
        PyList pyList = new PyList();
        for (int i = 0; i < this.delegate.getSize(); ++i) {
            pyList.append(Py.java2py(Array.get(this.data, i)));
        }
        return pyList;
    }

    private int toStream(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream;
        block8: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        dataOutputStream = new DataOutputStream(outputStream);
                                        if (!this.type.isPrimitive()) break block8;
                                        if (this.type != Boolean.TYPE) break block9;
                                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                                            dataOutputStream.writeBoolean(Array.getBoolean(this.data, i));
                                        }
                                        break block8;
                                    }
                                    if (this.type != Byte.TYPE) break block10;
                                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                                        dataOutputStream.writeByte(Array.getByte(this.data, i));
                                    }
                                    break block8;
                                }
                                if (this.type != Character.TYPE) break block11;
                                for (int i = 0; i < this.delegate.getSize(); ++i) {
                                    dataOutputStream.writeByte((byte)Array.getChar(this.data, i));
                                }
                                break block8;
                            }
                            if (this.type != Integer.TYPE) break block12;
                            for (int i = 0; i < this.delegate.getSize(); ++i) {
                                dataOutputStream.writeInt(Array.getInt(this.data, i));
                            }
                            break block8;
                        }
                        if (this.type != Short.TYPE) break block13;
                        for (int i = 0; i < this.delegate.getSize(); ++i) {
                            dataOutputStream.writeShort(Array.getShort(this.data, i));
                        }
                        break block8;
                    }
                    if (this.type != Long.TYPE) break block14;
                    for (int i = 0; i < this.delegate.getSize(); ++i) {
                        dataOutputStream.writeLong(Array.getLong(this.data, i));
                    }
                    break block8;
                }
                if (this.type != Float.TYPE) break block15;
                for (int i = 0; i < this.delegate.getSize(); ++i) {
                    dataOutputStream.writeFloat(Array.getFloat(this.data, i));
                }
                break block8;
            }
            if (this.type != Double.TYPE) break block8;
            for (int i = 0; i < this.delegate.getSize(); ++i) {
                dataOutputStream.writeDouble(Array.getDouble(this.data, i));
            }
        }
        return dataOutputStream.size();
    }

    public PyObject array_tostring() {
        return new PyString(this.tostring());
    }

    public String tostring() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.toStream(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        return PyString.from_bytes(byteArrayOutputStream.toByteArray());
    }

    private class ArrayDelegate
    extends AbstractArray {
        final PyArray pyArray;

        private ArrayDelegate(PyArray pyArray2) {
            super(pyArray2.data == null ? 0 : Array.getLength(pyArray2.data));
            this.pyArray = pyArray2;
        }

        protected Object getArray() {
            return this.pyArray.data;
        }

        protected void setArray(Object object) {
            this.pyArray.data = object;
        }

        protected void makeInsertSpace(int n) {
            super.makeInsertSpace(n, 1);
        }

        protected void makeInsertSpace(int n, int n2) {
            super.makeInsertSpace(n, n2);
        }

        public void remove(int n) {
            super.remove(n);
        }
    }
}

