/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.net.InetAddress;
import java.net.ServerSocket;

public class BindTest {
    static String usage = "java BindTest -ip 127.0.0.1 -port 7001";
    static String[] args;
    int port;
    String ipAddrString;

    public static void main(String[] stringArray) {
        BindTest bindTest = new BindTest();
        args = stringArray;
        bindTest.parseArgs();
        bindTest.bind();
    }

    public void bind() {
        ServerSocket serverSocket = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.ipAddrString);
        }
        catch (Exception exception) {
            this.exit(exception, "\nError getting Address : " + this.ipAddrString);
        }
        try {
            serverSocket = new ServerSocket(this.port, 50, inetAddress);
        }
        catch (Exception exception) {
            this.exit(exception, "\nException binding to port : " + this.port + " on : " + this.ipAddrString);
        }
        System.out.println("Success!  Bound to " + this.ipAddrString + ":" + this.port);
    }

    public void parseArgs() {
        if (args == null || args.length == 0 || args.length < 4) {
            this.exit(usage);
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                if (args[i].equals("-port")) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(args[++i]);
                    }
                    catch (Exception exception) {
                        this.exit("Error parsing port arg : " + exception.toString() + "\n" + usage);
                    }
                    this.port = n;
                    continue;
                }
                if (!args[i].equals("-ip")) continue;
                this.ipAddrString = args[++i];
                continue;
            }
            catch (Exception exception) {
                this.exit("Error parsing args : " + exception.toString() + "\n" + usage);
            }
        }
    }

    void exit() {
        this.exit(null);
    }

    void exit(String string) {
        this.exit(null, string);
    }

    void exit(Throwable throwable, String string) {
        if (string != null) {
            System.out.println(string);
            System.out.println("");
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
        System.exit(-1);
    }
}

