/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.certicom.security.cert.internal.x509.PKCS8;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_KeyPair;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import utils.der2pem;
import weblogic.management.bootstrap.BootStrap;
import weblogic.security.internal.encryption.JSafeEncryptionServiceImpl;
import weblogic.utils.encoders.BASE64Decoder;

public class CertGen {
    public static final String COUNTRY_PROPERTY = "x500name.country";
    public static final String STATE_PROPERTY = "x500name.state";
    public static final String LOCALITY_PROPERTY = "x500name.town";
    public static final String ORGANIZATION_PROPERTY = "x500name.organization";
    public static final String ORG_UNIT_PROPERTY = "x500name.orgunit";
    public static final String COMMON_NAME_PROPERTY = "x500name.commonname";
    public static final String EMAIL_PROPERTY = "x500name.email";
    private static final String DEFAULT_COUNTRY = "US";
    private static final String DEFAULT_STATE = "MyState";
    private static final String DEFAULT_LOCALITY = "MyTown";
    private static final String DEFAULT_ORGANIZATION = "MyOrganization";
    private static final String DEFAULT_ORG_UNIT = "FOR TESTING ONLY";
    private static final String DEFAULT_COMMON_NAME = "localhost";
    private static final String DEFAULT_CA_CERT = "CertGenCA.der";
    private static final String DEFAULT_CA_KEY = "CertGenCAKey.der";
    private static final String DEFAULT_CA_PWD = "password";
    private static final int CERT_YEARS_VALID = 15;
    private static final int CA_YEARS_VALID = 20;
    private static final int EXPORT_KEY_STRENGTH = 512;
    private static final int DOMESTIC_KEY_STRENGTH = 1024;
    private static final String[] KEY_USAGE_NAMES = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
    private static final int[] KEY_USAGE_BITS = new int[]{Integer.MIN_VALUE, 0x40000000, 0x20000000, 0x10000000, 0x8000000, 0x4000000, 0x2000000, 0x1000000, 0x800000};
    private JSAFE_SecureRandom random = (JSAFE_SecureRandom)JSAFE_SecureRandom.getInstance((String)"FIPS186Random", (String)"Java");
    private JSAFE_PrivateKey issuerPrivateKey;
    private X500Name issuerName;
    private JSAFE_PrivateKey subjectPrivateKey;
    private JSAFE_PublicKey subjectPublicKey;
    private X500Name subjectName;
    private X509Certificate subjectCert;
    private int keyStrength = 1024;
    private KeyUsage keyUsage = null;
    private SubjectKeyID subjectKeyIdentifier = null;

    public CertGen(boolean bl) throws Exception {
        this(bl ? 512 : 1024);
    }

    public CertGen(int n) throws Exception {
        this.random.seed(CertGen.generateSeed());
        this.keyStrength = n;
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.subjectKeyIdentifier = byArray != null ? new SubjectKeyID(byArray, 0, byArray.length, false) : null;
    }

    public void setKeyUsage(int n, boolean bl) {
        this.keyUsage = new KeyUsage(n, bl);
    }

    public PrivateKey getSubjectPrivateKey() throws Exception {
        return CertGen.convert(this.subjectPrivateKey);
    }

    public Certificate getSubjectCertificate() throws Exception {
        return CertGen.convert(this.subjectCert);
    }

    private static byte[] generateSeed() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IDH").append(System.identityHashCode(stringBuffer));
        stringBuffer.append("FM").append(Runtime.getRuntime().freeMemory());
        stringBuffer.append("CT").append(System.currentTimeMillis());
        Enumeration<Object> enumeration = System.getProperties().elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement());
        }
        stringBuffer.append("VHC").append(stringBuffer.hashCode());
        return stringBuffer.toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateKeys() throws Exception {
        JSAFE_KeyPair jSAFE_KeyPair = JSAFE_KeyPair.getInstance((String)"RSA", (String)"Java");
        try {
            int[] nArray = new int[]{this.keyStrength, 65537};
            jSAFE_KeyPair.generateInit(null, nArray, (SecureRandom)this.random);
            jSAFE_KeyPair.generate();
            this.subjectPublicKey = jSAFE_KeyPair.getPublicKey();
            this.subjectPrivateKey = jSAFE_KeyPair.getPrivateKey();
        }
        finally {
            if (jSAFE_KeyPair != null) {
                jSAFE_KeyPair.clearSensitiveData();
            }
        }
    }

    private void generateSubject(Properties properties) throws Exception {
        this.generateKeys();
        this.subjectName = CertGen.createX500Name(properties);
    }

    public void generateCACertificate(Properties properties) throws Exception {
        this.generateSubject(properties);
        this.issuerPrivateKey = this.subjectPrivateKey;
        this.issuerName = this.subjectName;
        CertGen.checkForConflictingKeyUsage(this.keyUsage);
        this.generateCertificate(true);
    }

    public void generateCertificate(Properties properties) throws Exception {
        this.generateCertificate(properties, CertGen.findFile(DEFAULT_CA_CERT), CertGen.findFile(DEFAULT_CA_KEY), DEFAULT_CA_PWD);
    }

    public void generateCertificate(Properties properties, String string, String string2, String string3) throws Exception {
        X509Certificate x509Certificate = CertGen.loadX509Certificate(string);
        JSAFE_PrivateKey jSAFE_PrivateKey = CertGen.loadPKCS8PrivateKey(string2, string3);
        this.generateCertificate(properties, x509Certificate, jSAFE_PrivateKey);
    }

    public void generateCertificate(Properties properties, X509Certificate x509Certificate, JSAFE_PrivateKey jSAFE_PrivateKey) throws Exception {
        this.generateSubject(properties);
        this.issuerName = x509Certificate.getSubjectName();
        this.issuerPrivateKey = jSAFE_PrivateKey;
        CertGen.checkCAKeyUsage(x509Certificate);
        CertGen.checkForConflictingKeyUsage(this.keyUsage);
        this.generateCertificate(false);
    }

    private void generateCertificate(boolean bl) throws Exception {
        Object object;
        X509Certificate x509Certificate = new X509Certificate();
        int n = bl ? 2 : 0;
        x509Certificate.setVersion(n);
        byte[] byArray = new byte[16];
        this.random.generateRandomBytes(byArray, 0, byArray.length);
        x509Certificate.setSerialNumber(byArray, 0, byArray.length);
        if (bl || this.subjectKeyIdentifier != null || this.keyUsage != null) {
            object = new X509V3Extensions(1);
            if (this.keyUsage != null) {
                object.addV3Extension((X509V3Extension)this.keyUsage);
            } else if (bl) {
                object.addV3Extension((X509V3Extension)new KeyUsage(0x4000000, true));
            }
            if (bl) {
                object.addV3Extension((X509V3Extension)new BasicConstraints(true, 1, true));
            }
            if (this.subjectKeyIdentifier != null) {
                object.addV3Extension((X509V3Extension)this.subjectKeyIdentifier);
            }
            x509Certificate.setExtensions((X509V3Extensions)object);
        }
        object = Calendar.getInstance();
        ((Calendar)object).add(5, -1);
        Date date = ((Calendar)object).getTime();
        ((Calendar)object).add(5, 1);
        ((Calendar)object).set(1, ((Calendar)object).get(1) + (bl ? 20 : 15));
        Date date2 = ((Calendar)object).getTime();
        x509Certificate.setValidity(date, date2);
        x509Certificate.setSubjectName(this.subjectName);
        x509Certificate.setSubjectPublicKey(this.subjectPublicKey);
        x509Certificate.setIssuerName(this.issuerName);
        if (CryptoJ.getMode() == 0) {
            CryptoJ.setMode((int)2);
        }
        x509Certificate.signCertificate("MD5/RSA/PKCS1Block01Pad", "Java", this.issuerPrivateKey, (SecureRandom)this.random);
        this.subjectCert = x509Certificate;
    }

    private static boolean checkCAKeyUsage(X509Certificate x509Certificate) throws CertificateException {
        X509V3Extensions x509V3Extensions = x509Certificate.getExtensions();
        if (x509V3Extensions == null) {
            return true;
        }
        KeyUsage keyUsage = null;
        keyUsage = (KeyUsage)x509V3Extensions.getExtensionByType(15);
        if (keyUsage == null) {
            return true;
        }
        int n = 0;
        n = keyUsage.getKeyUsage();
        if (n != 0 && (n & 0x4000000) != 0 && (n & 0x1000000) == 0 && (n & 0x800000) == 0) {
            return true;
        }
        String string = CertGen.getKeyUsageSetting(n);
        throw new KeyUsageException("The CA with subject name of \"" + x509Certificate.getSubjectName() + "\" has invalid keyusage setting of [" + string + "]");
    }

    private static boolean checkForConflictingKeyUsage(KeyUsage keyUsage) throws CertificateException {
        if (keyUsage == null) {
            return true;
        }
        int n = 0;
        n = keyUsage.getKeyUsage();
        if (n != 0) {
            if ((n & 0x1000000) != 0) {
                if ((n & 0x800000) != 0) {
                    throw new KeyUsageException("Conflicting keyusage setting between 'encipherOnly' and 'decipherOnly'");
                }
                if ((n & 0x4000000) != 0) {
                    throw new KeyUsageException("Conflicting keyusage setting between 'encipherOnly' and 'keyCertSign'");
                }
            }
            if ((n & 0x800000) != 0) {
                if ((n & 0x1000000) != 0) {
                    throw new KeyUsageException("Conflicting keyusage setting between 'encipherOnly' and 'decipherOnly'");
                }
                if ((n & 0x4000000) != 0) {
                    throw new KeyUsageException("Conflicting keyusage setting between 'decipherOnly' and 'keyCertSign'");
                }
            }
        }
        return false;
    }

    private static String getKeyUsageSetting(int n) {
        String string;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = ", ";
        if ((n & Integer.MIN_VALUE) != 0) {
            stringBuffer.append(KEY_USAGE_NAMES[0] + string2);
        }
        if ((n & 0x40000000) != 0) {
            stringBuffer.append(KEY_USAGE_NAMES[1] + string2);
        }
        if ((n & 0x20000000) != 0) {
            stringBuffer.append(KEY_USAGE_NAMES[2] + string2);
        }
        if ((n & 0x10000000) != 0) {
            stringBuffer.append(KEY_USAGE_NAMES[3] + string2);
        }
        if ((n & 0x8000000) != 0) {
            stringBuffer.append(KEY_USAGE_NAMES[4] + string2);
        }
        if ((n & 0x4000000) != 0) {
            stringBuffer.append(KEY_USAGE_NAMES[5] + string2);
        }
        if ((n & 0x2000000) != 0) {
            stringBuffer.append(KEY_USAGE_NAMES[6] + string2);
        }
        if ((n & 0x1000000) != 0) {
            stringBuffer.append(KEY_USAGE_NAMES[7] + string2);
        }
        if ((n & 0x800000) != 0) {
            stringBuffer.append(KEY_USAGE_NAMES[8] + string2);
        }
        if ((n2 = (string = stringBuffer.toString()).lastIndexOf(string2)) != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static byte[] getPrivateKeyData(JSAFE_PrivateKey jSAFE_PrivateKey, char[] cArray) throws Exception {
        byte[] byArray = new byte[]{0, 17, 34, 51, 68, 85, 102, 119};
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSafeEncryptionServiceImpl.getSymmetricCipher("PBE/MD5/DES/CBC/PKCS5PBE-5-56", "Java");
        jSAFE_SymmetricCipher.setSalt(byArray, 0, byArray.length);
        JSAFE_SecretKey jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
        jSAFE_SecretKey.setPassword(cArray, 0, cArray.length);
        jSAFE_SymmetricCipher.encryptInit(jSAFE_SecretKey, null);
        return jSAFE_SymmetricCipher.wrapPrivateKey(jSAFE_PrivateKey, true);
    }

    public static void writePKCS8PrivateKey(JSAFE_PrivateKey jSAFE_PrivateKey, String string, String string2) throws Exception {
        byte[] byArray = CertGen.getPrivateKeyData(jSAFE_PrivateKey, string.toCharArray());
        String string3 = string2 + ".der";
        FileOutputStream fileOutputStream = new FileOutputStream(string3);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
        String string4 = string2 + ".pem";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FileOutputStream fileOutputStream2 = new FileOutputStream(string4);
        der2pem.convertEncryptedKey(byteArrayInputStream, fileOutputStream2);
        ((InputStream)byteArrayInputStream).close();
        ((OutputStream)fileOutputStream2).close();
    }

    private static void writeX509Certificate(X509Certificate x509Certificate, String string) throws Exception {
        byte[] byArray = new byte[x509Certificate.getDERLen(0)];
        x509Certificate.getDEREncoding(byArray, 0, 0);
        String string2 = string + ".der";
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
        String string3 = string + ".pem";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FileOutputStream fileOutputStream2 = new FileOutputStream(string3);
        der2pem.convertCertificate(byteArrayInputStream, fileOutputStream2);
        ((InputStream)byteArrayInputStream).close();
        ((OutputStream)fileOutputStream2).close();
    }

    private static JSAFE_PrivateKey loadPKCS8PrivateKey(String string, String string2) throws Exception {
        byte[] byArray = CertGen.readFile(string);
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = JSafeEncryptionServiceImpl.getNonFIPS140Ctx() == null ? JSAFE_SymmetricCipher.getInstance((byte[])byArray, (int)0, (String)"Java") : JSAFE_SymmetricCipher.getInstance((byte[])byArray, (int)0, (String)"Java", (FIPS140Context)JSafeEncryptionServiceImpl.getNonFIPS140Ctx());
        JSAFE_SecretKey jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
        jSAFE_SecretKey.setPassword(string2.toCharArray(), 0, string2.length());
        jSAFE_SymmetricCipher.decryptInit(jSAFE_SecretKey, null);
        JSAFE_PrivateKey jSAFE_PrivateKey = jSAFE_SymmetricCipher.unwrapPrivateKey(byArray, 0, byArray.length, true);
        return jSAFE_PrivateKey;
    }

    private static X509Certificate loadX509Certificate(String string) throws Exception {
        byte[] byArray = CertGen.readFile(string);
        return new X509Certificate(byArray, 0, 0);
    }

    private static byte[] readFile(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(fileInputStream.available());
        int n = 0;
        while ((n = fileInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        fileInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static X500Name createX500Name(Properties properties) throws NameException {
        RDN rDN;
        if (properties == null) {
            properties = new Properties();
        }
        AttributeValueAssertion[] attributeValueAssertionArray = new AttributeValueAssertion[]{new AttributeValueAssertion(1, AttributeValueAssertion.COUNTRY_NAME_OID, 4864, properties.getProperty(COUNTRY_PROPERTY, DEFAULT_COUNTRY)), new AttributeValueAssertion(3, AttributeValueAssertion.STATE_NAME_OID, 3072, properties.getProperty(STATE_PROPERTY, DEFAULT_STATE)), new AttributeValueAssertion(2, AttributeValueAssertion.LOCALITY_NAME_OID, 3072, properties.getProperty(LOCALITY_PROPERTY, DEFAULT_LOCALITY)), new AttributeValueAssertion(4, AttributeValueAssertion.ORGANIZATION_NAME_OID, 3072, properties.getProperty(ORGANIZATION_PROPERTY, DEFAULT_ORGANIZATION)), new AttributeValueAssertion(5, AttributeValueAssertion.ORGANIZATIONAL_UNIT_NAME_OID, 3072, properties.getProperty(ORG_UNIT_PROPERTY, DEFAULT_ORG_UNIT)), new AttributeValueAssertion(0, AttributeValueAssertion.COMMON_NAME_OID, 3072, properties.getProperty(COMMON_NAME_PROPERTY, DEFAULT_COMMON_NAME))};
        X500Name x500Name = new X500Name();
        for (int i = 0; i < attributeValueAssertionArray.length; ++i) {
            rDN = new RDN();
            rDN.addNameAVA(attributeValueAssertionArray[i]);
            x500Name.addRDN(rDN);
        }
        String string = properties.getProperty(EMAIL_PROPERTY);
        if (string != null) {
            rDN = new RDN();
            rDN.addNameAVA(new AttributeValueAssertion(7, AttributeValueAssertion.EMAIL_ADDRESS_OID, 5632, string));
            x500Name.addRDN(rDN);
        }
        return x500Name;
    }

    private static String findFile(String string) throws FileNotFoundException {
        String string2 = string;
        if (!new File(string2).exists()) {
            File file = new File(new File(BootStrap.getWebLogicHome(), "lib"), string);
            if (!file.exists()) {
                throw new FileNotFoundException("Cannot find file: " + string);
            }
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    public static Certificate convert(X509Certificate x509Certificate) throws Exception {
        if (x509Certificate == null) {
            return null;
        }
        byte[] byArray = new byte[x509Certificate.getDERLen(0)];
        x509Certificate.getDEREncoding(byArray, 0, 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return certificateFactory.generateCertificate(byteArrayInputStream);
    }

    public static PrivateKey convert(JSAFE_PrivateKey jSAFE_PrivateKey) throws Exception {
        if (jSAFE_PrivateKey == null) {
            return null;
        }
        String string = " ";
        byte[] byArray = CertGen.getPrivateKeyData(jSAFE_PrivateKey, string.toCharArray());
        return PKCS8.decrypt(byArray, string);
    }

    public static int getKeyUsageBitForName(String string) throws IllegalArgumentException {
        for (int i = 0; i < KEY_USAGE_NAMES.length; ++i) {
            if (!string.equalsIgnoreCase(KEY_USAGE_NAMES[i])) continue;
            return KEY_USAGE_BITS[i];
        }
        throw new IllegalArgumentException(string);
    }

    private static String[] parseList(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken().trim();
            ++n;
        }
        return stringArray;
    }

    private static void printError(String string) {
        CertGen.printUsage(string, true);
    }

    private static void printUsage(String string) {
        CertGen.printUsage(string, false);
    }

    private static void printUsage(String string, boolean bl) {
        if (string != null) {
            System.out.println();
            System.out.println(string);
        }
        System.out.println("\nUsage: java utils.CertGen\n\t-certfile <cert_file> -keyfile <private_key_file>\n\t-keyfilepass <private_key_password>\n\t[-cacert <ca_cert_file>][-cakey <ca_key_file>]\n\t[-cakeypass <ca_key_password>]\n\t[-selfsigned][-strength <key_strength>]\n\t[-e <email_address>][-cn <common_name>]\n\t[-ou <org_unit>][-o <organization>]\n\t[-l <locality>][-s <state>][-c <country_code>]\n\t[-keyusage [digitalSignature,nonRepudiation,keyEncipherment,\n\t\tdataEncipherment,keyAgreement,keyCertSign,\n\t\tcRLSign,encipherOnly,decipherOnly]]\n\t[-keyusagecritical true|false]\n\t[-subjectkeyid <subject_key_identifier>]\n\t[-subjectkeyidformat UTF-8|BASE64]\n\t[-help]\n");
        if (bl) {
            return;
        }
        System.out.println("Where:\n-cacert, -cakey, -cakeypass\n\tpublic certificate, private key file names, and private key\n\tpassword of the CA to be used as an issuer of the generated\n\tcertificate. When these options are not specified Demo CA files:\n\tCertGenCA.der, CertGenCAKey.der from the current working directory\n\tor from WebLogic lib directory will be used.\n\n-selfsigned\n\tgenerate a self-signed certificate. CA options will be ignored\n\twhen this option is specified\n\n-certfile, -keyfile\n\toutput file names without extensions for the generated public\n\tcertificate and private key. Appropriate extensions are appended\n\twhen the pem and der files are created.\n\n-keyfilepass\n\tpassword of the generated private key.\n\n-strength\n\tsize of the generated keys. The default is 1024 bits.\n\n-e, -cn, -ou, -o, -l, -s, -c\n\tSubject DN attributes of the generated public certificate.\n\n-keyusage\n\tgenerate certificate with keyusage extension, and with bits set\n\taccording to the comma-separated list of bit names.\n\tExtension will be marked as critical by default.\n\tUse [-keyusagecritical false] to generate certificate with\n\tnon-critical extension.\n\n-subjectkeyid\n\tgenerate certificate with the specified subject key identifier\n\tUse [-subjectkeyidformat UTF-8|BASE64] to indicate the format of\n\tthe specified subject key identifier string. The default is UTF-8.\n");
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            bl = CertGen.generateCertificate(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            CertGen.printError("Unexpected exception while generating certificate");
        }
        System.exit(bl ? 0 : 1);
    }

    public static boolean generateCertificate(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length == 0) {
            CertGen.printUsage(null);
            return false;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = 1024;
        String[] stringArray2 = null;
        boolean bl2 = true;
        String string7 = null;
        String string8 = "UTF-8";
        Properties properties = new Properties();
        try {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-help")) {
                    CertGen.printUsage(null);
                    return false;
                }
                if (stringArray[n].equals("-cacert")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-cakey")) {
                    string2 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-cakeypass")) {
                    string3 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-selfsigned")) {
                    bl = true;
                    continue;
                }
                if (stringArray[n].equals("-certfile")) {
                    string4 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-keyfile")) {
                    string5 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-keyfilepass")) {
                    string6 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-strength")) {
                    n2 = Integer.parseInt(stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("-e")) {
                    properties.setProperty(EMAIL_PROPERTY, stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("-cn")) {
                    properties.setProperty(COMMON_NAME_PROPERTY, stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("-ou")) {
                    properties.setProperty(ORG_UNIT_PROPERTY, stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("-o")) {
                    properties.setProperty(ORGANIZATION_PROPERTY, stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("-l")) {
                    properties.setProperty(LOCALITY_PROPERTY, stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("-s")) {
                    properties.setProperty(STATE_PROPERTY, stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("-c")) {
                    properties.setProperty(COUNTRY_PROPERTY, stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("-keyusage")) {
                    stringArray2 = n + 1 < stringArray.length && !stringArray[n + 1].startsWith("-") ? CertGen.parseList(stringArray[++n], ",") : new String[]{};
                    continue;
                }
                if (stringArray[n].equals("-keyusagecritical")) {
                    bl2 = Boolean.parseBoolean(stringArray[++n]);
                    continue;
                }
                if (stringArray[n].equals("-subjectkeyid")) {
                    string7 = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-subjectkeyidformat")) {
                    string8 = stringArray[++n];
                    continue;
                }
                if (n == 0 && stringArray.length >= 3) {
                    return CertGen.oldCertGen(stringArray);
                }
                CertGen.printError("Unknown option: " + stringArray[n]);
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            CertGen.printError("Please specify a value for " + stringArray[stringArray.length - 1]);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            CertGen.printError("Please specify a valid integer value for " + stringArray[n - 1]);
            return false;
        }
        if (string5 == null) {
            CertGen.printError("Please specify an output file name for the generated private key");
            return false;
        }
        if (string6 == null) {
            CertGen.printError("Please specify a password for the generated private key");
            return false;
        }
        if (string4 == null) {
            CertGen.printError("Please specify an output file name for the generated certificate");
            return false;
        }
        int n3 = 0;
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                try {
                    n3 |= CertGen.getKeyUsageBitForName((String)stringArray2[i]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    CertGen.printError("Unexpected key usage name: " + (String)stringArray2[i]);
                    return false;
                }
            }
        }
        byte[] byArray = null;
        if (string7 != null) {
            if (string8.equalsIgnoreCase("UTF-8")) {
                byArray = string7.getBytes("UTF-8");
            } else if (string8.equalsIgnoreCase("BASE64")) {
                try {
                    byArray = new BASE64Decoder().decodeBuffer(string7);
                }
                catch (IOException iOException) {
                    System.out.println("Could not base64 decode the subject key identifier.");
                    System.out.println("Either specify a base64 encoded subject key identifier or ");
                    System.out.println("specify '-subjectkeyidentifierformat UTF-8' if the subject key identifier is an ASCII string");
                    System.out.println(iOException);
                    return false;
                }
            } else {
                CertGen.printError("The subjectkeyidformat must be 'UTF-8' or 'BASE64'.");
                return false;
            }
        }
        CertGen certGen = new CertGen(n2);
        if (stringArray2 != null) {
            certGen.setKeyUsage(n3, bl2);
        }
        if (byArray != null) {
            certGen.setSubjectKeyIdentifier(byArray);
        }
        if (!properties.containsKey(COMMON_NAME_PROPERTY)) {
            properties.setProperty(COMMON_NAME_PROPERTY, InetAddress.getLocalHost().getHostName());
        }
        try {
            if (bl) {
                System.out.println("Generating a self signed certificate with common name " + properties.getProperty(COMMON_NAME_PROPERTY) + " and key strength " + n2);
                certGen.generateCACertificate(properties);
            } else {
                if (string == null) {
                    string = CertGen.findFile(DEFAULT_CA_CERT);
                }
                if (string2 == null) {
                    string2 = CertGen.findFile(DEFAULT_CA_KEY);
                    if (string3 == null) {
                        string3 = DEFAULT_CA_PWD;
                    }
                } else if (string3 == null) {
                    System.out.println("Please specify password for the key from " + string2 + " file");
                    return false;
                }
                System.out.println("Generating a certificate with common name " + properties.getProperty(COMMON_NAME_PROPERTY) + " and key strength " + n2 + "\nissued by CA with certificate from " + string + " file and key from " + string2 + " file");
                if (string7 != null) {
                    System.out.println("with subject key identifier " + string7);
                }
                certGen.generateCertificate(properties, string, string2, string3);
            }
        }
        catch (NameException nameException) {
            System.out.println("Failed to generate the certificate:\n" + nameException.getMessage());
            if (properties.getProperty(COUNTRY_PROPERTY, DEFAULT_COUNTRY).length() != 2) {
                System.out.println("The country code must consist of two printable characters.");
            } else {
                System.out.println("Make sure the values of the subject name fields are valid.");
            }
            return false;
        }
        catch (KeyUsageException keyUsageException) {
            System.out.println("Failed to generate the certificate:\n" + keyUsageException.getMessage());
            return false;
        }
        catch (CertificateException certificateException) {
            System.out.println("Failed to generate the certificate:\n" + certificateException.getMessage());
            System.out.println("Make sure the country code contains only printable characters, and values of the other subject name fields are valid.");
            return false;
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            System.out.println("Failed to generate the certificate:\n" + jSAFE_InvalidUseException.getMessage());
            if (n2 != 1024) {
                System.out.println("Make sure the key strength value is valid.");
            }
            if (!bl) {
                System.out.println("Make sure the CA key password is valid.");
            }
            return false;
        }
        catch (IOException iOException) {
            if (bl) {
                System.out.println("Failed to generate the certificate:");
            } else {
                System.out.println("Failed to read one of the CA files: " + string + ", or " + string2);
            }
            System.out.println(iOException.getMessage());
            return false;
        }
        catch (Exception exception) {
            System.out.println("Failed to generate the certificate:\n" + exception.getMessage());
            if (!bl) {
                System.out.println("Make sure the CA files are in DER format.");
            }
            return false;
        }
        try {
            CertGen.writePKCS8PrivateKey(certGen.subjectPrivateKey, string6, string5);
        }
        catch (Exception exception) {
            System.out.println("Failed to write generated private key to " + string5);
            System.out.println(exception.getMessage());
            return false;
        }
        try {
            CertGen.writeX509Certificate(certGen.subjectCert, string4);
        }
        catch (Exception exception) {
            System.out.println("Failed to write generated certificate to " + string4);
            System.out.println(exception.getMessage());
            return false;
        }
        return true;
    }

    private static boolean oldCertGen(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        boolean bl = stringArray.length > 3 && stringArray[3].equalsIgnoreCase("EXPORT");
        String string4 = stringArray.length > 4 ? stringArray[4] : InetAddress.getLocalHost().getHostName();
        boolean bl2 = stringArray.length > 5 && stringArray[5].equalsIgnoreCase("GENCA");
        System.out.println("......  Will generate " + (bl2 ? "new CA certificate (self signed)" : "certificate signed by CA from CertGenCA.der file"));
        System.out.println("......  With " + (bl ? "Export" : "Domestic") + " Key Strength");
        System.out.println("......  Common Name will have Hostname " + string4);
        Properties properties = new Properties();
        properties.setProperty(COMMON_NAME_PROPERTY, string4);
        CertGen certGen = new CertGen(bl);
        try {
            if (bl2) {
                certGen.generateCACertificate(properties);
            } else {
                certGen.generateCertificate(properties);
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to generate the certificate\n" + exception.getMessage());
            return false;
        }
        System.out.println("......  Issuer CA name is " + certGen.issuerName);
        try {
            CertGen.writePKCS8PrivateKey(certGen.subjectPrivateKey, string, string3);
            CertGen.writeX509Certificate(certGen.subjectCert, string2);
        }
        catch (Exception exception) {
            System.out.println("Failed to write to file\n" + exception.getMessage());
            return false;
        }
        return true;
    }

    private static class KeyUsageException
    extends CertificateException {
        public KeyUsageException(String string) {
            super(string);
        }
    }
}

