/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLContextWrapper;

public class ImportPrivateKey {
    private static void printError(String string) {
        ImportPrivateKey.printUsage(string, true);
    }

    private static void printUsage(String string) {
        ImportPrivateKey.printUsage(string, false);
    }

    private static void printUsage(String string, boolean bl) {
        if (string != null) {
            System.out.println();
            System.out.println(string);
        }
        System.out.println("\nUsage: java utils.ImportPrivateKey \n\t-certfile <cert_file> -keyfile <private_key_file>\n\t[-keyfilepass <private_key_password>]\n\t-keystore <keystore> -storepass <storepass> [-storetype <storetype>]\n\t-alias <alias> [-keypass <keypass>]\n\t[-help]\n");
        if (bl) {
            return;
        }
        System.out.println("Where:\n-certfile, -keyfile, -keyfilepass\n\tcertificate and private key files, and the private key password\n\n-keystore, -storepass, -storetype\n\tkeystore file name, password, and type. The default type is JKS.\n\n-alias -keypass\n\talias and password of the keystore key entry where the private key\n\tand the public certificate will be imported. When the key entry\n\tpassword is not specified, the private key password will be used\n\tinstead, or when it is not specified either, the keystore password.\n");
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        try {
            bl = ImportPrivateKey.importKey(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            ImportPrivateKey.printError("Caught unexpected exception while trying to import the key");
        }
        System.exit(bl ? 0 : 1);
    }

    public static boolean importKey(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "jks";
        if (stringArray.length == 0) {
            ImportPrivateKey.printUsage(null);
            return false;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-keystore")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-storepass")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-storetype")) {
                    string8 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-keypass")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-alias")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-keyfile")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-keyfilepass")) {
                    string7 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-certfile")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-help")) {
                    ImportPrivateKey.printUsage(null);
                    return true;
                }
                if (i == 0 && stringArray.length == 6 || stringArray.length == 7) {
                    if (stringArray.length == 7) {
                        string8 = stringArray[6];
                    }
                    return ImportPrivateKey.importKey(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], string8);
                }
                ImportPrivateKey.printError("Unknown flag: " + stringArray[i]);
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ImportPrivateKey.printError("Please specify value for " + stringArray[stringArray.length - 1]);
            return false;
        }
        if (string6 == null) {
            ImportPrivateKey.printError("Please specify the private key file");
            return false;
        }
        if (string5 == null) {
            ImportPrivateKey.printError("Please specify the public certificate file");
            return false;
        }
        if (string == null) {
            ImportPrivateKey.printError("Please specify the key store file name");
            return false;
        }
        if (string2 == null) {
            ImportPrivateKey.printError("Please specify the key store password");
            return false;
        }
        if (string3 == null) {
            ImportPrivateKey.printError("Please specify the alias of the key entry");
            return false;
        }
        if (string4 == null) {
            System.out.println("No password was specified for the key entry");
            if (string7 != null) {
                System.out.println("Key file password will be used");
                string4 = string7;
            } else {
                System.out.println("Keystore password will be used");
                string4 = string2;
            }
        }
        return ImportPrivateKey.importKey(string, string2, string8, string3, string4, string5, string6, string7);
    }

    public static boolean importKey(String string, String string2, String string3, String string4, String string5, String string6) {
        return ImportPrivateKey.importKey(string, string2, "jks", string3, string4, string5, string6, string4);
    }

    public static boolean importKey(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return ImportPrivateKey.importKey(string, string2, string7, string3, string4, string5, string6, string4);
    }

    public static boolean importKey(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        try {
            Certificate[] certificateArray;
            PrivateKey privateKey;
            char[] cArray = string2.toCharArray();
            char[] cArray2 = string5.toCharArray();
            char[] cArray3 = string8 == null ? new char[]{} : string8.toCharArray();
            SSLContextWrapper sSLContextWrapper = SSLContextWrapper.getInstance();
            try {
                privateKey = sSLContextWrapper.inputPrivateKey(new FileInputStream(string7), cArray3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("\nCannot find the key file " + string7 + "\n");
                return false;
            }
            catch (SecurityException securityException) {
                System.out.println("\nDo not have permission to read key file " + string7 + "\n");
                return false;
            }
            catch (KeyManagementException keyManagementException) {
                System.out.println("\nCannot construct PrivateKey from file " + string7 + "\nPlease make sure the file is valid and the key password is correct\n");
                return false;
            }
            try {
                certificateArray = SSLCertUtility.inputCertificateChain(sSLContextWrapper, new FileInputStream(string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("\nCannot find the certificate file " + string6 + "\n");
                return false;
            }
            catch (SecurityException securityException) {
                System.out.println("\nDo not have permission to read certificate file " + string6 + "\n");
                return false;
            }
            catch (KeyManagementException keyManagementException) {
                System.out.println("\nCannot construct Certificate from file " + string6 + "\nPlease make sure the file is in a valid format\n");
                return false;
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (SecurityException securityException) {
                System.out.println("\nDo not have permission to read the keystore file " + string + "\n");
                return false;
            }
            KeyStore keyStore = null;
            try {
                keyStore = KeyStore.getInstance(string3);
                keyStore.load(fileInputStream, cArray);
            }
            catch (KeyStoreException keyStoreException) {
                System.out.println("\nThe requested keystore type " + string3 + " is not available\n");
                return false;
            }
            catch (IOException iOException) {
                System.out.println("\nCannot load keystore from file " + string + "\nPlease make sure the file is a keystore, and the keystore password is correct\n");
                return false;
            }
            catch (CertificateException certificateException) {
                System.out.println("\nCannot load certificates from the keystore file " + string + "\n");
                return false;
            }
            try {
                keyStore.setKeyEntry(string4, privateKey, cArray2, certificateArray);
                keyStore.store(new FileOutputStream(string), cArray);
                System.out.println("\nImported private key " + string7 + " and certificate " + string6 + "\ninto" + (fileInputStream == null ? " a new" : "") + " keystore " + string + " of type " + string3 + " under alias " + string4);
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("\nCannot open for writing keystore file " + string + "\nPlease make sure the file is not write protected\n");
                return false;
            }
            catch (SecurityException securityException) {
                System.out.println("\nDo not have permission to write to the keystore file " + string);
                return false;
            }
            catch (KeyStoreException keyStoreException) {
                System.out.println("\nCannot import the key and the certificate to the keystore\n" + keyStoreException.getMessage() + "\n");
                return false;
            }
            catch (CertificateException certificateException) {
                System.out.println("\nCannot write certificates to the keystore file " + string + "\n");
                return false;
            }
        }
        catch (Throwable throwable) {
            System.out.println("\nFailed to import private key and certificate to the keystore file " + string + "\n" + throwable.getMessage() + "\n");
            throwable.printStackTrace();
            return false;
        }
    }
}

