/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Hashtable;

public class MulticastTest {
    static String sampleAddress = "237.0.0.1";
    static int BUF_SIZE = 32768;
    static int DEF_PORT = 7001;
    static int DEF_TIMEOUT_SECS = 600;
    static long DEF_SEND_PAUSE_SECS = 2L;
    private byte[] message = null;
    private String messageString = null;
    private long sendPause = 0L;
    private InetAddress groupAddr = null;
    private int port = 0;
    private MulticastSocket socket = null;
    private int seq = 0;
    private Hashtable neighbors = null;
    private int timeout = 0;
    private String interfaceAddress = null;
    private byte ttl;

    public MulticastTest(String string, int n, int n2, String string2, long l, String string3, int n3) {
        this.sendPause = l;
        this.port = n;
        this.timeout = n2;
        this.messageString = string2;
        this.neighbors = new Hashtable();
        try {
            byte[] byArray = string2.getBytes();
            this.message = new byte[BUF_SIZE];
            System.arraycopy(byArray, 0, this.message, 25 - byArray.length, byArray.length);
            for (int i = 25; i < BUF_SIZE; ++i) {
                this.message[i] = 97;
            }
            this.socket = new MulticastSocket(n);
            if (string3 != null) {
                InetAddress inetAddress = InetAddress.getByName(string3);
                System.out.println("Using interface at " + inetAddress.getHostAddress());
                this.socket.setInterface(inetAddress);
            }
            if (n2 > 0) {
                this.socket.setSoTimeout(n2 * 1000);
            }
            if (n3 > 1) {
                this.socket.setTimeToLive(n3);
            }
            this.groupAddr = InetAddress.getByName(string);
            this.socket.joinGroup(this.groupAddr);
            System.out.println("Using multicast address " + string + ":" + n);
            System.out.println("Will send messages under the name " + string2 + " every " + l + " seconds");
            System.out.println("Will print warning every " + n2 + " seconds if no messages are received\n");
            new Sender().start();
            new Receiver().start();
        }
        catch (Exception exception) {
            System.out.println("*****Problem*******");
            exception.printStackTrace();
            MulticastTest.shutdown();
        }
    }

    private void handleBytes(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            System.out.println("Timed out");
        } else {
            int n3 = MulticastTest.readInt(byArray, 0);
            String string = new String(byArray, 4, 21).trim();
            HasAnInt hasAnInt = (HasAnInt)this.neighbors.get(string);
            if (hasAnInt == null) {
                this.neighbors.put(string, new HasAnInt(n3));
                if (!string.equals(this.messageString)) {
                    System.out.println("New Neighbor " + string + " found on message number " + n3);
                }
            } else if (hasAnInt.value + 1 == n3) {
                if (n2 < BUF_SIZE) {
                    System.out.println("Received message " + hasAnInt.value + " from " + string + ". Lost " + (BUF_SIZE - n2) + " bytes of total of " + BUF_SIZE + " bytes");
                } else {
                    System.out.println("Received message " + ++hasAnInt.value + " from " + string);
                }
            } else if (hasAnInt.value + 1 < n3) {
                System.out.println("Missed message for " + string + "?  Last Seq " + hasAnInt.value + " and just received " + n3);
                hasAnInt.value = n3;
            } else if (hasAnInt.value == n3) {
                System.out.println("Duplicate message from " + string + ": " + n3);
            } else if (hasAnInt.value > n3) {
                System.out.println("Out of order for " + string + "?  Last Seq " + hasAnInt.value + " and just received " + n3);
            }
        }
    }

    private static void shutdown() {
        MulticastTest.shutdown(false);
    }

    private static void shutdown(boolean bl) {
        if (bl) {
            MulticastTest.printUsage();
        }
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = null;
        int n = DEF_PORT;
        int n2 = DEF_TIMEOUT_SECS;
        String string2 = "" + System.currentTimeMillis() / 1000L;
        long l = DEF_SEND_PAUSE_SECS;
        String string3 = null;
        int n3 = 1;
        if (stringArray.length < 2) {
            MulticastTest.shutdown(true);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-") || stringArray[i].length() < 2) continue;
            try {
                switch (stringArray[i].charAt(1)) {
                    case 'A': 
                    case 'a': {
                        if (stringArray.length < i + 2) break;
                        string = stringArray[i + 1];
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        if (stringArray.length < i + 2) break;
                        n = Integer.parseInt(stringArray[i + 1]);
                        break;
                    }
                    case 'T': 
                    case 't': {
                        if (stringArray.length < i + 2) break;
                        n2 = Integer.parseInt(stringArray[i + 1]);
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        if (stringArray.length < i + 2) break;
                        string2 = stringArray[i + 1];
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (stringArray.length < i + 2) break;
                        l = Long.parseLong(stringArray[i + 1]) > 0L ? Long.parseLong(stringArray[i + 1]) : DEF_SEND_PAUSE_SECS;
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        MulticastTest.shutdown(true);
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        if (stringArray.length <= i + 1) break;
                        string3 = stringArray[i + 1];
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        if (stringArray.length <= i + 1) break;
                        n3 = Integer.parseInt(stringArray[i + 1]);
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("***** WARNING ***** WARNING ***** WARNING *****\nDo NOT use the same multicast address as a running WLS cluster.");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("\n\nStarting test.  Hit any key to abort\n\n");
        MulticastTest multicastTest = new MulticastTest(string, n, n2, string2, l, string3, n3);
        try {
            System.in.read();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        multicastTest.shutdown();
    }

    private static void printUsage() {
        System.out.println("\nUsage: java utils.MulticastTest [options]\n");
        System.out.println("\t -N <name> REQUIRED ");
        System.out.println("\t\t Unique identifier for process.");
        System.out.println("\t -A <address> The multicast address REQUIRED");
        System.out.println("\t\t Sample multicast address:  " + sampleAddress);
        System.out.println("\t -P <portNumber>");
        System.out.println("\t\t The multicast port.  Default: " + DEF_PORT);
        System.out.println("\t -T <timeout> ");
        System.out.println("\t\t The idle timeout, in seconds.  Default: " + DEF_TIMEOUT_SECS);
        System.out.println("\t -S <sendPause>");
        System.out.println("\t\t  The pause between sends, in seconds.  Default: " + DEF_SEND_PAUSE_SECS);
        System.out.println("\t -I <interfaceAddress>");
        System.out.println("\t\t  Address of interface card to use.  Uses the default NIC if none is specified");
        System.out.println("\t -L <timeToLive>");
        System.out.println("\t\t  Sets time-to-live for multicast packet.\nThis specifies how many hops a packet can make before being\ndiscarded.  Defaults to 1 which restricts the packet to the\nsubnet.");
        System.out.println("\t -H Help (this)\n");
    }

    public static int readInt(byte[] byArray, int n) {
        int n2 = (byArray[n++] & 0xFF) << 24;
        n2 |= (byArray[n++] & 0xFF) << 16;
        n2 |= (byArray[n++] & 0xFF) << 8;
        return n2 |= byArray[n] & 0xFF;
    }

    public static int writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >>> 24);
        byArray[n++] = (byte)(n2 >>> 16);
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n] = (byte)n2;
        return n2;
    }

    class Sender
    extends Thread {
        Sender() {
        }

        public void run() {
            try {
                while (true) {
                    Sender.sleep(MulticastTest.this.sendPause * 1000L);
                    MulticastTest.writeInt(MulticastTest.this.message, 0, ++MulticastTest.this.seq);
                    DatagramPacket datagramPacket = new DatagramPacket(MulticastTest.this.message, MulticastTest.this.message.length, MulticastTest.this.groupAddr, MulticastTest.this.port);
                    MulticastTest.this.socket.send(datagramPacket);
                    System.out.println("\t\tI (" + MulticastTest.this.messageString + ") sent message num " + MulticastTest.this.seq);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    class Receiver
    extends Thread {
        byte[] buffer = null;

        Receiver() {
        }

        public void run() {
            try {
                this.buffer = new byte[BUF_SIZE];
                while (true) {
                    DatagramPacket datagramPacket = new DatagramPacket(this.buffer, this.buffer.length);
                    MulticastTest.this.socket.receive(datagramPacket);
                    MulticastTest.this.handleBytes(this.buffer, 0, datagramPacket.getLength());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    class HasAnInt {
        public int value = 0;

        public HasAnInt(int n) {
            this.value = n;
        }
    }
}

