/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Date;
import weblogic.platform.VM;

public class ThreadDumper
extends Thread {
    static String addr = null;
    static int port = -1;
    static InetAddress group = null;
    static MulticastSocket sock = null;
    static VM vm;
    static boolean disabled;
    static boolean alreadyInit;
    static boolean shutdownSignaled;
    static ThreadDumper staticTD;

    public static synchronized void init(boolean bl) {
        if (alreadyInit) {
            return;
        }
        alreadyInit = true;
        if (bl) {
            vm = VM.getVM();
        }
        addr = System.getProperty("weblogic.debug.dumpThreadAddr", null);
        try {
            port = Integer.decode(System.getProperty("weblogic.debug.dumpThreadPort", "-1"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (addr == null || port == -1) {
            System.out.println("Broadcast Thread dumps disabled: must specify weblogic.debug.dumpThreadAddr and weblogic.debug.dumpThreadPort");
            return;
        }
        try {
            group = InetAddress.getByName(addr);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("*** " + addr + " is not a valid multicast address");
            unknownHostException.printStackTrace();
            return;
        }
        try {
            sock = new MulticastSocket(port);
        }
        catch (IOException iOException) {
            System.out.println("*** Cannot create MultiCastSocket on addr=" + addr + " port=" + port);
            iOException.printStackTrace();
            return;
        }
        try {
            sock.joinGroup(group);
        }
        catch (IOException iOException) {
            System.out.println("*** Cannot join group for addr=" + addr + " port=" + port);
            iOException.printStackTrace();
            return;
        }
        System.out.println("*** Joined group for addr=" + addr + " port=" + port);
        disabled = false;
    }

    public void informShutdown() {
        shutdownSignaled = true;
        System.out.println("ThreadDumper will no longer report socket IOExceptions, server is shutting down.");
    }

    public void run() {
        if (disabled) {
            return;
        }
        while (true) {
            String string;
            DatagramPacket datagramPacket;
            block4: {
                byte[] byArray = new byte[2000];
                datagramPacket = new DatagramPacket(byArray, byArray.length);
                try {
                    sock.receive(datagramPacket);
                }
                catch (IOException iOException) {
                    if (shutdownSignaled) break block4;
                    System.out.println("*** MultiCast recv failed for addr=" + addr + " port=" + port);
                    iOException.printStackTrace();
                }
            }
            if (!(string = new String(datagramPacket.getData(), 0, datagramPacket.getLength())).startsWith("DUMP")) continue;
            System.err.println(string);
            vm.threadDump();
            System.err.println("Execute Queue State");
        }
    }

    public static void sendDumpMsg() {
        ThreadDumper.sendDumpMsg(null);
    }

    public static void sendDumpMsg(String string) {
        block3: {
            String string2 = "DUMP at " + new Date().toString();
            if (string != null) {
                string2 = string2 + ": " + string;
            }
            byte[] byArray = string2.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, group, port);
            try {
                sock.send(datagramPacket);
            }
            catch (IOException iOException) {
                if (shutdownSignaled) break block3;
                System.out.println("*** MultiCast send failed for addr=" + addr + " port=" + port);
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0 && stringArray[0].equals("-test")) {
            ThreadDumper.init(true);
            ThreadDumper threadDumper = new ThreadDumper();
            threadDumper.start();
        } else {
            ThreadDumper.init(false);
            ThreadDumper.sendDumpMsg("I'm being dumped");
            System.exit(0);
        }
    }

    static {
        disabled = true;
        alreadyInit = false;
        shutdownSignaled = false;
        staticTD = null;
    }
}

