/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.Provider;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.pkcs12.PKCS12;
import com.rsa.certj.pkcs12.PKCS12Exception;
import com.rsa.certj.provider.db.MemoryDB;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Enumeration;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import weblogic.security.SecurityLogger;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLContextWrapper;

public class ValidateCertChain {
    private boolean outputEnabled = false;
    private boolean debugEnabled = Boolean.getBoolean("debug");
    private boolean constraintsIssues = false;
    private boolean chainIncomplete = false;

    public void setOutputEnabled(boolean bl) {
        this.outputEnabled = bl;
    }

    public static void main(String[] stringArray) {
        ValidateCertChain validateCertChain = new ValidateCertChain();
        validateCertChain.setOutputEnabled(true);
        if (validateCertChain.processCommandLine(stringArray)) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public boolean processCommandLine(String[] stringArray) {
        boolean bl;
        block9: {
            bl = false;
            if (stringArray == null || stringArray.length == 0) {
                this.usage();
                return bl;
            }
            try {
                if ((stringArray[0].equalsIgnoreCase("-file") || stringArray[0].equalsIgnoreCase("-pem")) && stringArray.length == 2) {
                    bl = this.processPemFile(stringArray[1]);
                    break block9;
                }
                if (stringArray[0].equalsIgnoreCase("-jks") && (stringArray.length == 3 || stringArray.length == 4)) {
                    bl = this.processJksKeyStore(stringArray[1], stringArray[2], stringArray.length == 4 ? stringArray[3] : null);
                    break block9;
                }
                if (stringArray[0].equalsIgnoreCase("-pkcs12store") && stringArray.length == 2) {
                    bl = this.processPkcs12(stringArray[1]);
                    break block9;
                }
                if (stringArray[0].equalsIgnoreCase("-pkcs12file") && stringArray.length == 3) {
                    bl = this.processPkcs12UsingCertJ(stringArray[1], stringArray[2]);
                    break block9;
                }
                this.usage();
                return bl;
            }
            catch (Exception exception) {
                this.printOut(exception);
            }
        }
        if (bl) {
            this.printOut("Certificate chain appears valid");
        } else {
            this.printOut("Certificate chain is invalid");
        }
        return bl;
    }

    public boolean processPemFile(String string) {
        boolean bl = false;
        try {
            bl = this.validateCertChain(this.convertChain(SSLCertUtility.inputCertificateChain(SSLContextWrapper.getInstance(), new FileInputStream(string))));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.printOut("File not found: " + string);
        }
        catch (IOException iOException) {
            this.printOut("Failure processing: " + string);
            this.printOut(iOException);
        }
        catch (KeyManagementException keyManagementException) {
            this.printOut("Failure processing: " + string);
            this.printOut(keyManagementException);
        }
        return bl;
    }

    public boolean processJksKeyStore(String string, String string2, String string3) {
        boolean bl = false;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string2), string3 == null ? null : string3.toCharArray());
            bl = this.validateCertChain(this.convertChain(keyStore.getCertificateChain(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.printOut("File not found: " + string2);
        }
        catch (Exception exception) {
            this.printOut("Failure processing: " + string2);
            this.printOut(exception);
        }
        return bl;
    }

    public boolean processPkcs12(String string) {
        boolean bl = false;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new FileInputStream(string), null);
            String string2 = null;
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements() && !keyStore.isKeyEntry(string2 = enumeration.nextElement())) {
            }
            if (string2 == null) {
                this.printOut("No alias for certs/key found");
            } else {
                bl = this.validateCertChain(this.convertChain(keyStore.getCertificateChain(string2)));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.printOut("File not found: " + string);
        }
        catch (KeyStoreException keyStoreException) {
            if (keyStoreException.getMessage().equalsIgnoreCase("PKCS12 not found")) {
                this.printOut("PKCS12 keystore not supported, try using -pkcs12file");
            } else {
                this.printOut("Failure processing: " + string);
                this.printOut(keyStoreException);
            }
        }
        catch (Exception exception) {
            this.printOut("Failure processing: " + string);
            this.printOut(exception);
        }
        return bl;
    }

    public boolean processPkcs12UsingCertJ(String string, String string2) {
        boolean bl = false;
        try {
            Provider[] providerArray = new Provider[]{new MemoryDB("In-Memory Provider")};
            CertJ certJ = new CertJ(providerArray);
            DatabaseService databaseService = (DatabaseService)certJ.bindServices(1);
            PKCS12 pKCS12 = new PKCS12(certJ, databaseService, string2.toCharArray(), string);
            bl = this.validateCertChain(this.convertChain(pKCS12.getCertificates()));
        }
        catch (PKCS12Exception pKCS12Exception) {
            this.printOut("Failure processing: " + string);
            this.printOut((Exception)((Object)pKCS12Exception));
        }
        catch (Exception exception) {
            this.printOut("Failure processing: " + string);
            this.printOut(exception);
        }
        return bl;
    }

    private com.rsa.certj.cert.X509Certificate[] convertChain(com.rsa.certj.cert.Certificate[] certificateArray) {
        if (certificateArray == null || certificateArray.length == 0) {
            return null;
        }
        try {
            com.rsa.certj.cert.X509Certificate[] x509CertificateArray = new com.rsa.certj.cert.X509Certificate[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                x509CertificateArray[i] = (com.rsa.certj.cert.X509Certificate)certificateArray[i];
            }
            return x509CertificateArray;
        }
        catch (ClassCastException classCastException) {
            this.printOut("Problem converting certificate chain");
            this.printOut(classCastException);
            return null;
        }
    }

    private com.rsa.certj.cert.X509Certificate[] convertChain(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return null;
        }
        try {
            com.rsa.certj.cert.X509Certificate[] x509CertificateArray2 = new com.rsa.certj.cert.X509Certificate[x509CertificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                x509CertificateArray2[i] = new com.rsa.certj.cert.X509Certificate(x509CertificateArray[i].getEncoded(), 0, 0);
            }
            return x509CertificateArray2;
        }
        catch (CertificateException certificateException) {
            this.printOut("Problem converting certificate chain");
            this.printOut((Exception)((Object)certificateException));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.printOut("Problem converting certificate chain");
            this.printOut(certificateEncodingException);
        }
        return null;
    }

    private com.rsa.certj.cert.X509Certificate[] convertChain(Certificate[] certificateArray) {
        if (certificateArray == null || certificateArray.length == 0) {
            return null;
        }
        try {
            com.rsa.certj.cert.X509Certificate[] x509CertificateArray = new com.rsa.certj.cert.X509Certificate[certificateArray.length];
            for (int i = 0; i < certificateArray.length; ++i) {
                x509CertificateArray[i] = new com.rsa.certj.cert.X509Certificate(certificateArray[i].getEncoded(), 0, 0);
            }
            return x509CertificateArray;
        }
        catch (CertificateException certificateException) {
            this.printOut("Problem converting certificate chain");
            this.printOut((Exception)((Object)certificateException));
        }
        catch (java.security.cert.CertificateEncodingException certificateEncodingException) {
            this.printOut("Problem converting certificate chain");
            this.printOut(certificateEncodingException);
        }
        return null;
    }

    public static void validateServerCertChain(X509Certificate[] x509CertificateArray) {
        ValidateCertChain validateCertChain = new ValidateCertChain();
        validateCertChain.validateCertChain(validateCertChain.convertChain(x509CertificateArray));
        validateCertChain.logForServer();
    }

    public static void validateServerCertChain(Certificate[] certificateArray) {
        ValidateCertChain validateCertChain = new ValidateCertChain();
        validateCertChain.validateCertChain(validateCertChain.convertChain(certificateArray));
        validateCertChain.logForServer();
    }

    public void logForServer() {
        if (this.constraintsIssues) {
            SecurityLogger.logCertificateChainConstraints();
        } else if (this.chainIncomplete) {
            SecurityLogger.logCertificateChainIncompleteConstraintsNotChecked();
        }
    }

    public boolean validateCertChain(com.rsa.certj.cert.X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            this.printOut("No certificates found");
            return false;
        }
        boolean bl = true;
        int n = x509CertificateArray.length - 1;
        Date date = new Date();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            this.printOut("Cert[" + i + "]: " + x509CertificateArray[i].getSubjectName());
            if (!x509CertificateArray[i].checkValidityDate(date)) {
                bl = false;
                this.printOut("     Validity date check failed");
            }
            if (i == 0 && !this.verifyEndEntity(x509CertificateArray[0])) {
                this.printOut("First cert in chain is not an end entity\nthis doesn't conform to TLS V1.0 and may be rejected");
            }
            if (i < x509CertificateArray.length - 1) {
                if (this.verifyIssuedBy(x509CertificateArray[i], x509CertificateArray[i + 1], i)) continue;
                bl = false;
                continue;
            }
            if (i != x509CertificateArray.length - 1 || this.verifySelfSignedCert(x509CertificateArray[i], i)) continue;
            bl = false;
        }
        return bl;
    }

    private boolean verifyIssuedBy(com.rsa.certj.cert.X509Certificate x509Certificate, com.rsa.certj.cert.X509Certificate x509Certificate2, int n) {
        boolean bl = true;
        if (!x509Certificate.getIssuerName().equals((Object)x509Certificate2.getSubjectName())) {
            this.printOut("Issuer DN from certificate, doesn't match subjectDN from the issuer certificate");
            this.printOut("     Expected DN: " + x509Certificate.getIssuerName());
            this.printOut("       Actual DN: " + x509Certificate2.getSubjectName());
            bl = false;
        }
        if (!this.verifyCAExtensions(x509Certificate2, n)) {
            bl = false;
        }
        return bl;
    }

    public boolean verifySelfSignedCert(com.rsa.certj.cert.X509Certificate x509Certificate, int n) {
        boolean bl = true;
        boolean bl2 = true;
        if (!x509Certificate.getIssuerName().equals((Object)x509Certificate.getSubjectName())) {
            this.chainIncomplete = true;
            this.printOut("Certificate chain is incomplete, can't confirm the entire chain is valid");
            bl2 = false;
            if (n == 0) {
                return bl;
            }
        }
        if (n == 0 && !this.verifyCAExtensions(x509Certificate, n)) {
            bl = false;
        }
        if (bl2) {
            // empty if block
        }
        return bl;
    }

    public boolean verifyCAExtensions(com.rsa.certj.cert.X509Certificate x509Certificate, int n) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = x509Certificate.getVersion();
        if (n2 == 0 || n2 == 1) {
            this.printOut("CA is version " + (n2 + 1) + ", BasicConstraints extension will not be present which is valid for that version");
            return bl;
        }
        X509V3Extensions x509V3Extensions = x509Certificate.getExtensions();
        if (x509V3Extensions != null) {
            try {
                for (int i = 0; i < x509V3Extensions.getExtensionCount(); ++i) {
                    int n3;
                    X509V3Extension x509V3Extension = x509V3Extensions.getExtensionByIndex(i);
                    if (!(x509V3Extension instanceof BasicConstraints)) continue;
                    bl2 = true;
                    BasicConstraints basicConstraints = (BasicConstraints)x509V3Extension;
                    if (!basicConstraints.getCA() || !basicConstraints.getCriticality()) {
                        this.constraintsIssues = true;
                        this.printOut("CA cert not marked with critical BasicConstraint indicating it is a CA");
                        bl = false;
                    }
                    if (n == -1 || (n3 = basicConstraints.getPathLen()) == -1 || n <= n3) continue;
                    this.constraintsIssues = true;
                    this.printOut("PathLength constraint exceeded, constraint = " + n3 + ", current = " + n);
                    bl = false;
                }
            }
            catch (CertificateException certificateException) {
                this.printOut("Failed getting extensions");
                this.printOut((Exception)((Object)certificateException));
            }
        }
        if (!bl2) {
            this.constraintsIssues = true;
            this.printOut("CA cert not marked with critical BasicConstraint indicating it is a CA");
            bl = false;
        }
        return bl;
    }

    public boolean verifyEndEntity(com.rsa.certj.cert.X509Certificate x509Certificate) {
        return true;
    }

    public void usage() {
        String string = "\nUsage:\n\t java utils.ValidateCertChain -file pemcertificatefilename\n\t java utils.ValidateCertChain -pem pemcertificatefilename\n\t java utils.ValidateCertChain -pkcs12store pkcs12storefilename\n\t java utils.ValidateCertChain -pkcs12file pkcs12filename password\n\t java utils.ValidateCertChain -jks alias storefilename [storePass]";
        this.printOut(string);
    }

    private void printOut(String string) {
        if (this.outputEnabled) {
            System.out.println(string);
        }
    }

    private void printOut(Exception exception) {
        if (this.outputEnabled && this.debugEnabled) {
            exception.printStackTrace();
        }
    }
}

