/*
 * Decompiled with CFR 0.152.
 */
package utils.applet.archiver;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import utils.applet.AWTLogin;
import utils.applet.archiver.AppletClassLoader;
import utils.applet.archiver.AppletFrame;
import utils.applet.archiver.Parser;
import utils.applet.archiver.TextOut;

public class AppletArchiver
extends Frame
implements Runnable,
ActionListener,
WindowListener,
ItemListener {
    TextField tfu;
    TextField tfj;
    TextField tfwatch;
    TextArea ta;
    PrintStream out;
    String currentURL;
    Button get;
    Button cancel;
    Button clear;
    Button help;
    Container bag;
    Checkbox saveAsJar;
    Checkbox compressJar;
    Checkbox saveAsCab;
    Vector frames = new Vector();
    Parser p;
    String jarName;
    URL url;
    boolean dialogOpen = false;
    MenuBar mb;
    MenuItem loadListMenu;
    MenuItem exit;
    String[] loadRemote;
    Image icon;
    static ThreadGroup appletTG = new ThreadGroup("AppletArchiver applets");
    Hashtable applets = new Hashtable();
    static final String helpMsg = "AppletArchiver loads and views applets.  The applet\nis started in a separate frame.  The tool remembers\nall of the remote classes, images, and other \"resources\"\nthat were loaded by the applet.  When the applet's frame\nis closed, the tool packages the classes into either\na .jar or .cab archive.\n\nusage: <applet-URL> <archive-name>\n\n";
    static final int PAD = 10;
    int w;
    int h;
    private String authInfo = null;
    private Object dialogLock = new Object();
    static AppletArchiver instance;
    private static final String PRE_PROCESSOR_ENABLE = "weblogic.classloader.preprocessor.enable";
    private static final String L10N_LOCALIZER_ENABLE = "weblogic.l10ntools.l10nlookup.enable";

    void pe(String string) {
        System.out.println("ERROR: " + string);
        this.out.println("ERROR: " + string);
    }

    static void p(String string) {
        System.out.println(string);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.setVisible(true);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exitHook();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public AppletArchiver(String string) {
        super("AppletArchiver");
        this.loadRemote = new String[6];
        this.loadRemote[0] = "weblogic";
        this.loadRemote[1] = "utils";
        this.loadRemote[2] = "qa";
        this.loadRemote[3] = "tutorial";
        this.loadRemote[4] = "javax";
        this.loadRemote[5] = "examples";
        this.setBackground(Color.lightGray);
        this.currentURL = string;
        this.addWindowListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setSize(500, 300);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.bag = this.constructButtonPanel();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        this.bag.setBackground(Color.gray);
        gridBagLayout.setConstraints(this.bag, gridBagConstraints);
        this.add(this.bag);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = 0;
        this.ta = new TextArea("", 15, 20, 0);
        this.ta.setBackground(Color.lightGray);
        this.ta.setEditable(false);
        this.out = new TextOut(this.ta);
        gridBagLayout.setConstraints(this.ta, gridBagConstraints);
        this.add(this.ta);
        this.pack();
        this.setIcon();
    }

    private Container constructButtonPanel() {
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        this.saveAsJar = new Checkbox(" Save to .jar file", true);
        this.saveAsJar.addItemListener(this);
        gridBagLayout.setConstraints(this.saveAsJar, gridBagConstraints);
        panel.add(this.saveAsJar);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.compressJar = new Checkbox("Compress .jar", true);
        this.compressJar.addItemListener(this);
        gridBagLayout.setConstraints(this.compressJar, gridBagConstraints);
        panel.add(this.compressJar);
        this.saveAsCab = new Checkbox("Save to .cab file", false);
        this.saveAsCab.addItemListener(this);
        String string = System.getProperty("os.name");
        if (string != null && string.toUpperCase().indexOf("WINDOWS") >= 0) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(this.saveAsCab, gridBagConstraints);
            panel.add(this.saveAsCab);
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        Label label = new Label("Applet URL");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.tfu = new TextField("url", 30);
        this.tfu.addActionListener(this);
        this.tfu.setBackground(Color.white);
        gridBagLayout.setConstraints(this.tfu, gridBagConstraints);
        panel.add(this.tfu);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        label = new Label("Archive file");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        this.tfj = new TextField("jar", 30);
        this.tfj.addActionListener(this);
        this.tfj.setBackground(Color.white);
        gridBagLayout.setConstraints(this.tfj, gridBagConstraints);
        panel.add(this.tfj);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        label = new Label("Show trace when loading...");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.tfwatch = new TextField("", 30);
        this.tfwatch.setBackground(Color.white);
        gridBagLayout.setConstraints(this.tfwatch, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.get = new Button("Get it");
        this.get.addActionListener(this);
        gridBagLayout.setConstraints(this.get, gridBagConstraints);
        panel.add(this.get);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.cancel = new Button("Cancel get");
        this.cancel.addActionListener(this);
        this.cancel.setEnabled(false);
        gridBagLayout.setConstraints(this.cancel, gridBagConstraints);
        panel.add(this.cancel);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        this.clear = new Button("Clear output");
        this.clear.addActionListener(this);
        gridBagLayout.setConstraints(this.clear, gridBagConstraints);
        panel.add(this.clear);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.help = new Button("Help");
        this.help.addActionListener(this);
        gridBagLayout.setConstraints(this.help, gridBagConstraints);
        panel.add(this.help);
        this.mb = new MenuBar();
        Menu menu = new Menu("Options");
        this.loadListMenu = new MenuItem("Remote class-loading list...");
        menu.add(this.loadListMenu);
        this.exit = new MenuItem("Exit");
        menu.add(this.exit);
        this.mb.add(menu);
        this.setMenuBar(this.mb);
        this.loadListMenu.addActionListener(this);
        this.exit.addActionListener(this);
        return panel;
    }

    public void setAuthenticationInfo(String string) {
        this.authInfo = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAuthenticationInfo(boolean bl) {
        if (this.authInfo != null) {
            return this.authInfo;
        }
        if (!bl) {
            return null;
        }
        Object object = this.dialogLock;
        synchronized (object) {
            if (this.authInfo != null) {
                return this.authInfo;
            }
            this.authInfo = AWTLogin.showLoginDialog(this, "Authorization Required");
            return this.authInfo;
        }
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon() {
        try {
            URL uRL = this.getClass().getResource("/weblogic/graphics/W.gif");
            this.icon = Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
            this.setIconImage(this.icon);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
        }
    }

    void exitHook() {
        System.exit(0);
    }

    void getIt() {
        String string = this.tfu.getText();
        this.jarName = this.tfj.getText();
        if (string == null) {
            this.pe("specify a URL");
            return;
        }
        if (this.jarName == null) {
            this.pe("specify a jar file");
            return;
        }
        try {
            if (string.indexOf(":/") == -1) {
                string = "http://" + string;
            }
            this.url = new URL(string);
            this.tfu.setText(string);
            this.p = new Parser(this.url, (ActionListener)this);
            new Thread((Runnable)this.p, "fetcher").start();
        }
        catch (Exception exception) {
            this.pe("bad URL: " + string);
            return;
        }
        this.get.setEnabled(false);
        this.cancel.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void startApplet() {
        try {
            Object object;
            Vector vector = this.p.v;
            AppletClassLoader appletClassLoader = null;
            File file = null;
            if (this.saveAsCab.getState()) {
                Random random = new Random(System.currentTimeMillis());
                object = this.url.getHost() + Math.abs(random.nextInt());
                file = new File((String)object);
            }
            if (vector.size() == 0) {
                this.pe(this.p.u + " doesn't contain an APPLET tag");
                return;
            }
            for (int i = 0; i < vector.size(); ++i) {
                URL uRL;
                object = (Hashtable)vector.elementAt(i);
                String string = (String)((Hashtable)object).get("CODE");
                if (string == null) {
                    this.pe("no 'CODE' attribute in tag: " + object);
                    continue;
                }
                string = (String)((Hashtable)object).get("CODEBASE");
                if (string != null) {
                    if (!string.endsWith("/")) {
                        string = string + "/";
                    }
                    uRL = new URL(this.url, string);
                } else {
                    uRL = this.url;
                }
                if (appletClassLoader == null) {
                    appletClassLoader = new AppletClassLoader(uRL, this.out, this.jarName, file, this.loadRemote, this.tfwatch.getText(), this.compressJar.getState());
                    Thread.currentThread().setContextClassLoader(appletClassLoader);
                }
                AppletFrame appletFrame = new AppletFrame(uRL, this.url, this, (Hashtable)object, appletClassLoader);
                new Thread(appletTG, appletFrame, "Applet-" + uRL.toString()).start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.p = null;
        }
    }

    void finished() {
        this.get.setEnabled(true);
        this.cancel.setEnabled(false);
    }

    void cancelIt() {
        this.get.setEnabled(true);
        this.cancel.setEnabled(false);
        if (this.p != null) {
            this.p.cancel();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.saveAsCab) {
            this.saveAsJar.setState(!this.saveAsCab.getState());
            this.compressJar.setEnabled(this.saveAsJar.getState());
        } else if (object == this.saveAsJar) {
            this.compressJar.setEnabled(this.saveAsJar.getState());
            this.saveAsCab.setState(!this.saveAsCab.getState());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.tfu) {
            this.getIt();
        } else if (object == this.exit) {
            this.exitHook();
        } else if (object == this.loadListMenu) {
            if (!this.dialogOpen) {
                this.dialogOpen = true;
                new OptionsDialog(this).setVisible(true);
            }
        } else if (object == this.tfj) {
            this.getIt();
        } else if (object == this.get) {
            this.getIt();
        } else if (object == this.cancel) {
            this.cancelIt();
        } else if (object == this.clear) {
            this.ta.setText("");
        } else if (object == this.p) {
            this.finished();
            String string = actionEvent.getActionCommand();
            if (string.equals("done")) {
                this.startApplet();
            } else {
                this.out.println("Error occurred when loading HTML page: " + string);
            }
        } else if (object == this.help) {
            this.out.print(helpMsg);
        }
    }

    public void run() {
    }

    public static AppletArchiver getInstance() {
        return instance;
    }

    public static void main(String[] stringArray) throws Exception {
        AppletArchiver appletArchiver;
        System.setProperty(PRE_PROCESSOR_ENABLE, "false");
        System.setProperty(L10N_LOCALIZER_ENABLE, "false");
        instance = appletArchiver = new AppletArchiver("Archiver Tool");
        if (stringArray.length > 0) {
            appletArchiver.tfu.setText(stringArray[0]);
        }
        if (stringArray.length > 1) {
            appletArchiver.tfj.setText(stringArray[1]);
            if (stringArray[1].endsWith(".cab")) {
                appletArchiver.saveAsJar.setState(false);
                appletArchiver.saveAsCab.setState(true);
                appletArchiver.compressJar.setEnabled(false);
            }
        }
        appletArchiver.setLocation(new Point(30, 30));
        appletArchiver.setVisible(true);
        appletArchiver.run();
    }

    static {
        appletTG.setMaxPriority(5);
    }

    class OptionsDialog
    extends Dialog
    implements ActionListener,
    WindowListener,
    ItemListener,
    TextListener {
        private AppletArchiver ar;
        private List options;
        private Button delete;
        private Button ok;
        private Button cancel;
        private Button add;
        private TextField tf;
        private GridBagLayout gb;
        private GridBagConstraints gbc;

        OptionsDialog(AppletArchiver appletArchiver2) {
            super(appletArchiver2, "Packages to load remotely", false);
            this.gb = new GridBagLayout();
            this.gbc = new GridBagConstraints();
            this.setLayout(this.gb);
            this.gbc.insets = new Insets(2, 2, 2, 2);
            this.gbc.gridy = 0;
            this.gbc.gridx = 0;
            this.gbc.anchor = 17;
            this.ar = appletArchiver2;
            this.options = new List(appletArchiver2.loadRemote.length);
            for (int i = 0; i < appletArchiver2.loadRemote.length; ++i) {
                this.options.add(appletArchiver2.loadRemote[i]);
            }
            this.add(this.options);
            ++this.gbc.gridx;
            this.delete = new Button("Delete");
            this.add(this.delete);
            ++this.gbc.gridx;
            this.ok = new Button("OK");
            this.add(this.ok);
            ++this.gbc.gridx;
            this.cancel = new Button("Cancel");
            this.add(this.cancel);
            ++this.gbc.gridx;
            this.add = new Button("Add");
            this.add(this.add);
            ++this.gbc.gridy;
            this.gbc.gridx = 0;
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.fill = 2;
            this.add(this.constructFieldPanel());
            ++this.gbc.gridy;
            this.add(this.constructTextPanel());
            this.delete.setEnabled(false);
            this.add.setEnabled(false);
            this.options.addItemListener(this);
            this.delete.addActionListener(this);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.add.addActionListener(this);
            this.tf.addActionListener(this);
            this.tf.addTextListener(this);
            this.addWindowListener(this);
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getPreferredSize();
            Point point = new Point(0, 0);
            point.x = (dimension.width - dimension2.width) / 2;
            point.y = (dimension.height - dimension2.height) / 2;
            this.setLocation(point);
        }

        private Component constructTextPanel() {
            Panel panel = new Panel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.gridwidth = 0;
            panel.setLayout(gridBagLayout);
            Label label = new Label("Classes with these Package names");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel.add(label);
            ++gridBagConstraints.gridy;
            gridBagConstraints.anchor = 18;
            label = new Label("will be forced to load remotely.");
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel.add(label);
            return panel;
        }

        private Component constructFieldPanel() {
            Panel panel = new Panel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(3, 5, 3, 0);
            panel.setLayout(gridBagLayout);
            Label label = new Label("Add Package name:");
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(label, gridBagConstraints);
            panel.add(label);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.right = 5;
            this.tf = new TextField("", 10);
            gridBagLayout.setConstraints(this.tf, gridBagConstraints);
            panel.add(this.tf);
            return panel;
        }

        public Component add(Component component) {
            this.gb.setConstraints(component, this.gbc);
            return super.add(component);
        }

        public void textValueChanged(TextEvent textEvent) {
            if (textEvent.getSource() != this.tf) {
                return;
            }
            String string = this.tf.getText();
            if (string != null && string.length() > 0) {
                this.add.setEnabled(true);
            } else {
                this.add.setEnabled(false);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object != this.options) {
                return;
            }
            String string = this.options.getSelectedItem();
            if (string == null) {
                this.delete.setEnabled(false);
            } else {
                this.delete.setEnabled(true);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.tf) {
                String string = this.tf.getText();
                if (string != null && string.length() > 0) {
                    this.add.setEnabled(true);
                }
            } else if (object == this.ok || object == this.cancel) {
                this.exitHook(object == this.ok);
            } else if (object == this.delete) {
                int n = this.options.getSelectedIndex();
                if (n > 0) {
                    this.options.delItem(n);
                }
                this.delete.setEnabled(false);
            } else if (object == this.add) {
                String string = this.tf.getText();
                if (string != null && string.length() > 0) {
                    this.options.add(string);
                    this.tf.setText("");
                }
                this.add.setEnabled(false);
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.exitHook(false);
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        private void exitHook(boolean bl) {
            this.ar.dialogOpen = false;
            if (bl) {
                int n = this.options.getItemCount();
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = this.options.getItem(i);
                }
                this.ar.loadRemote = stringArray;
            }
            this.setVisible(false);
            super.dispose();
        }
    }
}

