/*
 * Decompiled with CFR 0.152.
 */
package utils.applet.archiver;

import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sun.applet.AppletAudioClip;
import utils.applet.archiver.AppletArchiver;
import utils.applet.archiver.CRC32OutputStream;
import utils.applet.archiver.ProcRunner;

public class AppletClassLoader
extends ClassLoader {
    URL codebase;
    PrintStream ps;
    ZipOutputStream zos;
    File cabDir;
    boolean isCab;
    String fileName;
    String dumpOnClass;
    Hashtable images = new Hashtable();
    Hashtable audio = new Hashtable();
    String[] remList;
    boolean compressJar;
    static boolean gotMiscClasses = false;
    static JarFile weblogicJar = null;
    public static final String CLASSPATH_PROP = "java.class.path";

    public AppletClassLoader(URL uRL, PrintStream printStream, String string, File file, String[] stringArray, String string2, boolean bl) throws IOException {
        this.codebase = uRL;
        this.compressJar = bl;
        this.dumpOnClass = string2;
        this.remList = stringArray;
        if (this.dumpOnClass == null) {
            this.dumpOnClass = "";
        }
        this.ps = printStream;
        this.fileName = string;
        this.cabDir = file;
        if (this.cabDir != null) {
            System.out.println("cabDir=" + file.getAbsolutePath());
            this.isCab = true;
        } else {
            this.zos = new ZipOutputStream(new FileOutputStream(string));
            if (!bl) {
                this.zos.setMethod(0);
            }
            this.getMiscClasses();
            gotMiscClasses = true;
        }
    }

    private void deltree(File file) {
        String[] stringArray = file.list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.deltree(file2);
                continue;
            }
            file2.delete();
        }
        file.delete();
    }

    void p(String string) {
        this.ps.println(string);
        System.out.println(string);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        int n;
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
        } else {
            return clazz;
        }
        boolean bl2 = true;
        for (n = 0; this.remList != null && n < this.remList.length; ++n) {
            if (!string.startsWith(this.remList[n])) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            return clazz;
        }
        clazz = this.findURLClass(string);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    byte[] loadBytes(URL uRL, String string) throws IOException {
        byte[] byArray;
        int n;
        InputStream inputStream = null;
        String string2 = AppletArchiver.getInstance().getAuthenticationInfo(false);
        URLConnection uRLConnection = null;
        while (inputStream == null) {
            uRLConnection = (HttpURLConnection)uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Mozilla/404");
            if (string2 != null) {
                uRLConnection.setRequestProperty("Authorization", "Basic " + string2);
            }
            try {
                inputStream = uRLConnection.getInputStream();
            }
            catch (IOException iOException) {
                if (uRLConnection != null) {
                    if (((HttpURLConnection)uRLConnection).getResponseCode() == 401) {
                        AppletArchiver.getInstance().setAuthenticationInfo(null);
                        string2 = AppletArchiver.getInstance().getAuthenticationInfo(true);
                        if (string2 != null) continue;
                        throw new ProtocolException("HTTP Authorization failed");
                    }
                }
                throw iOException;
            }
        }
        int n2 = uRLConnection.getContentLength();
        byte[] byArray2 = new byte[n2 == -1 ? 4096 : n2];
        int n3 = 0;
        do {
            if ((n = inputStream.read(byArray2, n3, byArray2.length - n3)) == -1 || (n3 += n) != byArray2.length) continue;
            if (n3 == n2) break;
            byArray = new byte[n3 << 1];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
            byArray2 = byArray;
        } while (n != -1);
        this.ps.println(n3 + " bytes, " + string);
        if (n3 != n2) {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
            byArray2 = byArray;
        }
        this.saveBytes(byArray2, string, byArray2.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AudioClip loadAudioClip(URL uRL) throws IOException {
        String string = uRL.getFile();
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        Hashtable hashtable = this.audio;
        synchronized (hashtable) {
            AudioClip audioClip = (AudioClip)this.audio.get(string);
            if (audioClip != null) {
                return audioClip;
            }
            byte[] byArray = this.loadBytes(uRL, string);
            audioClip = new AppletAudioClip(byArray);
            this.audio.put(string, audioClip);
            return audioClip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Image loadImage(URL uRL) throws IOException {
        String string = uRL.getFile();
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        Hashtable hashtable = this.images;
        synchronized (hashtable) {
            Image image = (Image)this.images.get(string);
            if (image != null) {
                return image;
            }
            byte[] byArray = this.loadBytes(uRL, string);
            image = Toolkit.getDefaultToolkit().createImage(byArray);
            this.images.put(string, image);
            return image;
        }
    }

    synchronized Class findURLClass(String string) throws ClassNotFoundException {
        if (this.dumpOnClass.length() > 1 && string.indexOf(this.dumpOnClass) >= 0) {
            System.err.println("loading class: " + string + ", matches " + this.dumpOnClass + ":");
            Thread.dumpStack();
            System.err.println();
        }
        URL uRL = null;
        try {
            String string2 = null;
            if (!(gotMiscClasses || string.lastIndexOf("MANIFEST.MF") == -1 && string.indexOf("i18n") == -1)) {
                int n = 0;
                n = string.lastIndexOf(".");
                if (n != -1) {
                    StringBuffer stringBuffer = new StringBuffer(string.replace('.', '/'));
                    stringBuffer.setCharAt(n, '.');
                    string2 = stringBuffer.toString();
                }
            } else {
                string2 = string.replace('.', '/') + ".class";
            }
            uRL = new URL(this.codebase, string2);
            byte[] byArray = this.loadBytes(uRL, string2);
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (string.startsWith("javax")) {
                try {
                    return this.findSystemClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                    throw new ClassNotFoundException(uRL == null ? string : uRL.toString());
                }
            }
            fileNotFoundException.printStackTrace();
            throw new ClassNotFoundException(uRL == null ? string : uRL.toString());
        }
        catch (IOException iOException) {
            this.ps.println("ERROR: " + iOException.toString());
            iOException.printStackTrace();
            throw new ClassNotFoundException(uRL == null ? string : uRL.toString());
        }
    }

    void saveBytes(byte[] byArray, String string, int n) throws IOException {
        if (gotMiscClasses && string.indexOf("i18n") != -1) {
            return;
        }
        if (!this.isCab) {
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setSize(n);
            if (!this.compressJar) {
                CRC32OutputStream cRC32OutputStream = new CRC32OutputStream();
                cRC32OutputStream.write(byArray, 0, n);
                zipEntry.setCrc(cRC32OutputStream.crc.getValue());
            }
            this.zos.putNextEntry(zipEntry);
            this.zos.write(byArray, 0, n);
        } else {
            string = string.replace('/', File.separatorChar);
            File file = new File(this.cabDir, string);
            File file2 = new File(file.getParent());
            file2.mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
            ((OutputStream)fileOutputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (!this.isCab) {
                this.zos.close();
                File file = new File(this.fileName);
                this.p("jar file saved: " + file.getAbsolutePath() + ", size=" + file.length());
                this.zos = null;
                return;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        Process process = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("cabarc -r -p -P ");
            stringBuffer.append(this.cabDir.getName());
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(" N ");
            stringBuffer.append(this.fileName);
            stringBuffer.append(' ');
            stringBuffer.append(this.cabDir.getName());
            stringBuffer.append(File.separatorChar);
            stringBuffer.append('*');
            this.p("launching cabarc tool: " + stringBuffer.toString());
            process = Runtime.getRuntime().exec(stringBuffer.toString());
            Thread thread2 = new Thread((Runnable)new ProcRunner(process.getInputStream(), this.ps), "stdout");
            thread2.start();
            Thread thread3 = new Thread((Runnable)new ProcRunner(process.getErrorStream(), this.ps), "stderr");
            thread3.start();
            int n = process.waitFor();
            thread2.join();
            thread3.join();
            this.p("cabarc exit value: " + n);
            if (n == 0) {
                File file = new File(this.fileName);
                this.p("cab file saved: " + file.getAbsolutePath() + ", size=" + file.length());
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            this.p("CABARC ERROR: do you have cabarc.exe in you path?");
            iOException.printStackTrace();
        }
        finally {
            this.ps.print("deleting temporary cab directory...");
            this.deltree(this.cabDir);
            this.ps.println("done");
        }
    }

    void getMiscClasses() {
        String string = System.getProperty(CLASSPATH_PROP);
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.endsWith("weblogic.jar")) continue;
            try {
                weblogicJar = new JarFile(string2);
                break;
            }
            catch (Exception exception) {
                System.out.println("No weblogic.jar in classpath. Archive will be incomplete.");
                return;
            }
        }
        if (weblogicJar != null) {
            Enumeration<JarEntry> enumeration = weblogicJar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                string3 = zipEntry.getName();
                if (zipEntry.isDirectory() || string3.indexOf("i18n") == -1 && string3.indexOf("MANIFEST.MF") == -1) continue;
                try {
                    this.findURLClass(string3);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (ClassFormatError classFormatError) {
                }
                catch (Exception exception) {}
            }
        }
    }

    public URL getResource(String string) {
        try {
            URL uRL = AppletClassLoader.getSystemResource(string);
            if (uRL != null) {
                return uRL;
            }
            uRL = new URL(this.codebase, string);
            uRL.openStream().close();
            return uRL;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = AppletClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        try {
            inputStream = new URL(this.codebase, string).openStream();
        }
        catch (IOException iOException) {
            return null;
        }
        return inputStream;
    }
}

