/*
 * Decompiled with CFR 0.152.
 */
package utils.applet.archiver;

import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import utils.applet.archiver.AppletArchiver;
import utils.applet.archiver.AppletClassLoader;
import utils.applet.archiver.AttsDialog;
import utils.applet.archiver.Queue;

public class AppletFrame
extends Frame
implements AppletStub,
AppletContext,
Runnable,
WindowListener,
ActionListener {
    URL codebase;
    URL docbase;
    AppletArchiver ar;
    AppletClassLoader loader;
    Hashtable atts;
    Applet applet;
    int w;
    int h;
    int currentState;
    Dimension appletSize;
    Queue queue = new Queue(250);
    Label status;
    MenuItem exitNSave;
    MenuItem showAtts;
    static final int APPLET_START = 0;
    static final int APPLET_STOP = 1;
    static final int APPLET_DESTROY = 2;

    public AppletFrame(URL uRL, URL uRL2, AppletArchiver appletArchiver, Hashtable hashtable, AppletClassLoader appletClassLoader) {
        super(uRL2.toString());
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(Color.lightGray);
        this.codebase = uRL;
        this.docbase = uRL2;
        this.ar = appletArchiver;
        this.loader = appletClassLoader;
        this.atts = hashtable;
        String string = (String)hashtable.get("WIDTH");
        try {
            this.w = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.w = 200;
        }
        this.addWindowListener(this);
        String string2 = (String)hashtable.get("HEIGHT");
        try {
            this.h = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            this.h = 200;
        }
        this.appletSize = new Dimension(this.w, this.h);
        this.status = new Label("");
        this.add((Component)this.status, "South");
        Font font = new Font("SansSerif", 1, 12);
        this.status.setFont(font);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.h = this.h + fontMetrics.getHeight() + 10;
        this.w += 10;
        this.setSize(this.w, this.h);
        Image image = appletArchiver.getIcon();
        if (image != null) {
            this.setIconImage(image);
        }
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Options");
        this.exitNSave = new MenuItem("Quit and Save");
        menu.add(this.exitNSave);
        this.showAtts = new MenuItem("Show tag...");
        menu.add(this.showAtts);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.exitNSave.addActionListener(this);
        this.showAtts.addActionListener(this);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(new Point((dimension.width - this.w) / 2, (dimension.height - this.h) / 2));
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String string = this.getParameter("CODE");
            if (string.endsWith(".class")) {
                string = string.substring(0, string.length() - 6);
            }
            this.showStatus("loading " + string + ':');
            this.applet = (Applet)this.loader.loadClass(string).newInstance();
            this.ar.applets.put(this.applet.getClass().getName(), this.applet);
            this.applet.setStub(this);
            this.applet.hide();
            this.add((Component)this.applet, "North");
            this.setVisible(true);
            this.applet.resize(this.appletSize);
            this.showStatus("initializing " + string + ':');
            this.applet.init();
            this.validate();
            this.applet.resize(this.appletSize);
            this.validate();
            this.showStatus("starting " + string + ':');
            this.applet.start();
            this.applet.show();
            this.currentState = 0;
            this.showStatus("Applet " + string + " started.");
            this.doLayout();
            Toolkit.getDefaultToolkit().sync();
            this.eventLoop();
            this.loader.close();
        }
        catch (Error error) {
            error.printStackTrace();
            this.showStatus("error: " + error.toString());
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus("error: " + exception.toString());
        }
        finally {
            if (this.applet != null) {
                this.ar.applets.remove(this.applet.getClass().getName());
            }
            this.setVisible(false);
        }
    }

    int getNextEvent() {
        Integer n = (Integer)this.queue.get();
        if (n == null) {
            return 2;
        }
        return n;
    }

    void putNextEvent(int n) {
        try {
            this.queue.put(new Integer(n));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void eventLoop() {
        while (this.currentState != 2) {
            switch (this.getNextEvent()) {
                case 1: {
                    if (this.currentState == 0) {
                        this.applet.hide();
                        this.applet.stop();
                    }
                    this.currentState = 1;
                    break;
                }
                case 0: {
                    if (this.currentState == 1) {
                        this.applet.resize(this.appletSize);
                        this.applet.start();
                        this.validate();
                        this.applet.show();
                    }
                    this.currentState = 0;
                    break;
                }
                case 2: {
                    if (this.currentState == 0) {
                        this.applet.hide();
                        this.applet.stop();
                    }
                    this.applet.destroy();
                    this.currentState = 2;
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.exitNSave) {
            this.putNextEvent(2);
        } else if (object == this.showAtts) {
            new Thread(new AttsDialog(this)).start();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public synchronized void windowClosing(WindowEvent windowEvent) {
        this.putNextEvent(2);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public synchronized void windowIconified(WindowEvent windowEvent) {
        this.putNextEvent(1);
    }

    public synchronized void windowDeiconified(WindowEvent windowEvent) {
        this.putNextEvent(0);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    void p(String string) {
        this.ar.out.println(string);
    }

    public boolean isActive() {
        return this.isVisible();
    }

    public URL getDocumentBase() {
        return this.docbase;
    }

    public URL getCodeBase() {
        return this.codebase;
    }

    public String getParameter(String string) {
        return (String)this.atts.get(string);
    }

    public AppletContext getAppletContext() {
        return this;
    }

    public void appletResize(int n, int n2) {
        if (this.applet != null) {
            this.applet.resize(n, n2);
        }
    }

    public Image getImage(URL uRL) {
        try {
            return this.loader.loadImage(uRL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public AudioClip getAudioClip(URL uRL) {
        try {
            return this.loader.loadAudioClip(uRL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Applet getApplet(String string) {
        return (Applet)this.ar.applets.get(string);
    }

    public Enumeration getApplets() {
        return this.ar.applets.elements();
    }

    public void showStatus(String string) {
        if (string != null) {
            this.status.setText(string);
        } else {
            this.status.setText("");
        }
    }

    public void showDocument(URL uRL) {
        this.ar.out.println("warn: applet.showDocument(" + uRL + ") ignored");
    }

    public void showDocument(URL uRL, String string) {
        try {
            URL uRL2 = new URL(uRL, string);
            this.ar.out.println("warn: applet.showDocument(" + uRL2 + ") ignored");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStream(String string, InputStream inputStream) {
    }

    public InputStream getStream(String string) {
        return null;
    }

    public Iterator getStreamKeys() {
        return null;
    }
}

