/*
 * Decompiled with CFR 0.152.
 */
package utils.applet.archiver;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import utils.applet.archiver.AppletArchiver;

public class Parser
implements Runnable {
    public static final String DONE = "done";
    int c;
    ActionListener listener;
    Vector v = new Vector();
    InputStream in;
    Hashtable atts = new Hashtable();
    boolean inAppletTag = false;
    URL u;
    Exception failure;
    boolean canceled = false;

    void p(String string) {
        System.out.println(string);
    }

    public Exception getException() {
        return this.failure;
    }

    public Vector getTags() {
        return this.v;
    }

    public Parser(URL uRL, ActionListener actionListener) {
        this.listener = actionListener;
        this.u = uRL;
    }

    public Parser(InputStream inputStream, ActionListener actionListener) {
        this.listener = actionListener;
        this.in = inputStream;
    }

    public void cancel() {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string = DONE;
        String string2 = AppletArchiver.getInstance().getAuthenticationInfo(false);
        try {
            while (this.in == null) {
                HttpURLConnection httpURLConnection = null;
                try {
                    httpURLConnection = (HttpURLConnection)this.u.openConnection();
                    httpURLConnection.setRequestProperty("User-Agent", "Mozilla/404");
                    if (string2 != null) {
                        httpURLConnection.setRequestProperty("Authorization", "Basic " + string2);
                    }
                    this.in = httpURLConnection.getInputStream();
                }
                catch (Exception exception) {
                    if (httpURLConnection != null) {
                        if (httpURLConnection.getResponseCode() == 401) {
                            AppletArchiver.getInstance().setAuthenticationInfo(null);
                            string2 = AppletArchiver.getInstance().getAuthenticationInfo(true);
                            if (string2 != null) continue;
                            throw new ProtocolException("HTTP Authorization failed");
                        }
                    }
                    throw exception;
                }
            }
            this.parse();
            if (this.v.size() == 0) {
                throw new IOException("No applet tags found in that page");
            }
        }
        catch (Exception exception) {
            this.failure = exception;
            string = this.failure.toString();
        }
        finally {
            if (!this.canceled && this.listener != null) {
                this.listener.actionPerformed(new ActionEvent(this, 0, string));
            }
        }
    }

    public void parse() throws IOException {
        while ((this.c = this.in.read()) != -1) {
            if (this.c != 60) continue;
            this.c = this.in.read();
            this.skipIfWS();
            if (this.inAppletTag) {
                this.scanParamTag();
                continue;
            }
            if (!this.isAppletTag()) continue;
            this.inAppletTag = true;
            this.c = this.in.read();
            this.scanAppletTag();
        }
    }

    boolean isWS() {
        return this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13;
    }

    void skipIfWS() throws IOException {
        if (this.isWS()) {
            this.skipWS();
        }
    }

    public void skipWS() throws IOException {
        do {
            this.c = this.in.read();
        } while (this.isWS() && this.c != -1);
    }

    boolean isAppletTag() throws IOException {
        if (this.c != 65 && this.c != 97) {
            return false;
        }
        this.c = this.in.read();
        if (this.c != 80 && this.c != 112) {
            return false;
        }
        this.c = this.in.read();
        if (this.c != 80 && this.c != 112) {
            return false;
        }
        this.c = this.in.read();
        if (this.c != 76 && this.c != 108) {
            return false;
        }
        this.c = this.in.read();
        if (this.c != 69 && this.c != 101) {
            return false;
        }
        this.c = this.in.read();
        return this.c == 84 || this.c == 116;
    }

    void scanAppletTag() throws IOException {
        do {
            this.skipIfWS();
            if (this.c == 62) break;
            String[] stringArray = null;
            stringArray = this.scanParam();
            if (stringArray == null) continue;
            this.atts.put(stringArray[0].toUpperCase(), stringArray[1]);
        } while (this.c != 62);
    }

    void scanParamTag() throws IOException {
        this.skipIfWS();
        String string = this.scanString().toUpperCase();
        if (string.equals("/APPLET")) {
            this.inAppletTag = false;
            this.v.addElement(this.atts);
            this.atts = new Hashtable();
            return;
        }
        if (!string.equals("PARAM")) {
            return;
        }
        this.skipIfWS();
        String[] stringArray = this.scanParam();
        if (stringArray == null || !stringArray[0].toUpperCase().equals("NAME") || this.c == 62) {
            return;
        }
        String string2 = stringArray[1];
        this.skipIfWS();
        stringArray = this.scanParam();
        if (stringArray == null || !stringArray[0].toUpperCase().equals("VALUE")) {
            return;
        }
        this.atts.put(string2, stringArray[1]);
    }

    String[] scanParam() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[2];
        stringArray[1] = "";
        do {
            stringBuffer.append((char)this.c);
        } while ((this.c = this.in.read()) != -1 && this.c != 62 && !this.isWS() && this.c != 61);
        stringArray[0] = stringBuffer.toString();
        this.skipIfWS();
        if (this.c == 62) {
            if (stringBuffer.length() > 0) {
                return stringArray;
            }
            return null;
        }
        if (this.c != 61) {
            return stringArray;
        }
        stringBuffer.setLength(0);
        this.c = this.in.read();
        this.skipIfWS();
        if (this.c == 62 || this.c == -1) {
            return stringArray;
        }
        this.skipIfWS();
        if (this.c == 39 || this.c == 34) {
            int n = this.c;
            this.c = this.in.read();
            stringArray[1] = this.scanStringDelim(n);
        } else {
            stringArray[1] = this.scanString();
        }
        return stringArray;
    }

    String scanString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append((char)this.c);
        } while ((this.c = this.in.read()) != -1 && !this.isWS() && this.c != 62);
        return stringBuffer.toString();
    }

    String scanStringDelim(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.c != n) {
            do {
                stringBuffer.append((char)this.c);
                this.c = this.in.read();
            } while (this.c != -1 && this.c != 62 && this.c != n);
            if (this.c == n) {
                this.c = this.in.read();
            }
        } else {
            this.c = this.in.read();
        }
        String string = stringBuffer.toString();
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("Parser: <file | URL>");
            return;
        }
        Parser parser2 = stringArray[0].indexOf("://") == -1 ? new Parser(new FileInputStream(stringArray[0]), null) : new Parser(new URL(stringArray[0]), null);
        parser2.run();
        System.out.println("got tags:");
        for (int i = 0; i < parser2.v.size(); ++i) {
            System.out.println(i + "::" + parser2.v.elementAt(i));
        }
    }
}

