/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class der2pem {
    private static final String usage = "\tUsage: java utils.der2pem derFile [headerFile] [footerFile]\n\n\tWrites file with the same name but with .pem extension\n\tto the same directory as the .der file. The header and footer files\n\tshould contain appropriate pem headers and footers\n";
    private static final String CERT_HEADER = "-----BEGIN CERTIFICATE-----\n";
    private static final String CERT_FOOTER = "-----END CERTIFICATE-----\n";
    private static final String ENCR_KEY_HEADER = "-----BEGIN ENCRYPTED PRIVATE KEY-----\n";
    private static final String ENCR_KEY_FOOTER = "-----END ENCRYPTED PRIVATE KEY-----\n";
    private static final int BYTES_PER_LINE = 60;
    private static final int EOF = -1;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private static Object openFile(String string, boolean bl) {
        Closeable closeable = null;
        try {
            closeable = bl ? new FileInputStream(string) : new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("\n\tCannot open file " + string + ".\n\t" + fileNotFoundException.getMessage() + "\n\n" + usage);
            System.exit(1);
        }
        return closeable;
    }

    private static byte[] readFile(String string) throws IOException {
        FileInputStream fileInputStream = (FileInputStream)der2pem.openFile(string, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(fileInputStream.available());
        int n = 0;
        while ((n = fileInputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        fileInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void main(String[] stringArray) throws Exception {
        byte[] byArray;
        String string;
        int n;
        if (stringArray.length < 1) {
            System.out.println(usage);
            System.exit(1);
        }
        if ((n = (string = stringArray[0]).lastIndexOf(".")) < 0 || !string.substring(n + 1).equalsIgnoreCase("der")) {
            System.out.println("\nDer input file with extention der is expected\n\n\tUsage: java utils.der2pem derFile [headerFile] [footerFile]\n\n\tWrites file with the same name but with .pem extension\n\tto the same directory as the .der file. The header and footer files\n\tshould contain appropriate pem headers and footers\n");
            System.exit(1);
        }
        String string2 = string.substring(0, n) + ".pem";
        InputStream inputStream = (InputStream)der2pem.openFile(string, true);
        OutputStream outputStream = (OutputStream)der2pem.openFile(string2, false);
        byte[] byArray2 = stringArray.length > 1 ? der2pem.readFile(stringArray[1]) : null;
        byte[] byArray3 = byArray = stringArray.length > 2 ? der2pem.readFile(stringArray[2]) : null;
        if (byArray2 == null) {
            byArray2 = CERT_HEADER.getBytes();
        }
        if (byArray == null) {
            byArray = CERT_FOOTER.getBytes();
        }
        der2pem.convert(inputStream, outputStream, byArray2, byArray);
        inputStream.close();
        outputStream.close();
    }

    public static void convertCertificate(InputStream inputStream, OutputStream outputStream) throws IOException {
        der2pem.convert(inputStream, outputStream, CERT_HEADER.getBytes(), CERT_FOOTER.getBytes());
    }

    public static void convertEncryptedKey(InputStream inputStream, OutputStream outputStream) throws IOException {
        der2pem.convert(inputStream, outputStream, ENCR_KEY_HEADER.getBytes(), ENCR_KEY_FOOTER.getBytes());
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, byte[] byArray, byte[] byArray2) throws IOException {
        outputStream.write(byArray);
        byte[] byArray3 = new byte[3];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        while ((n2 = inputStream.read(byArray3)) != -1) {
            if (bl) {
                outputStream.write(10);
                bl = false;
            }
            der2pem.encodeAtom(outputStream, byArray3, 0, n2);
            if (n2 < 3) break;
            if ((n += 4) <= 60) continue;
            bl = true;
            n = 0;
        }
        outputStream.write(10);
        outputStream.write(byArray2);
    }

    public static void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 1) {
            byte by = byArray[n];
            int n3 = 0;
            boolean bl = false;
            outputStream.write(pem_array[by >>> 2 & 0x3F]);
            outputStream.write(pem_array[(by << 4 & 0x30) + (n3 >>> 4 & 0xF)]);
            outputStream.write(61);
            outputStream.write(61);
        } else if (n2 == 2) {
            byte by = byArray[n];
            byte by2 = byArray[n + 1];
            int n4 = 0;
            outputStream.write(pem_array[by >>> 2 & 0x3F]);
            outputStream.write(pem_array[(by << 4 & 0x30) + (by2 >>> 4 & 0xF)]);
            outputStream.write(pem_array[(by2 << 2 & 0x3C) + (n4 >>> 6 & 3)]);
            outputStream.write(61);
        } else {
            byte by = byArray[n];
            byte by3 = byArray[n + 1];
            byte by4 = byArray[n + 2];
            outputStream.write(pem_array[by >>> 2 & 0x3F]);
            outputStream.write(pem_array[(by << 4 & 0x30) + (by3 >>> 4 & 0xF)]);
            outputStream.write(pem_array[(by3 << 2 & 0x3C) + (by4 >>> 6 & 3)]);
            outputStream.write(pem_array[by4 & 0x3F]);
        }
    }
}

