/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class logToZip {
    static ZipOutputStream zipArchive = null;
    static ZipEntry zipEntry = null;
    static BufferedInputStream classToBeArchived = null;
    static FileOutputStream archiveToCreate = null;
    static FileInputStream logToScan = null;
    static Hashtable classList = null;
    static String codeBase = null;
    static String zipname = null;
    static boolean i18n = false;
    static JarFile weblogicJar = null;
    private static final int bufsize = 8192;
    public static final String CLASSPATH_PROP = "java.class.path";
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Usage: java utils.logToZip httplogfile codebase_directory zipfile\nExample: java utils.logToZip /usr/http/logs/access classes myapplet.zip\nHelp at: @DOCSWEBROOT");
            System.exit(1);
            return;
        }
        zipname = stringArray[2];
        try {
            File file = new File(stringArray[0]);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                System.out.println("\nCannot find a readable log file named");
                System.out.println("'" + stringArray[0] + "' to scan. Check path and permissions.\n");
                System.out.println("Note: This should be run from the document root of your HTTP server");
                return;
            }
            logToScan = new FileInputStream(file);
            codeBase = stringArray[1];
            if (codeBase.length() > 0 && codeBase.charAt(0) == '/') {
                codeBase = codeBase.length() > 1 ? codeBase.substring(1) : "";
            }
            File file2 = new File(zipname);
            try {
                archiveToCreate = new FileOutputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Cannot create file " + file2 + "\n");
                System.exit(1);
            }
            zipArchive = new ZipOutputStream(archiveToCreate);
            zipArchive.setMethod(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (!logToZip.createListOfClasses()) {
            System.out.println("No class files found in log. No zip archive created.\nRun this from the document root directory of your HTTP server.");
            System.exit(1);
        }
        logToZip.getMiscFiles();
        logToZip.fillArchive();
        System.exit(0);
    }

    public static boolean createListOfClasses() {
        classList = new Hashtable();
        String string = null;
        boolean bl = false;
        while ((string = logToZip.getNextClassName()) != null) {
            bl = true;
            if (string.indexOf("i18n") != -1) {
                i18n = true;
                continue;
            }
            classList.put(string, "");
        }
        return bl;
    }

    public static void getMiscFiles() {
        String string = System.getProperty(CLASSPATH_PROP);
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.endsWith("weblogic.jar")) continue;
            try {
                weblogicJar = new JarFile(string2);
                break;
            }
            catch (Exception exception) {
                System.out.println("Unable to open weblogic.jar");
                break;
            }
        }
        if (weblogicJar != null) {
            Enumeration<JarEntry> enumeration = weblogicJar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                string3 = zipEntry.getName();
                if (zipEntry.isDirectory() || !i18n || string3.indexOf("i18n") == -1) continue;
                classList.put(string3, "");
            }
        }
        classList.put(MANIFEST_NAME, "");
    }

    public static String getNextClassName() {
        String string = null;
        String string2 = null;
        do {
            if ((string = logToZip.readLineFromLogFile()) != null) continue;
            return null;
        } while (string.startsWith("[Open") || string.startsWith("[Loaded [") || string.startsWith("[Loaded SymantecJITCompilationThread") || string.startsWith("[Loaded $Proxy") || string.indexOf("DispatcherImpl_WLSkel") != -1 || string.indexOf("DGCServerImpl_WLSkel") != -1 || (string2 = logToZip.getClassNameFrom(string)).equals(""));
        return string2;
    }

    public static String readLineFromLogFile() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        try {
            n = logToScan.read();
            while (n != 10 && n != -1) {
                stringBuffer.append((char)n);
                n = logToScan.read();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        if (n == 10) {
            if (stringBuffer.length() == 0) {
                return "";
            }
        } else if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String getClassNameFrom(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.endsWith(".class")) continue;
            string2 = string3.substring(1);
            if (codeBase.length() > 0) {
                if (!string2.startsWith(codeBase)) {
                    System.out.print("codebase_directory argument '" + codeBase + "' ");
                    System.out.print("doesn't match the ");
                    System.out.println("prefix of '" + string2 + "'");
                    System.exit(0);
                }
                return string2.substring(codeBase.length() + 1);
            }
            return string2;
        }
        return string2;
    }

    public static void fillArchive() {
        Enumeration enumeration = classList.keys();
        String string = null;
        String string2 = null;
        int n = 0;
        try {
            while (enumeration.hasMoreElements()) {
                int n2;
                string = (String)enumeration.nextElement();
                string2 = codeBase.length() > 0 ? codeBase + "/" + string : string;
                File file = new File(string2);
                if (!(file.exists() && file.isFile() && file.canRead())) {
                    System.out.println("Unable to find class file named '" + string2 + "'.\nAre you running this from " + "from the document root of the HTTP server?");
                    return;
                }
                System.out.println("[" + string + "]");
                classToBeArchived = new BufferedInputStream(new FileInputStream(file));
                zipEntry = new ZipEntry(string);
                Vector<byte[]> vector = new Vector<byte[]>();
                Vector<Integer> vector2 = new Vector<Integer>();
                long l = 0L;
                byte[] byArray = new byte[8192];
                CRC32 cRC32 = new CRC32();
                cRC32.reset();
                while ((n2 = classToBeArchived.read(byArray, 0, byArray.length)) != -1) {
                    if (byArray.length > 0) {
                        cRC32.update(byArray, 0, n2);
                        vector.addElement(byArray);
                        vector2.addElement(new Integer(n2));
                        l += (long)n2;
                    }
                    byArray = new byte[8192];
                }
                classToBeArchived.close();
                zipEntry.setSize(l);
                zipEntry.setCrc(cRC32.getValue());
                zipArchive.putNextEntry(zipEntry);
                Enumeration enumeration2 = vector.elements();
                Enumeration enumeration3 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    byArray = (byte[])enumeration2.nextElement();
                    n2 = (Integer)enumeration3.nextElement();
                    zipArchive.write(byArray, 0, n2);
                }
                zipArchive.closeEntry();
                ++n;
            }
            zipArchive.close();
            System.out.println("Created zip file: " + zipname + " with " + n + " class files");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }
}

