/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.Source;

public final class verboseToZip {
    private static ZipOutputStream zipArchive = null;
    private static ZipEntry zipEntry = null;
    private static InputStream classToBeArchived = null;
    private static FileOutputStream archiveToCreate = null;
    private static FileInputStream logToScan = null;
    private static Hashtable classList = null;
    private static String zipname = null;
    private static JarFile weblogicJar = null;
    private static final int bufsize = 8192;
    private static final String CLASSPATH_PROP = "java.class.path";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: java utils.verboseToZip verboseFileToScan zipArchiveToBeCreated\nHelp at: @DOCSWEBROOT");
            return;
        }
        zipname = stringArray[1];
        try {
            File file = new File(stringArray[0]);
            if (!(file.exists() && file.isFile() && file.canRead())) {
                System.out.println("\nCannot find a readable file named");
                System.out.println("'" + stringArray[0] + "' to scan. Check path and permissions.\n");
                return;
            }
            logToScan = new FileInputStream(file);
            File file2 = new File(zipname);
            try {
                archiveToCreate = new FileOutputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Cannot create zip file " + file2 + "\n");
                System.exit(0);
            }
            zipArchive = new ZipOutputStream(archiveToCreate);
            zipArchive.setMethod(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        if (!verboseToZip.createListOfClasses()) {
            System.out.println("\n'" + stringArray[0] + "' doesn't have a list of classes like the output of java -verbose.\n" + "This utility will make a zip file from an input file containing lines\n" + "of the form:\n\n" + "[Loaded /weblogic/classes/weblogic/jdbc/dblib/Driver.class]\n\n" + "No zip archive created.");
            return;
        }
        verboseToZip.getMiscFiles();
        verboseToZip.fillArchive();
    }

    private static boolean createListOfClasses() {
        String string;
        classList = new Hashtable();
        boolean bl = false;
        while ((string = verboseToZip.getNextClassName()) != null) {
            bl = true;
            if (string.indexOf("i18n") != -1) continue;
            classList.put(string, "");
        }
        return bl;
    }

    private static void getMiscFiles() {
        String string = System.getProperty(CLASSPATH_PROP);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.endsWith("weblogic.jar")) continue;
            try {
                weblogicJar = new JarFile(string2);
                break;
            }
            catch (Exception exception) {
                System.out.println("Unable to open weblogic.jar");
                break;
            }
        }
        if (weblogicJar != null) {
            Enumeration<JarEntry> enumeration = weblogicJar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string3 = zipEntry.getName();
                if (zipEntry.isDirectory() || string3.indexOf("i18n") == -1) continue;
                classList.put(string3, "");
            }
        }
        classList.put(MANIFEST_NAME, "");
    }

    private static String getNextClassName() {
        String string;
        String string2;
        do {
            if ((string2 = verboseToZip.readLineFromLogFile()) != null) continue;
            return null;
        } while (string2.startsWith("[Open") || string2.startsWith("[Loaded [") || string2.startsWith("[Loaded SymantecJITCompilationThread") || string2.startsWith("[Loaded $Proxy") || string2.indexOf("_WLSkel") != -1 || string2.indexOf("_WLStub") != -1 || string2.indexOf("DispatcherImpl_WLSkel") != -1 || (string = verboseToZip.getClassNameFrom(string2)).equals(""));
        return string;
    }

    private static String readLineFromLogFile() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        try {
            n = logToScan.read();
            while (n != 10 && n != -1) {
                stringBuffer.append((char)n);
                n = logToScan.read();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        if (n == 10) {
            if (stringBuffer.length() == 0) {
                return "";
            }
        } else if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private static String getClassNameFrom(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 2) {
            return "";
        }
        String string3 = stringTokenizer.nextToken();
        if (!string3.equals("[Loaded")) {
            return "";
        }
        if (n == 2) {
            String string4 = stringTokenizer.nextToken();
            string2 = string4.substring(0, string4.length() - 1);
            if (!string2.endsWith(".class")) {
                string2 = string2.replace('.', '/') + ".class";
            }
        } else {
            string2 = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            if (string5.indexOf(".zip]") != -1) {
                string2 = "";
            }
            if (string5.indexOf(".jar]") != -1) {
                string2 = "";
            }
        }
        return string2;
    }

    private static String RemoveClassPathRootFrom(String string) {
        String string2;
        String string3 = verboseToZip.normalizePath(string);
        String string4 = string2 = System.getProperty(CLASSPATH_PROP);
        StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (string5.endsWith(".zip") || string5.endsWith(".jar") || !string3.startsWith(string5)) continue;
            return string3.substring(string5.length() + 1);
        }
        return string;
    }

    private static void fillArchive() {
        int n = 0;
        String string = System.getProperty(CLASSPATH_PROP);
        Enumeration enumeration = classList.keys();
        try {
            String string2;
            ClasspathClassFinder2 classpathClassFinder2 = new ClasspathClassFinder2(string);
            while (enumeration.hasMoreElements()) {
                int n2;
                string2 = (String)enumeration.nextElement();
                String string3 = verboseToZip.RemoveClassPathRootFrom(string2);
                Source source = classpathClassFinder2.getSource(string3);
                if (source == null) {
                    source = classpathClassFinder2.getClassSource(string3);
                }
                if (source == null) {
                    System.out.println("Unable to find class file named '" + string3 + "'.");
                    return;
                }
                classToBeArchived = source.getInputStream();
                System.out.println("[" + string3 + "]");
                zipEntry = new ZipEntry(string3);
                if (string3.endsWith(MANIFEST_NAME)) {
                    classToBeArchived = weblogicJar.getInputStream(zipEntry);
                }
                Vector<byte[]> vector = new Vector<byte[]>();
                Vector<Integer> vector2 = new Vector<Integer>();
                long l = 0L;
                byte[] byArray = new byte[8192];
                CRC32 cRC32 = new CRC32();
                cRC32.reset();
                while ((n2 = classToBeArchived.read(byArray, 0, byArray.length)) != -1) {
                    if (byArray.length > 0) {
                        cRC32.update(byArray, 0, n2);
                        vector.addElement(byArray);
                        vector2.addElement(new Integer(n2));
                        l += (long)n2;
                    }
                    byArray = new byte[8192];
                }
                classToBeArchived.close();
                zipEntry.setSize(l);
                zipEntry.setCrc(cRC32.getValue());
                zipArchive.putNextEntry(zipEntry);
                Enumeration enumeration2 = vector.elements();
                Enumeration enumeration3 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    byArray = (byte[])enumeration2.nextElement();
                    n2 = (Integer)enumeration3.nextElement();
                    zipArchive.write(byArray, 0, n2);
                }
                zipArchive.closeEntry();
                ++n;
            }
            zipArchive.close();
            string2 = "files.";
            if (n == 1) {
                string2 = "file. (Only one!?)";
            }
            System.out.println("Created zip file: " + zipname + " containing " + n + " class " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    private static String normalizePath(String string) {
        if (string.indexOf(92) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\\') continue;
            stringBuffer.setCharAt(i, '/');
        }
        return stringBuffer.toString();
    }
}

