/*
 * Decompiled with CFR 0.152.
 */
package weblogic;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import weblogic.application.ApplicationDescriptor;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.utils.io.StreamUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class ClientDeployer {
    private static final int SUFFIX_LENGTH = ".runtime.xml".length();

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            ClientDeployer.usage();
        }
        VirtualJarFile virtualJarFile = null;
        File file = new File(stringArray[0]);
        virtualJarFile = file.isDirectory() ? VirtualJarFactory.createVirtualJar((File)file) : VirtualJarFactory.createVirtualJar((JarFile)new JarFile(stringArray[0]));
        File file2 = file.getParentFile();
        for (int i = 1; i < stringArray.length; ++i) {
            ClientDeployer.processClientJar(virtualJarFile, stringArray[i] + ".jar", new File(file2, stringArray[i] + ".runtime.xml"));
        }
    }

    public static File deploy(File file, JarFile jarFile, File file2) {
        String string = ClientDeployer.getJarFile(file.getName());
        File file3 = new File(file2, string);
        try {
            ClientDeployer.processClientJar(jarFile, string, file, (OutputStream)new BufferedOutputStream(new FileOutputStream(file3)));
        }
        catch (Exception exception) {
            System.out.println("Deployment problem ear=" + jarFile.getName() + ", runtime=" + file + ", problem=" + exception);
            exception.printStackTrace();
        }
        return file3;
    }

    private static void usage() {
        System.out.println("Usage: java weblogic.ClientDeployer <ear-file> <client>...");
        System.out.println("  where the ear-file directory contains client.runtime.xml for every client");
        System.out.println("Example: 'java weblogic.ClientDeployer app.ear client', where app.ear contains client.jar and current directory contains client.runtime.xml");
        System.exit(1);
    }

    private static String getJarFile(String string) {
        return string.substring(0, string.length() - SUFFIX_LENGTH) + ".jar";
    }

    static void processClientJar(VirtualJarFile virtualJarFile, String string, File file) throws IOException, ParserConfigurationException, SAXException {
        ClientDeployer.processClientJar(virtualJarFile, string, file, (OutputStream)new FileOutputStream(string));
    }

    static void processClientJar(JarFile jarFile, String string, File file) throws IOException, ParserConfigurationException, SAXException {
        ClientDeployer.processClientJar(jarFile, string, file, (OutputStream)new FileOutputStream(string));
    }

    private static void processClientJar(JarFile jarFile, String string, File file, OutputStream outputStream) throws IOException, ParserConfigurationException, SAXException {
        ClientDeployer.processClientJar(VirtualJarFactory.createVirtualJar((JarFile)jarFile), string, file, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processClientJar(VirtualJarFile virtualJarFile, String string, File file, OutputStream outputStream) throws IOException, ParserConfigurationException, SAXException {
        ZipInputStream zipInputStream;
        try {
            zipInputStream = new ZipInputStream(virtualJarFile.getInputStream(virtualJarFile.getEntry(string)));
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("No entry " + string + " found in ear file");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        String string2 = ClientDeployer.findAltDDUri(virtualJarFile, string);
        Object object = zipInputStream.getNextEntry();
        while (object != null) {
            if (string2 == null || !"META-INF/application-client.xml".equals(((ZipEntry)object).getName())) {
                if (((ZipEntry)object).getName().equals(string2)) {
                    zipOutputStream.putNextEntry(new ZipEntry("META-INF/application-client.xml"));
                    StreamUtils.writeTo((InputStream)zipInputStream, (OutputStream)zipOutputStream);
                } else {
                    zipOutputStream.putNextEntry((ZipEntry)object);
                    StreamUtils.writeTo((InputStream)zipInputStream, (OutputStream)zipOutputStream);
                }
            }
            object = zipInputStream.getNextEntry();
        }
        if (string2 != null) {
            zipOutputStream.putNextEntry(new ZipEntry("META-INF/application-client.xml"));
            object = null;
            try {
                object = virtualJarFile.getInputStream(new ZipEntry(string2));
                StreamUtils.writeTo((InputStream)object, (OutputStream)zipOutputStream);
            }
            catch (NullPointerException nullPointerException) {
                throw new IOException("Your client-jar specified an alt-dd of " + string2 + " but that uri was not found in the EAR");
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        if (file.exists()) {
            System.out.println("Using weblogic-application-client.xml from " + file.getAbsolutePath());
            zipOutputStream.putNextEntry(new ZipEntry("META-INF/weblogic-application-client.xml"));
            object = null;
            try {
                object = new FileInputStream(file);
                StreamUtils.writeTo((InputStream)object, (OutputStream)zipOutputStream);
            }
            finally {
                if (object != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        zipOutputStream.close();
        zipInputStream.close();
    }

    private static String findAltDDUri(VirtualJarFile virtualJarFile, String string) {
        try {
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(virtualJarFile);
            ApplicationBean applicationBean = applicationDescriptor.getApplicationDescriptor();
            if (applicationBean == null) {
                return null;
            }
            ModuleBean[] moduleBeanArray = applicationBean.getModules();
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                if (!string.equals(moduleBeanArray[i].getJava())) continue;
                return moduleBeanArray[i].getAltDd();
            }
            System.out.println("Warning: client-jar " + string + " was not found in the application.xml");
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

