/*
 * Decompiled with CFR 0.152.
 */
package weblogic;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import weblogic.deploy.internal.DeployerTextFormatter;
import weblogic.utils.Debug;
import weblogic.utils.compiler.Tool;

public class Deployer {
    private static final String oldDeployerClass = "weblogic.deploy.api.tools.deployer.OldDeployer";
    private static final String newDeployerClass = "weblogic.deploy.api.tools.deployer.Deployer";
    private static final String OLD_DEPLOYER_PROPERTY = "weblogic.use.old.deployer";
    private static final String NEW_DEPLOYER_PROPERTY = "weblogic.use.new.deployer";
    private static final boolean forceOld = Debug.getCategory((String)"weblogic.use.old.deployer").isEnabled();
    private static final boolean forceNew = Debug.getCategory((String)"weblogic.use.new.deployer").isEnabled();
    private static final boolean defaultOld = false;
    private static final boolean useOld = forceOld && !forceNew;
    private Tool delegate;
    private static final DeployerTextFormatter messageFormatter = new DeployerTextFormatter();
    public static final long MAX_NOTIFICATION_WAIT = 1000L;

    public Deployer(String[] stringArray) throws Exception {
        this.delegate = this.getDelegate(stringArray);
        this.delegate.setUsageName(this.getClass().getName());
    }

    private Tool getDelegate(String[] stringArray) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String string = useOld ? oldDeployerClass : newDeployerClass;
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getDeclaredConstructor(stringArray.getClass());
        return (Tool)constructor.newInstance(new Object[]{stringArray});
    }

    public static void main(String[] stringArray) {
        try {
            new Deployer(stringArray).run();
        }
        catch (Exception exception) {
            if (exception.getMessage() == null) {
                exception.printStackTrace();
            }
            System.err.println(messageFormatter.errorInitDeployer(exception.toString()));
        }
    }

    public static void mainWithExceptions(String[] stringArray) throws Exception {
        new Deployer(stringArray).run();
    }

    public void run() throws Exception {
        if (this.delegate == null) {
            throw new AssertionError((Object)"Deployer not initialized");
        }
        try {
            this.delegate.run();
        }
        catch (weblogic.deploy.api.tools.deployer.DeployerException deployerException) {
            throw new DeployerException(deployerException);
        }
    }

    public void run(String[] stringArray) throws Exception {
        if (this.delegate == null) {
            throw new AssertionError((Object)"Deployer not initialized");
        }
        try {
            this.delegate.run(stringArray);
        }
        catch (weblogic.deploy.api.tools.deployer.DeployerException deployerException) {
            throw new DeployerException(deployerException);
        }
    }

    public void prepare() {
        if (this.delegate != null) {
            try {
                this.delegate.prepare();
            }
            catch (Exception exception) {
                System.err.println(messageFormatter.errorInitDeployer(exception.toString()));
            }
        }
    }

    public void runBody() {
        if (this.delegate != null) {
            try {
                this.delegate.runBody();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        }
    }

    public static class DeployerException
    extends Exception {
        private static final long serialVersionUID = -182829700656700682L;

        DeployerException(String string) {
            super(string);
        }

        DeployerException(Exception exception) {
            super(exception);
        }
    }
}

