/*
 * Decompiled with CFR 0.152.
 */
package weblogic;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.LibDirClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;

public final class Invoker {
    public static final String WEBLOGIC_INSTRUMENTATION_PROPERTY = "weblogic.diagnostics.instrumentation";
    public static final String DIAGNOSTIC_PRE_PROCESSOR_CLASS = "weblogic.diagnostics.instrumentation.DiagnosticClassPreProcessor";
    public static final String WEBLOGIC_INSTRUMENTATION_SERVER_SCOPE = "_WL_INTERNAL_SERVER_SCOPE";
    public static final String ASPECT_PRE_PROCESSOR_CLASS = "weblogic.aspects.AspectClassPreProcessor";
    public static final String CLASSLOADER_PREPROCESSOR = "weblogic.classloader.preprocessor";
    private static final boolean SUPPORTS_DOMAIN_LIB;
    private static final ClassLoader INVOKER_CLASSLOADER;
    private static final List helpArgs;
    private static final Map tools;

    public static final ClassLoader getInvokerClassLoader() {
        return INVOKER_CLASSLOADER;
    }

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length == 0 || helpArgs.contains(stringArray[0])) {
            Invoker.printUsage();
            return;
        }
        String string = stringArray[0];
        String string2 = (String)tools.get(string);
        if (string2 == null) {
            string2 = string;
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        ClassLoader classLoader = INVOKER_CLASSLOADER;
        Class<?> clazz = classLoader.loadClass(string2);
        Method method = clazz.getMethod("main", String[].class);
        try {
            method.invoke(clazz, new Object[]{stringArray2});
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    private static ClassLoader intializeBootstrapClassloader() {
        Object object;
        String string = System.getProperty("weblogic.aspects");
        String string2 = System.getProperty(WEBLOGIC_INSTRUMENTATION_PROPERTY);
        if ("all".equals(string) || "apps".equals(string)) {
            object = System.getProperty(CLASSLOADER_PREPROCESSOR);
            object = object != null ? (String)object + ",weblogic.aspects.AspectClassPreProcessor" : ASPECT_PRE_PROCESSOR_CLASS;
            System.setProperty(CLASSLOADER_PREPROCESSOR, (String)object);
        }
        if ("all".equals(string2) || "apps".equals(string2)) {
            object = System.getProperty(CLASSLOADER_PREPROCESSOR);
            object = object != null ? (String)object + ",weblogic.diagnostics.instrumentation.DiagnosticClassPreProcessor" : DIAGNOSTIC_PRE_PROCESSOR_CLASS;
            System.setProperty(CLASSLOADER_PREPROCESSOR, (String)object);
        }
        object = Invoker.class.getClassLoader();
        if ("all".equals(string) || "all".equals(string2) || SUPPORTS_DOMAIN_LIB) {
            GenericClassLoader genericClassLoader = GenericClassLoader.getRootClassLoader((ClassFinder)Invoker.getClassFinder());
            if ("all".equals(string2)) {
                genericClassLoader.setAnnotation(new Annotation(WEBLOGIC_INSTRUMENTATION_SERVER_SCOPE));
            }
            object = genericClassLoader;
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)object);
        return object;
    }

    private static ClassFinder getClassFinder() {
        ClasspathClassFinder2 classpathClassFinder2 = null;
        ClasspathClassFinder2 classpathClassFinder22 = new ClasspathClassFinder2(System.getProperty("java.class.path"));
        if (SUPPORTS_DOMAIN_LIB) {
            MultiClassFinder multiClassFinder = new MultiClassFinder();
            multiClassFinder.addFinder((ClassFinder)classpathClassFinder22);
            File file = new File(Invoker.getRootDirectory());
            LibDirClassFinder libDirClassFinder = new LibDirClassFinder(file, "classes", "lib");
            multiClassFinder.addFinder((ClassFinder)libDirClassFinder);
            classpathClassFinder2 = multiClassFinder;
        } else {
            classpathClassFinder2 = classpathClassFinder22;
        }
        return classpathClassFinder2;
    }

    private static void printUsage() {
        System.out.println("Usage java [options] weblogic.Invoker <cmd> [args...]");
        System.out.println("Where <cmd> is one of: ");
        for (String string : new TreeSet(helpArgs)) {
            System.out.println("  " + string + ": shows this help message");
        }
        System.out.println();
        for (String string : new TreeSet(tools.keySet())) {
            System.out.println("  " + string + ": calls: " + tools.get(string));
        }
        System.out.println();
        System.out.println("  $classname: calls: $classname");
        System.out.println("Examples:");
        System.out.println("  java weblogic.Invoker -jspc d:/myjspfiles");
        System.out.println("  java weblogic.Invoker weblogic.jspc d:/myjspfiles");
    }

    private static String getRootDirectory() {
        String string = System.getProperty("weblogic.RootDirectory");
        if (string == null || string.trim().length() == 0) {
            string = ".";
        }
        return string;
    }

    public String toString() {
        return "WebLogic Invoker";
    }

    static {
        Object object = new String[]{"-help", "-usage", "-?"};
        helpArgs = Arrays.asList(object);
        tools = new HashMap();
        tools.put("-appc", "weblogic.appc");
        tools.put("-jspc", "weblogic.jspc");
        tools.put("-wlst", "weblogic.WLST");
        tools.put("-deployer", "weblogic.Deployer");
        tools.put("-admin", "weblogic.Admin");
        tools.put("-buildxmlgen", "weblogic.BuildXMLGen");
        tools.put("-cdeployer", "weblogic.ClientDeployer");
        tools.put("-ejbcc", "weblogic.EJBComplianceChecker");
        tools.put("-getmsg", "weblogic.GetMessage");
        tools.put("-upgrade", "weblogic.Upgrade");
        tools.put("-dtdc", "weblogic.dtdc");
        tools.put("-ejbc", "weblogic.ejbc");
        tools.put("-i18ngen", "weblogic.i18ngen");
        tools.put("-j2idl", "weblogic.j2idl");
        object = new File(Invoker.getRootDirectory());
        File file = new File((File)object, "lib");
        File file2 = new File((File)object, "classes");
        SUPPORTS_DOMAIN_LIB = file.exists() && file.isDirectory() || file2.exists() && file2.isDirectory();
        INVOKER_CLASSLOADER = Invoker.intializeBootstrapClassloader();
    }
}

