/*
 * Decompiled with CFR 0.152.
 */
package weblogic;

import weblogic.nodemanager.server.NMServer;

public final class NodeManager {
    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && (stringArray[0].equalsIgnoreCase("-help") || stringArray[0].equalsIgnoreCase("help") || stringArray[0].equalsIgnoreCase("-h") || stringArray[0].equals("?") || stringArray[0].equals("-?"))) {
            System.out.println(NodeManager.getUsage());
        } else if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("-advanced")) {
            System.out.println(NodeManager.getAdvancedUsage());
        } else {
            NMServer.main(stringArray);
        }
    }

    public static String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Usage: java [<Property>=<PropertyValue>] weblogic.NodeManager [OPTIONS]\n");
        stringBuffer.append("\t  where the following properties are specified as:\n");
        stringBuffer.append("\t  -DListenAddress \t\t[String, default 'localhost']\n");
        stringBuffer.append("\t  -DListenPort \t\t\t[int, default '5556']\n");
        stringBuffer.append("\t  -DPropertiesFile \t\t[String, default 'nodemanager.properties']\n");
        stringBuffer.append("\n");
        stringBuffer.append("\t  where options include:\n");
        stringBuffer.append("\t  -n <home>  Specify node manager home directory (default is PWD)\n");
        stringBuffer.append("\t  -f <file>  Specify node manager properties file\n");
        stringBuffer.append("\t             (default is NM_HOME/nodemanager.properties)\n");
        stringBuffer.append("\t  -v         Run in verbose mode\n");
        stringBuffer.append("\t  -d         Enable debug output to log file\n");
        stringBuffer.append("\t  -?, -h     Print this usage message\n");
        stringBuffer.append("\t  -advanced  Print advanced options\n");
        return stringBuffer.toString();
    }

    public static String getAdvancedUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Usage: java [<Property>=<PropertyValue>] weblogic.NodeManager\n");
        stringBuffer.append("\t  where the following properties are specified as:\n");
        stringBuffer.append("\t  -DListenAddress \t\t[String, default 'localhost']\n");
        stringBuffer.append("\t  -DListenPort \t\t\t[int, default '5556']\n");
        stringBuffer.append("\t  -DWeblogicHome \t\t[String]\n");
        stringBuffer.append("\t    Specifies the root directory of the WebLogic\n");
        stringBuffer.append("\t    installation. This is used as the value for\n");
        stringBuffer.append("\t    -Dweblogic.RootDirectory\n");
        stringBuffer.append("\t  -DNativeVersionEnabled \t[boolean, default 'true']\n");
        stringBuffer.append("\t    Causes native libraries for the operating system to be used.\n");
        stringBuffer.append("\t    For UNIX systems other than Solaris, HP-UX, or Linux,\n");
        stringBuffer.append("\t    set this property to false to run Node Manager in \n");
        stringBuffer.append("\t    non-native mode. This will cause Node Manager to use the \n");
        stringBuffer.append("\t    start script specified by the StartScriptEnabled \n");
        stringBuffer.append("\t    property to start Managed Servers.\n");
        stringBuffer.append("\t  -DJavaHome \t\t\t[String]\n");
        stringBuffer.append("\t    Specifies the home directory of 'java'.\n");
        stringBuffer.append("\t    The managed servers will use the java (or 'java.exe')\n");
        stringBuffer.append("\t    from javaHome/bin directory when they are started.\n");
        stringBuffer.append("\n");
        stringBuffer.append("\t  -DDomainsFile \t\t[String, default 'NM_HOME/nodemanager.domains']\n");
        stringBuffer.append("\t    The name of the nodemanager.domains file.\n");
        stringBuffer.append("\t  -DDomainsFileEnabled \t\t[boolean, default 'true']\n");
        stringBuffer.append("\t    If set to true, use the file specified in DomainsFile. If false,\n");
        stringBuffer.append("\t    assumes the domain of the current directory or WL_HOME.\n");
        stringBuffer.append("\t  -DStartScriptName \t\t[String, default 'startWeblogic.sh/.cmd']\n");
        stringBuffer.append("\t    The name of the start script, located in the domain directory.\n");
        stringBuffer.append("\t  -DStartScriptEnabled \t\t[boolean, default 'false']\n");
        stringBuffer.append("\t    If true, use the start script specified by StartScriptName\n");
        stringBuffer.append("\t    to start a server.\n");
        stringBuffer.append("\n");
        stringBuffer.append("\t  -DLogFile \t\t\t[String, default 'NM_HOME/nodemanager.log']\n");
        stringBuffer.append("\t    Location of the NodeManager log file.\n");
        stringBuffer.append("\t  -DLogLimit \t\t\t[int, default unlimited]\n");
        stringBuffer.append("\t    Maximum size of the Node Manager log. When this limit is reached,\n");
        stringBuffer.append("\t    a new log file is started.\n");
        stringBuffer.append("\t  -DLogCount \t\t\t[int, default '1']\n");
        stringBuffer.append("\t    Maximum number of log files to create when LogLimit is reached.\n");
        stringBuffer.append("\t  -DLogAppend \t\t\t[boolean, default 'true']\n");
        stringBuffer.append("\t    If true, append to existing log files instead of creating a new\n");
        stringBuffer.append("\t    one when NodeManager is started.\n");
        stringBuffer.append("\t  -DLogToStderr \t\t[boolean, default 'true']\n");
        stringBuffer.append("\t    If true, log output is also sent to stderr. Setting this to false\n");
        stringBuffer.append("\t    will override the -v flag.\n");
        stringBuffer.append("\t  -DLogLevel \t\t\t[String, default 'WLLevel.INFO']\n");
        stringBuffer.append("\t    Severity level of logging used by NodeManager. Options: Trace\n");
        stringBuffer.append("\t    Debug, Info, Warning, Error, Notice, Critical, Alert, Emergency.\n");
        stringBuffer.append("\t  -DLogFormatter \t\t[String, default 'weblogic.nodemanager.server.LogFormatter']\n");
        stringBuffer.append("\t    Name of formatter class to use for NM log messages.\n");
        stringBuffer.append("\n");
        stringBuffer.append("\t  -DCrashRecoveryEnabled \t[boolean, default 'true']\n");
        stringBuffer.append("\t    Enables System Crash Recovery. If true, nodemanager will restart\n");
        stringBuffer.append("\t    crashed servers when it starts.\n");
        stringBuffer.append("\n");
        stringBuffer.append("\t  -DSecureListener \t\t[boolean, default 'true']\n");
        stringBuffer.append("\t    If true, use the secure listener. Otherwise use a plain socket.\n");
        stringBuffer.append("\t  -DCipherSuite \t\t[String, default 'TLS_RSA_EXPORT_WITH_RC4_40_MD5']\n");
        stringBuffer.append("\t    Name of the cipher suite to use with the secure listener.\n");
        stringBuffer.append("\n");
        stringBuffer.append("\t  -DKeyStores \t\t\t[String, default 'DemoIdentityAndDemoTrust']\n");
        stringBuffer.append("\t    Indicates the keystore configuration the nodemanager uses\n");
        stringBuffer.append("\t    to find its identity and trust.\n");
        stringBuffer.append("\t  -DJavaStandardTrustKeyStorePassPhrase \t[String, default none]\n");
        stringBuffer.append("\t    Specifies the password defined when creating the Trust keystore.\n");
        stringBuffer.append("\t    Weblogic only reads from the keystore, so whether or not you set.\n");
        stringBuffer.append("\t    This property depends on the requirements of the keystore.\n");
        stringBuffer.append("\t    This property is required when the KeyStores property is set as\n");
        stringBuffer.append("\t    CustomIdentityAndJavaStandardTrust or DemoIdentityAndDemoTrust.\n");
        stringBuffer.append("\t  -DCustomIdentityKeyStorePassPhrase \t\t[String, default none]\n");
        stringBuffer.append("\t    Specifies the password defined when creating the Identity keystore.\n");
        stringBuffer.append("\t    Weblogic only reads from the keystore, so whether or not you set.\n");
        stringBuffer.append("\t    This property depends on the requirements of the keystore.\n");
        stringBuffer.append("\t  -DCustomIdentityKeyStoreFileName \t\t[String, default none]\n");
        stringBuffer.append("\t    Specifies the name of the Identity keystore.\n");
        stringBuffer.append("\t    This property is required when the KeyStores property is set as\n");
        stringBuffer.append("\t    CustomIdentityAndCustomTrust or CustomIdentityAndJavaStandardTrust.\n");
        stringBuffer.append("\t  -DCustomIdentityAlias \t\t\t[String, default none]\n");
        stringBuffer.append("\t    Specifies the alias when loading the private key into\n");
        stringBuffer.append("\t    the keystore. This property is required when the KeyStores\n");
        stringBuffer.append("\t    property is set as CustomIdentityAndCustomTrust or\n");
        stringBuffer.append("\t    CustomIdentityAndJavaStandardTrust.\n");
        stringBuffer.append("\t  -DCustomIdentityPrivateKeyPassPhrase \t\t[String, default none]\n");
        stringBuffer.append("\t    Specifies the password used to retrieve the private key for\n");
        stringBuffer.append("\t    WebLogic Server from the Identity keystore. This property is\n");
        stringBuffer.append("\t    required when the KeyStores property is set as\n");
        stringBuffer.append("\t    CustomIdentityAndCustomTrust or CustomIdentityAndJavaStandardTrust.\n");
        stringBuffer.append("\t  -DCustomIdentityKeyStoreType \t\t\t[String, default keystore type from java.security ]\n");
        stringBuffer.append("\t    Specifies the type of the Identity Keystore. Generally,\n");
        stringBuffer.append("\t    this is JKS. This property is optional.\n");
        stringBuffer.append("\n");
        stringBuffer.append("\t  Additional properties that are used as defaults\n");
        stringBuffer.append("\t  when starting up Managed servers can be\n");
        stringBuffer.append("\t  specified. These are: \n");
        stringBuffer.append("\t  -Dbea.home \t\t\t[String]\n");
        stringBuffer.append("\t    Specifies the BEA_Home\n");
        stringBuffer.append("\t  -DWeblogicHome \t\t[String]\n");
        stringBuffer.append("\t    Specifies the root directory of the WebLogic\n");
        stringBuffer.append("\t    installation. This is used as the value for\n");
        stringBuffer.append("\t    -Dweblogic.RootDirectory\n");
        stringBuffer.append("\t  -Djava.security.policy \t[String]\n");
        stringBuffer.append("\t    Specifies the security policy to be used.\n");
        stringBuffer.append("\t    Note that in addition to being used as the\n");
        stringBuffer.append("\t    default security policy by the Managed servers\n");
        stringBuffer.append("\t    started by this NodeManager, this file also\n");
        stringBuffer.append("\t    specifies the policy file for this NodeManager.\n");
        stringBuffer.append("\n\n");
        stringBuffer.append("\t  You can specify all these properties in a properties file using\n");
        stringBuffer.append("\t  the following property.\n");
        stringBuffer.append("\t  -DPropertiesFile \t\t\t[String, default 'nodemanager.properties']\n");
        stringBuffer.append("\t  For more information see:\n");
        stringBuffer.append("\t  http://e-docs.bea.com/wls/docs103/nodemgr/intro.html");
        return stringBuffer.toString();
    }
}

