/*
 * Decompiled with CFR 0.152.
 */
package weblogic;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import weblogic.Home;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.DomainDir;
import weblogic.security.utils.SecurityUtils;
import weblogic.t3.srvr.ShutdownOnExitThread;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.ArrayUtils;
import weblogic.utils.Classpath;
import weblogic.utils.FileUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.io.ExtensionFilter;

public final class Server {
    private static final String WEBLOGIC_EXTENSION_DIRS = "weblogic.ext.dirs";
    private static final String PATH_SEPARATOR_STRING = File.pathSeparator;
    public static final String WEBLOGIC_INSTRUMENTATION_PROPERTY = "weblogic.diagnostics.instrumentation";
    public static final String DIAGNOSTIC_PRE_PROCESSOR_CLASS = "weblogic.diagnostics.instrumentation.DiagnosticClassPreProcessor";
    public static final String WEBLOGIC_INSTRUMENTATION_SERVER_SCOPE = "_WL_INTERNAL_SERVER_SCOPE";
    public static final String CLASSLOADER_PREPROCESSOR = "weblogic.classloader.preprocessor";

    public static void main(String[] stringArray) {
        int n;
        block5: {
            if (stringArray.length > 0 && (stringArray[0].equals("-help") || stringArray[0].equals("-?"))) {
                System.out.println(Server.getUsage());
                return;
            }
            n = 0;
            try {
                SecurityUtils.turnOffCryptoJDefaultJCEVerification();
                SecurityUtils.changeCryptoJDefaultPRNG();
                Server.intializeClassloader();
                n = T3Srvr.run(stringArray);
                ShutdownOnExitThread.exitViaServerLifeCycle = true;
            }
            catch (Exception exception) {
                if (!(exception instanceof AccessControlException)) break block5;
                System.err.println("***************************************************************************");
                System.err.println("The WebLogic Server encountered a critical failure");
                System.err.println("Exception raised: '" + exception + "'");
                System.err.println("Check you have both java.security.manager and java.security.policy defined and java.security.policy has the correct entries");
                System.err.println("***************************************************************************");
            }
        }
        try {
            System.exit(n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static URL[] getURLs(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        URL[] uRLArray = new URL[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                uRLArray[i] = fileArray[i].toURL();
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return uRLArray;
    }

    private static File[] getJars(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                return new File[]{file};
            }
            if (file.isDirectory()) {
                return FileUtils.find((File)file, (FileFilter)new ExtensionFilter("jar"));
            }
        }
        return null;
    }

    private static void appendToClassPath(File[] fileArray) {
        if (fileArray == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            Classpath.append((File)fileArray[i]);
            try {
                if (i != 0) {
                    stringBuffer.append(PATH_SEPARATOR_STRING);
                }
                stringBuffer.append(fileArray[i].getCanonicalPath());
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        T3SrvrLogger.logDomainLibPath((String)stringBuffer.toString());
    }

    private static void intializeClassloader() {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        File[] fileArray = Server.getExtensionJars();
        if (fileArray != null && fileArray.length > 0) {
            classLoader = new URLClassLoader(Server.getURLs(fileArray), classLoader);
            Server.appendToClassPath(fileArray);
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        if (!Server.isRedefineClassesSupported()) {
            String string = System.getProperty(CLASSLOADER_PREPROCESSOR);
            string = string != null ? "weblogic.diagnostics.instrumentation.DiagnosticClassPreProcessor," + string : DIAGNOSTIC_PRE_PROCESSOR_CLASS;
            System.setProperty(CLASSLOADER_PREPROCESSOR, string);
        }
    }

    public static boolean isRedefineClassesSupported() {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("weblogic.diagnostics.instrumentation.agent.WLDFInstrumentationAgent");
            Class[] classArray = new Class[]{};
            Method method = clazz.getMethod("isRedefineClassesSupported", classArray);
            Object[] objectArray = new Object[]{};
            Boolean bl2 = (Boolean)method.invoke(null, objectArray);
            bl = bl2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private static File[] getExtensionJars() {
        File[] fileArray = Server.getLibraryExtensions();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < fileArray.length; ++i) {
            Object[] objectArray = Server.getJars(fileArray[i]);
            if (objectArray == null || objectArray.length == 0) continue;
            Arrays.sort(objectArray);
            ArrayUtils.addAll(arrayList, (Object[])objectArray);
        }
        File[] fileArray2 = new File[arrayList.size()];
        arrayList.toArray(fileArray2);
        return fileArray2;
    }

    private static final File[] getLibraryExtensions() {
        Object object;
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = System.getProperty(WEBLOGIC_EXTENSION_DIRS);
        boolean bl = false;
        if (string != null) {
            if (string.startsWith("=")) {
                bl = true;
                string = string.substring(1);
            }
            object = StringUtils.splitCompletely((String)string, (String)PATH_SEPARATOR_STRING);
            for (int i = 0; i < ((String[])object).length; ++i) {
                arrayList.add(new File(object[i]));
            }
        }
        if (!bl) {
            arrayList.add(new File(new File(DomainDir.getRootDir()), "lib"));
            object = new File(Home.getPath());
            if (((File)object).getParentFile() != null) {
                arrayList.add(new File(((File)object).getParentFile(), "common" + File.separator + "lib" + File.separator + "ext"));
            }
            arrayList.add(new File((File)object, "lib" + File.separator + "ext"));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public String toString() {
        return "WebLogic Server";
    }

    public static String getUsage() {
        return "Usage: java [options] weblogic.Server [args...]\n\nWhere WebLogic options include:\n\t-Djava.security.policy=<value>\t the location of the security policy\n\t\t\t\t\t file\n\t-Dweblogic.Domain=<value>\t WebLogic domain name\n\t-Dweblogic.Name=<value>\t\t WebLogic server name\n\t-Dweblogic.ext.dirs=<value>\n\t\t\t\t\t '" + PATH_SEPARATOR_STRING + "' separated list of directories to pick up jars from " + "\n\t\t\t\t\t and add to the end of the server classpath." + "\n\t\t\t\t\t The list can also contain individual jars." + "\n\t-Dweblogic.management.server=<value>" + "\n\t\t\t\t\t WebLogic Admin Server URL for starting" + "\n\t\t\t\t\t a Managed Server, the value can be:" + "\n\t\t\t\t\t host:port or " + "\n\t\t\t\t\t http://host:port or" + "\n\t\t\t\t\t https://host:port" + "\n\t-Dweblogic.home=<value>" + "\n\t\t\t\t\t The location of the WebLogic Server" + "\n\t\t\t\t\t product install.  By default, this will" + "\n\t\t\t\t\t be derived from the classpath." + "\n\t-Dweblogic.RootDirectory=<value>" + "\n\t\t\t\t\t The root directory of your domain," + "\n\t\t\t\t\t where your configuration is housed." + "\n\t\t\t\t\t default is the current working" + "\n\t\t\t\t\t directory" + "\n\t-Dweblogic.management.username=<value>" + "\n\t\t\t\t\t user name" + "\n\t-Dweblogic.management.password=<value>" + "\n\t\t\t\t\t user password" + "\n\t-Dweblogic.management.pkpassword=<value>" + "\n\t\t\t\t\t private key password" + "\n\t-Dweblogic.security.unixrealm.authProgram=<value>" + "\n\t\t\t\t\t the name of the program used to" + "\n\t\t\t\t\t authenticate users in the unix" + "\n\t\t\t\t\t security realm" + "\n\t-Dweblogic.<ServerAttributeName>=<value>" + "\n\t\t\t\t\t specify a server attribute, it will" + "\n\t\t\t\t\t override the attribute value set in" + "\n\t\t\t\t\t config.xml for this server" + "\n\t-Dweblogic.admin.host=<value>" + "\t same as weblogic.management.server, an" + "\n\t\t\t\t\t old property " + "\n\t-javaagent:$WL_HOME/server/lib/diagnostics-agent.jar" + "\n\t\t\t\t\t enable diagnostics hot code-swap for application classes" + "\nAnd WebLogic args include:" + "\n\t-? -help" + "\t\t\t print this help message" + "\n";
    }
}

