/*
 * Decompiled with CFR 0.152.
 */
package weblogic;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import weblogic.Home;
import weblogic.descriptor.DescriptorClassLoader;
import weblogic.management.utils.PDevHelper;
import weblogic.utils.Executable;

public class Upgrade {
    public static void main(String[] stringArray) {
        Object object;
        if (!Upgrade.PDevLibraryInClasspath()) {
            Upgrade.SetPDevLibraryAndForkUpgrade(stringArray);
            return;
        }
        String string = System.getProperty("prod.props.file");
        if (string == null) {
            object = new File(Home.getFile(), ".." + File.separator + ".product.properties");
            try {
                if (((File)object).exists()) {
                    System.setProperty("prod.props.file", ((File)object).getCanonicalPath());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = DescriptorClassLoader.getClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)object);
        try {
            Class<?> clazz = Class.forName("weblogic.upgrade.Main", true, (ClassLoader)object);
            Method method = clazz.getMethod("main", String[].class);
            method.invoke(clazz, new Object[]{stringArray});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    private static boolean PDevLibraryInClasspath() {
        if (System.getProperty("weblogic.upgrade.forked") != null) {
            return true;
        }
        try {
            Class.forName("com.bea.plateng.plugin.PlugInDefinition", true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void SetPDevLibraryAndForkUpgrade(String[] stringArray) {
        String[] stringArray2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(System.getProperty("java.home") + "/bin/java");
        Object object = System.getProperties().propertyNames();
        while (object.hasMoreElements()) {
            stringArray2 = (String[])object.nextElement();
            if (!stringArray2.startsWith("weblogic") && !stringArray2.startsWith("com")) continue;
            arrayList.add("-D" + (String)stringArray2 + "=" + System.getProperty((String)stringArray2));
        }
        arrayList.add("-Dweblogic.upgrade.forked");
        object = System.getProperty("java.class.path");
        object = PDevHelper.addPDevLibraryToClasspath((String)object);
        object = ((String)object).replaceAll("\\\\\\\\", "/");
        object = ((String)object).replaceAll("\\\\", "/");
        object = ((String)object).replace('\\', '/');
        arrayList.add("-classpath");
        arrayList.add(object);
        arrayList.add("weblogic.Upgrade");
        for (String string : stringArray) {
            arrayList.add(string);
        }
        stringArray2 = arrayList.toArray(new String[0]);
        Executable executable = new Executable((OutputStream)System.out, (OutputStream)System.err);
        executable.exec(stringArray2);
        try {
            int n = executable.getExitValue();
            System.exit(n);
        }
        catch (Throwable throwable) {
            System.err.println("Exception caught from Main.doMain(...): " + throwable);
            throwable.printStackTrace(System.err);
            System.exit(-1);
        }
    }
}

