/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.antline;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;
import weblogic.ant.taskdefs.antline.AntOpt;
import weblogic.ant.taskdefs.antline.AntTool;
import weblogic.utils.Executable;
import weblogic.utils.StringUtils;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class AntLauncher {
    private static String XML_TASK_NAME = "antline_task";
    private static String XML_PROJECT_NAME = "antline_project";
    private static String XML_TARGET_NAME = "antline_target";
    private static final int ERR_BUFFER_SIZE = 2048;
    private Collection antOpts;
    private Class task;
    private String command;
    private boolean externalProcess = false;

    public AntLauncher(Class clazz, Collection collection) {
        this.antOpts = collection;
        this.task = clazz;
        if (AntTool.debug) {
            System.out.println("task = " + clazz.getName());
        }
    }

    public void launch() throws BuildException, IOException {
        File file = this.generateBuildXml();
        if (this.externalProcess) {
            AntLauncher.launchExternal(file);
        } else {
            AntLauncher.launchInternal(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchInternal(File file) throws BuildException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        arrayList.add("-f");
        arrayList.add(file.getCanonicalPath());
        arrayList.add("-logger");
        arrayList.add("weblogic.ant.taskdefs.antline.ToolLogger");
        if (AntTool.debug) {
            arrayList.add("-verbose");
        } else {
            arrayList.add("-quiet");
        }
        try {
            Main.start((String[])arrayList.toArray(new String[0]), null, null);
        }
        finally {
            if (!AntTool.debug) {
                file.delete();
            }
        }
    }

    private static void launchExternal(File file) throws BuildException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        arrayList.add("java");
        arrayList.add("org.apache.tools.ant.Main");
        arrayList.add("-f");
        arrayList.add(file.getCanonicalPath());
        arrayList.add("-logger");
        arrayList.add("weblogic.ant.taskdefs.antline.ToolLogger");
        if (AntTool.debug) {
            arrayList.add("-verbose");
        } else {
            arrayList.add("-quiet");
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter(2048);
        CharArrayWriter charArrayWriter2 = new CharArrayWriter(2048);
        Executable executable = new Executable();
        executable.setUseCharWriter(charArrayWriter2, charArrayWriter);
        boolean bl2 = executable.exec(arrayList.toArray(new String[0]));
        if (!AntTool.debug) {
            file.delete();
        }
        if (AntTool.debug) {
            System.out.println(charArrayWriter2.toString());
        }
        if (!bl2) {
            throw new BuildException("Command failed. Error output was:\n" + charArrayWriter.toString());
        }
    }

    private File generateBuildXml() throws IOException {
        String string = System.getProperty("java.io.tmpdir");
        if (string == null) {
            string = ".";
        }
        File file = new File(string);
        file.mkdirs();
        File file2 = File.createTempFile("antline", ".xml", file);
        if (AntTool.debug) {
            System.out.println("tmpfile = " + file2);
        } else {
            file2.deleteOnExit();
        }
        XMLOutputStreamFactory xMLOutputStreamFactory = XMLOutputStreamFactory.newInstance();
        XMLOutputStream xMLOutputStream = xMLOutputStreamFactory.newOutputStream((OutputStream)new FileOutputStream(file2));
        xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"project"));
        xMLOutputStream.add(ElementFactory.createAttribute((String)"name", (String)XML_PROJECT_NAME));
        xMLOutputStream.add(ElementFactory.createAttribute((String)"default", (String)XML_TARGET_NAME));
        xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"taskdef"));
        xMLOutputStream.add(ElementFactory.createAttribute((String)"name", (String)XML_TASK_NAME));
        xMLOutputStream.add(ElementFactory.createAttribute((String)"classname", (String)this.task.getName()));
        xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"taskdef"));
        xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)"target"));
        xMLOutputStream.add(ElementFactory.createAttribute((String)"name", (String)XML_TARGET_NAME));
        ParamNode paramNode = this.buildParamTree(this.antOpts);
        xMLOutputStream = this.emitXML(paramNode, xMLOutputStream);
        xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"target"));
        xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)"project"));
        xMLOutputStream.flush();
        return file2;
    }

    private XMLOutputStream emitXML(ParamNode paramNode, XMLOutputStream xMLOutputStream) throws XMLStreamException {
        Object object2;
        String string = paramNode.getName();
        xMLOutputStream.add((XMLEvent)ElementFactory.createStartElement((String)string));
        Collection collection = paramNode.getAttributeChildren();
        for (Object object2 : collection) {
            AntOpt antOpt = ((ParamNode)object2).getParam();
            if (antOpt.getValue() == null) continue;
            xMLOutputStream.add(ElementFactory.createAttribute((String)antOpt.getAntAttrName(), (String)antOpt.getValue()));
        }
        Collection collection2 = paramNode.getElementChildren();
        object2 = collection2.iterator();
        while (object2.hasNext()) {
            this.emitXML((ParamNode)object2.next(), xMLOutputStream);
        }
        xMLOutputStream.add((XMLEvent)ElementFactory.createEndElement((String)string));
        return xMLOutputStream;
    }

    private ParamNode buildParamTree(Collection collection) {
        ParamNode paramNode = new ParamNode(XML_TASK_NAME);
        for (AntOpt antOpt : collection) {
            if (antOpt.getValue() == null) continue;
            this.addNode(paramNode, antOpt);
        }
        return paramNode;
    }

    private void addNode(ParamNode paramNode, AntOpt antOpt) {
        ParamNode paramNode2;
        String[] stringArray = StringUtils.splitCompletely((String)antOpt.getAntElementPath(), (String)"/");
        ParamNode paramNode3 = paramNode;
        for (int i = 0; i < stringArray.length; ++i) {
            paramNode2 = paramNode3.getChildByName(stringArray[i]);
            if (paramNode2 == null) {
                paramNode2 = new ParamNode(stringArray[i]);
                paramNode3.addChild(paramNode2);
            }
            paramNode3 = paramNode2;
        }
        String string = "@" + antOpt.getAntAttrName();
        if (string != null) {
            paramNode2 = paramNode3.getChildByName(string);
            if (paramNode2 == null) {
                paramNode2 = new ParamNode(string);
                paramNode3.addChild(paramNode2);
            }
            paramNode3 = paramNode2;
        }
        paramNode3.setParam(antOpt);
    }

    public void setExternalProcess(boolean bl) {
        this.externalProcess = bl;
    }

    public boolean getExternalProcess() {
        return this.externalProcess;
    }

    private static class ParamNode {
        private String name;
        private AntOpt value;
        private List children = new ArrayList();

        public ParamNode(String string) {
            this.name = string;
            if (AntTool.debug) {
                System.out.println("ParamNode[" + System.identityHashCode(this) + "] = " + this.name);
            }
        }

        public String getName() {
            return this.name;
        }

        public AntOpt getParam() {
            return this.value;
        }

        public void setParam(AntOpt antOpt) {
            this.value = antOpt;
        }

        public void addChild(ParamNode paramNode) {
            if (AntTool.debug) {
                System.out.println("ParamNode[" + System.identityHashCode(this) + "].addChild(" + System.identityHashCode(paramNode));
            }
            this.children.add(paramNode);
        }

        public ParamNode getChildByName(String string) {
            for (ParamNode paramNode : this.children) {
                if (!paramNode.getName().equals(string)) continue;
                return paramNode;
            }
            return null;
        }

        public Collection getAttributeChildren() {
            ArrayList<ParamNode> arrayList = new ArrayList<ParamNode>();
            for (ParamNode paramNode : this.children) {
                if (!paramNode.getName().startsWith("@")) continue;
                arrayList.add(paramNode);
            }
            return arrayList;
        }

        public Collection getElementChildren() {
            ArrayList<ParamNode> arrayList = new ArrayList<ParamNode>();
            for (ParamNode paramNode : this.children) {
                if (paramNode.getName().startsWith("@")) continue;
                arrayList.add(paramNode);
            }
            return arrayList;
        }
    }
}

