/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.antline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import weblogic.ant.taskdefs.antline.Option;
import weblogic.webservice.util.script.GenBase;

public class AntLineTask
extends Task {
    static boolean debug = System.getProperty(AntLineTask.DEBUG_PROPERTY()) != null;
    private String packageName;
    private String commandName;
    private String taskName;
    private File destDir = new File(".");
    private boolean keepGenerated = true;
    private List options = new ArrayList();

    static String DEBUG_PROPERTY() {
        return "antline.debug";
    }

    public void setPackagename(String string) {
        this.packageName = string;
    }

    public void setCommandname(String string) {
        this.commandName = string;
    }

    public void setTaskName(String string) {
        this.taskName = string;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setKeepgenerated(boolean bl) {
        this.keepGenerated = bl;
    }

    public Option createOption() {
        Option option = new Option();
        this.options.add(option);
        return option;
    }

    public void execute() {
        this.validateAttributes();
        this.log("Generating command line tool " + this.packageName + "." + this.commandName + " ...");
        String string = "/" + this.getMyPackage().replace('.', '/');
        File file = null;
        PrintStream printStream = null;
        try {
            GenBase genBase = new GenBase(string + "/tool.cg", false);
            genBase.setVar("packageName", (Object)this.packageName);
            genBase.setVar("cmdName", (Object)this.commandName);
            genBase.setVar("taskName", (Object)this.taskName);
            genBase.setVar("options", (Object)this.options);
            StringBuffer stringBuffer = new StringBuffer();
            for (Option option : this.options) {
                String string2 = "\"" + option.getOptname() + "\"";
                String string3 = "\"" + option.getAntname() + "\"";
                String string4 = AntLineTask.quotedValOrNullText(option.getArg());
                String string5 = AntLineTask.quotedValOrNullText(option.getDescription());
                String string6 = AntLineTask.quotedValOrNullText(option.getConverter());
                stringBuffer.append("    tool.addOption(");
                stringBuffer.append(string2);
                stringBuffer.append(", ");
                stringBuffer.append(string3);
                stringBuffer.append(", ");
                stringBuffer.append(string4);
                stringBuffer.append(", ");
                stringBuffer.append(string5);
                stringBuffer.append(", ");
                stringBuffer.append(string6);
                stringBuffer.append(");\n");
            }
            genBase.setVar("addOptions", (Object)stringBuffer.toString());
            file = new File(this.destDir, this.packageName.replace('.', '/') + "/" + this.commandName + ".java");
            file.getParentFile().mkdirs();
            if (debug) {
                System.out.println("Outputting Java file " + file);
            }
            printStream = new PrintStream(new FileOutputStream(file));
            genBase.setOutput(printStream);
            genBase.gen();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
        finally {
            try {
                if (printStream != null) {
                    printStream.close();
                }
            }
            catch (Exception exception) {
                throw new BuildException((Throwable)exception);
            }
        }
        this.log("Compiling " + file + " ...");
        this.javacFile(file, this.destDir);
        if (!this.keepGenerated) {
            System.out.println("Deleting file " + file);
            try {
                file.delete();
            }
            catch (Exception exception) {
                throw new BuildException((Throwable)exception);
            }
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.packageName == null) {
            throw new BuildException("the packageName attribute must be set");
        }
        if (this.commandName == null) {
            throw new BuildException("the commandName attribute must be set");
        }
        if (this.taskName == null) {
            throw new BuildException("the taskName attribute must be set");
        }
        for (Option option : this.options) {
            option.validateAttributes();
        }
    }

    private void javacFile(File file, File file2) throws BuildException {
        Javac javac = new Javac();
        javac.setProject(this.getProject());
        javac.setTaskName(this.getTaskName());
        try {
            javac.setSrcdir(new Path(this.getProject(), file.getParentFile().getCanonicalPath()));
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        javac.setIncludes(file.getName());
        javac.setDestdir(file2);
        javac.execute();
    }

    private String getMyPackage() {
        String string = ((Object)((Object)this)).getClass().getName();
        return string.substring(0, string.lastIndexOf(46));
    }

    private static String quotedValOrNullText(String string) {
        if (string == null) {
            return "null";
        }
        return "\"" + AntLineTask.cleanupText(string) + "\"";
    }

    private static String cleanupText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        string = string.trim();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (!bl) {
                    stringBuffer.append(' ');
                }
                bl = true;
                continue;
            }
            if (c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            bl = false;
        }
        return stringBuffer.toString();
    }
}

