/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.antline;

import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import weblogic.ant.taskdefs.antline.AntTool;

public class ToolLogger
implements BuildLogger {
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private int msgOutputLevel = 2;

    public void buildStarted(BuildEvent buildEvent) {
        if (AntTool.debug) {
            System.out.println("build-start: " + buildEvent);
        }
    }

    public void buildFinished(BuildEvent buildEvent) {
        Throwable throwable;
        if (AntTool.debug) {
            System.out.println("build-finished: " + buildEvent);
        }
        if ((throwable = buildEvent.getException()) != null) {
            if (this.msgOutputLevel >= 3 || !(throwable instanceof BuildException)) {
                throwable.printStackTrace(this.err);
            } else if (throwable instanceof BuildException) {
                this.err.println(throwable.toString());
            } else {
                this.err.println(throwable.getMessage());
            }
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
        if (AntTool.debug) {
            System.out.println("target-started: " + buildEvent);
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
        if (AntTool.debug) {
            System.out.println("target-finished: " + buildEvent);
        }
    }

    public void taskStarted(BuildEvent buildEvent) {
        if (AntTool.debug) {
            System.out.println("task-started: " + buildEvent);
        }
    }

    public void taskFinished(BuildEvent buildEvent) {
        if (AntTool.debug) {
            System.out.println("task-finished: " + buildEvent);
        }
    }

    public void messageLogged(BuildEvent buildEvent) {
        PrintStream printStream;
        PrintStream printStream2 = printStream = buildEvent.getPriority() == 0 ? this.err : this.out;
        if (buildEvent.getPriority() <= this.msgOutputLevel && buildEvent.getTask() != null) {
            printStream.println(buildEvent.getMessage());
        }
    }

    public void setMessageOutputLevel(int n) {
        if (AntTool.debug) {
            System.out.println("set-message-output-level: " + n);
        }
        if (n >= 2) {
            this.msgOutputLevel = n;
        }
    }

    public void setOutputPrintStream(PrintStream printStream) {
        if (AntTool.debug) {
            System.out.println("set-output-print-stream: " + printStream.getClass().getName());
        }
        this.out = printStream;
    }

    public void setErrorPrintStream(PrintStream printStream) {
        if (AntTool.debug) {
            System.out.println("set-error-print-stream: " + printStream.getClass().getName());
        }
        this.err = printStream;
    }

    public void setEmacsMode(boolean bl) {
        if (AntTool.debug) {
            System.out.println("set-emacs-mode: " + bl);
        }
    }
}

