/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class AnnotationManifestTask
extends Task {
    private Path _classpath;
    private Path _searchPath;
    private String _moduleDir;
    private String _moduleName;
    private String _stagingDir = ".staging";
    private boolean _verbose = false;
    private String _version = "";
    private static final String MANIFEST_DIR = "META-INF";
    private static final String MANIFEST_FILENAME = "annotation-manifest.xml";
    private static final String MANIFESTMERGE_CLASS = "weblogic.controls.properties.ManifestMerger";
    private static final String GENERATEMANIFEST_CLASS = "weblogic.controls.properties.GenerateManifest";
    private static final String JAR_MANIFEST_TARGET_NAME = "weblogic.insert.manifest";

    public Path createClasspath() {
        if (this._classpath == null) {
            this._classpath = new Path(this.getProject());
        }
        return this._classpath.createPath();
    }

    public void setClasspath(Path path) {
        if (this._classpath == null) {
            this._classpath = path;
        } else {
            this._classpath.append(path);
        }
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public Path createSearchClasspath() {
        if (this._searchPath == null) {
            this._searchPath = new Path(this.getProject());
        }
        return this._searchPath.createPath();
    }

    public void setSearchClasspath(Path path) {
        if (this._searchPath == null) {
            this._searchPath = path;
        } else {
            this._searchPath.append(path);
        }
    }

    public void setSearchClasspathRef(Reference reference) {
        this.createSearchClasspath().setRefid(reference);
    }

    public void setModuleDir(String string) {
        this._moduleDir = string;
        if (this._moduleDir == null || this._moduleDir.length() == 0) {
            throw new BuildException("Invalid moduleDir: " + this._moduleDir);
        }
        this._moduleName = new File(this._moduleDir).getName();
    }

    public void setStagingDir(String string) {
        if (string != null && !string.equals("")) {
            this._stagingDir = string;
        }
    }

    public void setVerbose(String string) {
        Boolean bl;
        if (string != null && (bl = Boolean.valueOf(string)) != null) {
            this._verbose = bl;
        }
    }

    public void setVersion(String string) {
        if (string != null) {
            this._version = string;
        }
    }

    public void execute() throws BuildException {
        this.checkParameters();
        System.out.println("========================================================");
        System.out.println("| Start Building Annotation Manifest for " + this._moduleName);
        System.out.println("========================================================");
        long l = System.currentTimeMillis();
        GenManifestTarget genManifestTarget = new GenManifestTarget(this.getProject(), this._moduleDir, this._stagingDir, this._classpath, this._searchPath);
        genManifestTarget.setVerbose(this._verbose);
        genManifestTarget.setVersion(this._version);
        genManifestTarget.execute();
        long l2 = System.currentTimeMillis();
        System.out.println("========================================================");
        System.out.println("| Finished Building Annotation Manifest in " + (l2 - l) + " millis");
        System.out.println("========================================================");
    }

    private void checkParameters() throws BuildException {
        if (this._classpath == null || this._classpath.size() == 0) {
            throw new BuildException("Must define classpath");
        }
        if (this._searchPath == null || this._searchPath.size() == 0) {
            throw new BuildException("Must define searchClasspath");
        }
        if (this._stagingDir == null || this._stagingDir.length() == 0) {
            throw new BuildException("Must define staging directory");
        }
        if (this._moduleDir == null || this._moduleDir.length() == 0) {
            throw new BuildException("Must define module directory");
        }
        File file = new File(this._moduleDir);
        if (!file.exists()) {
            throw new BuildException("Module directory does not exist: " + file.getAbsolutePath());
        }
    }

    private static void handleGeneralBuildError(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable instanceof InvocationTargetException) {
            throwable2 = throwable.getCause();
        }
        throw new BuildException(throwable2);
    }

    private static class GenManifestTarget
    extends Target {
        private String _moduleDir;
        private String _stagingDir;
        private String[] _classpathEntries;
        private String[] _searchPathEntries;
        private boolean _verbose;
        private String _version;
        private static final String UNJAR_TASK_NAME = "unjar";
        private static final String JAR_TASK_NAME = "jar";
        private static final String TEMP_JAR_NAME = "temp.jar";

        protected GenManifestTarget(Project project, String string, String string2, Path path, Path path2) {
            this.setName(AnnotationManifestTask.JAR_MANIFEST_TARGET_NAME);
            this.setDescription("Generates Annotation Manifest for module");
            this.setProject(project);
            this._moduleDir = string;
            this._stagingDir = string2;
            assert (path != null && path2 != null);
            this._classpathEntries = path.list();
            this._searchPathEntries = path2.list();
            this._verbose = false;
        }

        public void execute() throws BuildException {
            this.deleteStagedFiles();
            ClassLoader classLoader = this.getClassLoader(this._classpathEntries, this._searchPathEntries);
            for (int i = 0; i < this._searchPathEntries.length; ++i) {
                Object object;
                File file;
                block6: {
                    file = new File(this._searchPathEntries[i]);
                    if (!file.exists()) {
                        if (!this._verbose) continue;
                        System.out.println(file.getName() + " does not exist.");
                        continue;
                    }
                    if (file.isDirectory()) {
                        object = file.getAbsolutePath() + File.separator + AnnotationManifestTask.MANIFEST_DIR + File.separator + AnnotationManifestTask.MANIFEST_FILENAME;
                        if (this._verbose) {
                            System.out.println("Generating manifest for class directory " + file.getAbsolutePath());
                        }
                        this.invokeGenerateManifest((String)object, file.getAbsolutePath(), classLoader);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    object = null;
                    try {
                        object = new ZipFile(file);
                    }
                    catch (Exception exception) {
                        System.out.println(file.getName() + " is not a valid jar file");
                        if (!this._verbose) break block6;
                        exception.printStackTrace();
                    }
                }
                if (object == null) continue;
                this.fixJar(file, classLoader);
            }
            this.invokeMergeManifest(this._searchPathEntries, this._moduleDir, classLoader);
            this.deleteStagedFiles();
        }

        public void setVerbose(boolean bl) {
            this._verbose = bl;
        }

        public void setVersion(String string) {
            this._version = string;
        }

        private void deleteStagedFiles() {
            try {
                File file = new File(this._stagingDir);
                if (file.exists()) {
                    FileSet fileSet = new FileSet();
                    Delete delete = new Delete();
                    delete.setTaskName("delete");
                    delete.setProject(this.getProject());
                    delete.setIncludeEmptyDirs(true);
                    fileSet.setDir(file);
                    fileSet.setIncludes("**/**");
                    delete.addFileset(fileSet);
                    delete.execute();
                }
            }
            catch (Exception exception) {
                System.out.println("Unable to delete files from " + this._stagingDir);
            }
        }

        private void fixJar(File file, ClassLoader classLoader) {
            if (this._verbose) {
                System.out.println("Generating manifest for " + file.getName());
            }
            String string = this._stagingDir + File.separator + file.getName();
            File file2 = new File(string);
            File file3 = new File(string + File.separator + AnnotationManifestTask.MANIFEST_DIR);
            if (!file3.exists()) {
                file3.mkdirs();
            }
            Expand expand = new Expand();
            expand.setTaskName(UNJAR_TASK_NAME);
            expand.setProject(this.getProject());
            expand.setDest(file2);
            expand.setSrc(file);
            expand.setOverwrite(true);
            expand.execute();
            String string2 = string + File.separator + AnnotationManifestTask.MANIFEST_DIR + File.separator + AnnotationManifestTask.MANIFEST_FILENAME;
            this.invokeGenerateManifest(string2, file2.getAbsolutePath(), classLoader);
            File file4 = new File(string2);
            if (!file4.exists()) {
                if (this._verbose) {
                    System.out.println(file.getName() + " does not have configurable annotations.");
                }
                return;
            }
            Jar jar = new Jar();
            jar.setTaskName(JAR_TASK_NAME);
            jar.setProject(this.getProject());
            File file5 = new File(string + File.separator + TEMP_JAR_NAME);
            if (file5.exists()) {
                file5.delete();
            }
            jar.setDestFile(file5);
            jar.setBasedir(file2);
            jar.execute();
            Copy copy = new Copy();
            copy.setTaskName(file.getName());
            copy.setProject(this.getProject());
            copy.setFile(file5);
            copy.setTofile(file);
            copy.setOverwrite(true);
            copy.execute();
            if (this._verbose) {
                System.out.println("Inserted manifest for " + file.getName());
            }
        }

        private void invokeGenerateManifest(String string, String string2, ClassLoader classLoader) throws BuildException {
            try {
                Class<?> clazz = classLoader.loadClass(AnnotationManifestTask.GENERATEMANIFEST_CLASS);
                Class[] classArray = new Class[]{String[].class};
                Method method = clazz.getDeclaredMethod("doGenerate", classArray);
                Object[] objectArray = new Object[]{new String[]{string2, string, Boolean.toString(this._verbose), this._version}};
                method.invoke(null, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new BuildException("weblogic.controls.properties.GenerateManifest is not on the classpath");
            }
            catch (Exception exception) {
                AnnotationManifestTask.handleGeneralBuildError(exception);
            }
        }

        private void invokeMergeManifest(String[] stringArray, String string, ClassLoader classLoader) throws BuildException {
            try {
                Class<?> clazz = classLoader.loadClass(AnnotationManifestTask.MANIFESTMERGE_CLASS);
                Class[] classArray = new Class[]{String.class, String[].class, Boolean.class};
                Method method = clazz.getDeclaredMethod("mergeAll", classArray);
                Object[] objectArray = new Object[]{string, stringArray, this._verbose};
                method.invoke(null, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new BuildException("weblogic.controls.properties.ManifestMerger is not on the classpath");
            }
            catch (Exception exception) {
                AnnotationManifestTask.handleGeneralBuildError(exception);
            }
        }

        private ClassLoader getClassLoader(String[] stringArray, String[] stringArray2) {
            URL uRL;
            int n;
            assert (stringArray != null && stringArray2 != null);
            URL[] uRLArray = new URL[stringArray.length + 1 + stringArray2.length];
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                uRL = this.getURL(stringArray[n]);
                if (uRL == null) continue;
                uRLArray[n2++] = uRL;
            }
            for (n = 0; n < stringArray2.length; ++n) {
                uRL = this.getURL(stringArray2[n]);
                if (uRL == null) continue;
                uRLArray[n2++] = uRL;
            }
            uRLArray[n2++] = this.getURL(this._stagingDir);
            return new URLClassLoader(uRLArray, System.class.getClassLoader());
        }

        private URL getURL(String string) {
            URL uRL;
            block2: {
                uRL = null;
                try {
                    uRL = new File(string).toURL();
                }
                catch (Exception exception) {
                    if (!this._verbose) break block2;
                    exception.printStackTrace();
                }
            }
            return uRL;
        }
    }
}

