/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build;

import java.io.File;
import java.io.FileFilter;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import weblogic.ant.taskdefs.build.BuildCtx;
import weblogic.ant.taskdefs.build.module.Module;
import weblogic.ant.taskdefs.build.module.ModuleFactory;
import weblogic.application.SplitDirectoryConstants;
import weblogic.utils.FileUtils;

public class Application
implements SplitDirectoryConstants {
    private final BuildCtx ctx;
    private final Project project;
    private final File srcDir;
    private final File destDir;
    private static final String APPINF_CLASSES = File.separatorChar + "APP-INF" + File.separatorChar + "classes";
    private static final String APPINF_LIB = File.separatorChar + "APP-INF" + File.separatorChar + "lib";

    public Application(BuildCtx buildCtx) {
        this.ctx = buildCtx;
        this.project = buildCtx.getProject();
        this.srcDir = buildCtx.getSrcDir();
        this.destDir = buildCtx.getDestDir();
    }

    public void build(Path path, Set set) throws BuildException {
        List[] listArray = ModuleFactory.createModules(this.ctx, this.srcDir.listFiles(FileUtils.DIR));
        for (int i = 0; i < listArray.length; ++i) {
            if (listArray[i] == null) continue;
            this.compileModules(listArray[i], path, set);
        }
    }

    protected void addToClasspath(Path path, File file) {
        if (file.exists()) {
            Path.PathElement pathElement = path.createPathElement();
            pathElement.setLocation(file);
        }
    }

    private void addAppInfLib(Path path, File file) {
        FileFilter fileFilter = FileUtils.makeExtensionFilter((String)".jar");
        File[] fileArray = new File(file, APPINF_LIB).listFiles(fileFilter);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.addToClasspath(path, fileArray[i]);
            }
        }
    }

    private void compileModules(List list, Path path, Set set) throws BuildException {
        this.addToClasspath(path, new File(this.srcDir, APPINF_CLASSES));
        this.addToClasspath(path, new File(this.destDir, APPINF_CLASSES));
        this.addAppInfLib(path, this.srcDir);
        this.addAppInfLib(path, this.destDir);
        for (Module module : list) {
            module.addToClasspath(path);
        }
        for (Module module : list) {
            if (!set.contains(module.getSrcdir())) continue;
            module.build(path);
        }
    }
}

