/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import weblogic.ant.taskdefs.build.Application;
import weblogic.ant.taskdefs.build.BuildCtx;
import weblogic.ant.taskdefs.build.EARApplicationFactory;

public abstract class ApplicationFactory {
    private static ApplicationFactory[] factories = new ApplicationFactory[]{new EARApplicationFactory()};

    abstract Application claim(BuildCtx var1) throws BuildException;

    private static void logVerbose(Project project, String string) {
        project.log(string, 3);
    }

    public static Application newApplication(BuildCtx buildCtx) throws BuildException {
        Application application = null;
        Project project = buildCtx.getProject();
        for (int i = 0; i < factories.length; ++i) {
            ApplicationFactory.logVerbose(project, "Trying factory: " + factories[i].getClass().getName());
            application = factories[i].claim(buildCtx);
            if (application != null) {
                ApplicationFactory.logVerbose(project, "Factory: " + factories[i].getClass().getName() + " claimed application");
                return application;
            }
            ApplicationFactory.logVerbose(project, "Factory: " + factories[i].getClass().getName() + " did not claim application.");
        }
        throw new BuildException("Unable to recognize directory: " + buildCtx.getSrcDir().getAbsolutePath() + " as a valid application.  An application should have a " + "META-INF/application.xml, META-INF/ejb-jar.xml, " + "WEB-INF/web.xml, or META-INF/ra.xml file to be recognized.");
    }
}

