/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryInitializer;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.library.LibraryReference;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryUtils;
import weblogic.servlet.utils.WebAppLibraryUtils;
import weblogic.utils.BadOptionException;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.StringUtils;
import weblogic.utils.compiler.CodeGenerationException;
import weblogic.utils.compiler.CodeGenerator;
import weblogic.utils.compiler.Tool;
import weblogic.utils.compiler.ToolFailureException;

public final class BuildXMLGen
extends Tool {
    public BuildXMLGen(String[] stringArray) {
        super(stringArray);
        this.setRequireExtraArgs(true);
    }

    public void prepare() {
        this.opts.addOption("projectName", "project name", "name of the ANT project.");
        this.opts.addOption("d", "directory", "directory where build.xml is created.  Default is the current directory.");
        this.opts.addOption("projectName", "project name", "name of the ANT project.");
        this.opts.addOption("file", "build.xml", "name of the generated build file.");
        this.opts.addOption("username", "username", "user name for deploy commands.");
        this.opts.addOption("password", "password", "password for the user.");
        this.opts.addOption("adminurl", "url", "Administatrion Server URL.");
        this.opts.addOption("librarydir", "directories", "Comma-separated list of directories in which to look for libraries.");
        this.opts.addFlag("verbose", "Enable Verbose output.");
        this.opts.setUsageArgs("<source directory>");
    }

    public boolean isVerbose() {
        return "true".equalsIgnoreCase(this.opts.getOption("verbose", "false"));
    }

    public String getUserName() {
        return this.opts.getOption("username", "USERNAME");
    }

    public String getPassword() {
        return this.opts.getOption("password", "PASSWORD");
    }

    public String getBuildFileName() {
        return this.opts.getOption("file", "build.xml");
    }

    private String[] getLibraryDirs() {
        String string = this.opts.getOption("librarydir");
        if (string == null) {
            return new String[0];
        }
        return StringUtils.splitCompletely((String)string, (String)",");
    }

    public void runBody() throws ToolFailureException {
        String[] stringArray = this.opts.args();
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            throw new ToolFailureException("Source directory: " + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new ToolFailureException("Source directory: " + file.getAbsolutePath() + " is not a directory");
        }
        try {
            if (this.opts.getOption("d") == null) {
                this.opts.setOption("d", new File(".").getAbsolutePath());
            }
        }
        catch (BadOptionException badOptionException) {
            // empty catch block
        }
        LibraryInitializer libraryInitializer = null;
        try {
            String string = this.opts.getOption("projectName", file.getCanonicalFile().getName());
            String string2 = this.opts.getOption("adminurl", "iiop://localhost:7001");
            BuildXMLGenerator buildXMLGenerator = new BuildXMLGenerator(this.opts, string, file, this.getUserName(), this.getPassword(), this.getBuildFileName(), string2);
            String string3 = buildXMLGenerator.getRootDirectoryName();
            if (string3 == null) {
                string3 = ".";
            }
            this.errorIfBuildFileExists(string3);
            libraryInitializer = this.getLibraryInitializer();
            buildXMLGenerator.setLibraryManager(this.initLibraryManager(file));
            buildXMLGenerator.generate(new Object());
            System.out.println("Generated " + string3 + File.separatorChar + this.getBuildFileName());
        }
        catch (Exception exception) {
            throw new ToolFailureException("Code Generation Error", (Throwable)exception);
        }
        finally {
            if (libraryInitializer != null) {
                libraryInitializer.cleanup();
            }
        }
    }

    private LibraryManager initLibraryManager(File file) throws ToolFailureException {
        LibraryReference[] libraryReferenceArray;
        LibraryManager libraryManager = new LibraryManager(LibraryUtils.initAppReferencer());
        LibraryReference[] libraryReferenceArray2 = this.initAppLibRefs(file);
        libraryManager.lookup(libraryReferenceArray2);
        try {
            libraryReferenceArray = WebAppLibraryUtils.initAllWebLibRefs(file);
            libraryManager.lookup(libraryReferenceArray);
        }
        catch (ToolFailureException toolFailureException) {
            if (this.isVerbose()) {
                toolFailureException.printStackTrace();
            }
            System.out.println("Problem processing weblogic.xml, ignoring any library references it may contain.");
        }
        try {
            libraryReferenceArray = LibraryUtils.initAllOptPacks(file);
            libraryManager.lookup(libraryReferenceArray);
        }
        catch (LibraryProcessingException libraryProcessingException) {
            if (this.isVerbose()) {
                libraryProcessingException.printStackTrace();
            }
            System.out.println("Problem processing META-INF/MANIFEST.MF, ignoring any optional packages it may contain.");
        }
        return libraryManager;
    }

    private void errorIfBuildFileExists(String string) throws ToolFailureException {
        File file = new File(string, this.getBuildFileName());
        if (file.exists()) {
            throw new ToolFailureException("Build File already exists, use -file to specify alternative build file name");
        }
    }

    private LibraryInitializer getLibraryInitializer() {
        LibraryInitializer libraryInitializer = new LibraryInitializer();
        if (this.isVerbose()) {
            libraryInitializer.setVerbose();
        } else {
            libraryInitializer.setSilent();
        }
        String[] stringArray = this.getLibraryDirs();
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            file = new File(stringArray[i]);
            try {
                libraryInitializer.registerLibdir(file.getPath());
                continue;
            }
            catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
                loggableLibraryProcessingException.getLoggable().log();
            }
        }
        return libraryInitializer;
    }

    private LibraryReference[] initAppLibRefs(File file) {
        try {
            return LibraryUtils.initLibRefs(file);
        }
        catch (LibraryProcessingException libraryProcessingException) {
            if (this.isVerbose()) {
                libraryProcessingException.printStackTrace();
            }
            System.out.println("Problem processing weblogic-application.xml, ignoring any library references it may contain.");
            return null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new BuildXMLGen(stringArray).run();
    }

    public static class BuildXMLGenerator
    extends CodeGenerator {
        private final String projectName;
        private final File srcDir;
        private final File[] componentDirs;
        private int componentIndex = 0;
        private final String userName;
        private final String password;
        private final String buildFileName;
        private final String adminurl;
        private final Set skipDirs = new HashSet();
        private Library[] libraries = new Library[0];
        private LibraryReference[] unresolvedRefs = new LibraryReference[0];
        private int libraryIndex = 0;
        private int unresolvedRefIndex = 0;
        private Collection allLibraryTargets = new LinkedHashSet();
        private boolean resolvedRef = true;

        public BuildXMLGenerator(Getopt2 getopt2, String string, File file, String string2, String string3, String string4, String string5) {
            super(getopt2);
            this.projectName = string;
            this.srcDir = file;
            this.userName = string2;
            this.password = string3;
            this.buildFileName = string4;
            this.adminurl = string5;
            this.componentDirs = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            this.skipDirs.add("META-INF");
            this.skipDirs.add("APP-INF");
        }

        private void setLibraryManager(LibraryManager libraryManager) {
            HashSet<Library> hashSet = new HashSet<Library>();
            hashSet.addAll(Arrays.asList(libraryManager.getReferencedLibraries()));
            this.libraries = hashSet.toArray(new Library[hashSet.size()]);
            this.unresolvedRefs = libraryManager.getUnresolvedReferences();
        }

        public String srcdir() {
            return this.srcDir.getPath();
        }

        public String adminurl() {
            return this.adminurl;
        }

        public String project_name() {
            return this.projectName;
        }

        public String generator() {
            return "weblogic.BuildXMLGen";
        }

        public String user() {
            return this.userName;
        }

        public String password() {
            return this.password;
        }

        public String build_components() throws CodeGenerationException {
            if (this.componentDirs == null || this.componentDirs.length == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.componentDirs.length; ++i) {
                this.componentIndex = i;
                if (this.skipDirs.contains(this.component_name())) continue;
                stringBuffer.append(this.parse(this.getProductionRule("build_component")));
            }
            return stringBuffer.toString();
        }

        public String redeploy_components() throws CodeGenerationException {
            if (this.componentDirs == null || this.componentDirs.length == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.componentDirs.length; ++i) {
                this.componentIndex = i;
                if (this.skipDirs.contains(this.component_name())) continue;
                stringBuffer.append(this.parse(this.getProductionRule("redeploy_component")));
            }
            return stringBuffer.toString();
        }

        public String component_name() {
            return this.componentDirs[this.componentIndex].getName();
        }

        public String target_name() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.component_name());
            stringBuffer.append("@${servername}");
            return stringBuffer.toString();
        }

        private boolean hasLibraries() {
            return this.libraries.length > 0 || this.unresolvedRefs.length > 0;
        }

        public String nested_libraries() throws CodeGenerationException {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.hasLibraries()) {
                stringBuffer.append(">").append(System.getProperty("line.separator"));
            }
            if (this.libraries.length > 0) {
                stringBuffer.append(this.parse(this.getProductionRule("app_libraries_rule")));
            }
            if (this.unresolvedRefs.length > 0) {
                stringBuffer.append(this.parse(this.getProductionRule("unresolved_applib_refs_rule")));
            }
            return stringBuffer.toString();
        }

        public String wlcompile_end() {
            return this.hasLibraries() ? "    </wlcompile>" : " />";
        }

        public String appc_end() {
            return this.hasLibraries() ? "    </wlappc>" : " />";
        }

        public String app_libraries() throws CodeGenerationException {
            if (this.libraries.length == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.libraries.length; ++i) {
                this.libraryIndex = i;
                stringBuffer.append(this.parse(this.getProductionRule("app_library")));
                this.trimRightHandSide(stringBuffer);
                if (i >= this.libraries.length - 1) continue;
                stringBuffer.append(System.getProperty("line.separator"));
            }
            return stringBuffer.toString();
        }

        public String unresolved_applib_refs() throws CodeGenerationException {
            if (this.unresolvedRefs.length == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.unresolvedRefs.length; ++i) {
                this.unresolvedRefIndex = i;
                stringBuffer.append(this.parse(this.getProductionRule("unresolved_applib_ref")));
                this.trimRightHandSide(stringBuffer);
                if (i >= this.unresolvedRefs.length - 1) continue;
                stringBuffer.append(System.getProperty("line.separator"));
            }
            return stringBuffer.toString();
        }

        public String unresolved_library_ref() {
            LibraryReference libraryReference = this.unresolvedRefs[this.unresolvedRefIndex];
            StringBuffer stringBuffer = new StringBuffer(libraryReference.getName());
            if (libraryReference.getSpecificationVersion() != null) {
                stringBuffer.append("-").append(libraryReference.getSpecificationVersion());
                if (libraryReference.getImplementationVersion() != null) {
                    stringBuffer.append("-").append(libraryReference.getImplementationVersion());
                }
            }
            return stringBuffer.toString();
        }

        public String library_file() {
            if (this.resolvedRef) {
                return this.libraries[this.libraryIndex].getLocation().getPath();
            }
            return this.unresolvedRefs[this.unresolvedRefIndex].getName();
        }

        public String library_name() {
            if (this.resolvedRef) {
                return this.libraries[this.libraryIndex].getName();
            }
            return this.unresolvedRefs[this.unresolvedRefIndex].getName();
        }

        public String library_target_name() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.library_name());
            if (this.getSpec() != null) {
                stringBuffer.append("-").append(this.getSpec());
            }
            if (this.getImpl() != null) {
                stringBuffer.append("-").append(this.getImpl());
            }
            if (this.resolvedRef) {
                this.allLibraryTargets.add(stringBuffer.toString());
            }
            return stringBuffer.toString();
        }

        public String libspecver() {
            if (this.getSpec() == null) {
                return "";
            }
            return " libspecver=\"" + this.getSpec() + "\"";
        }

        public String libimplver() {
            if (this.getImpl() == null) {
                return "";
            }
            return " libimplver=\"" + this.getImpl() + "\"";
        }

        private String getSpec() {
            if (this.resolvedRef) {
                return this.libraries[this.libraryIndex].getSpecificationVersion();
            }
            return this.unresolvedRefs[this.unresolvedRefIndex].getSpecificationVersion();
        }

        private String getImpl() {
            if (this.resolvedRef) {
                return this.libraries[this.libraryIndex].getImplementationVersion();
            }
            return this.unresolvedRefs[this.unresolvedRefIndex].getImplementationVersion();
        }

        public String deploy_libraries() throws CodeGenerationException {
            return this.generate_deployment_target("deploy");
        }

        public String generate_deployment_target(String string) throws CodeGenerationException {
            int n;
            if (!this.hasLibraries()) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.libraries.length > 0) {
                this.resolvedRef = true;
                n = 0;
                while (n < this.libraries.length) {
                    this.libraryIndex = n++;
                    stringBuffer.append(this.parse(this.getProductionRule(string + "_library")));
                }
            }
            if (this.unresolvedRefs.length > 0) {
                this.resolvedRef = false;
                n = 0;
                while (n < this.unresolvedRefs.length) {
                    this.unresolvedRefIndex = n++;
                    stringBuffer.append(this.parse(this.getProductionRule(string + "_library_unresolved_ref")));
                }
            }
            return stringBuffer.toString();
        }

        public String deploy_all_libraries() throws CodeGenerationException {
            if (this.allLibraryTargets.isEmpty()) {
                return "";
            }
            return this.parse(this.getProductionRule("deploy_all_libraries_rule"));
        }

        public String all_libraries_deploy_targets() throws CodeGenerationException {
            if (this.allLibraryTargets.isEmpty()) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.allLibraryTargets.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("deploy.lib.").append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }

        public String undeploy_libraries() throws CodeGenerationException {
            return this.generate_deployment_target("undeploy");
        }

        public String undeploy_all_libraries() throws CodeGenerationException {
            if (this.allLibraryTargets.isEmpty()) {
                return "";
            }
            return this.parse(this.getProductionRule("undeploy_all_libraries_rule"));
        }

        public String all_libraries_undeploy_targets() throws CodeGenerationException {
            if (this.allLibraryTargets.isEmpty()) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.allLibraryTargets.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("undeploy.lib.").append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            return stringBuffer.toString();
        }

        private void trimRightHandSide(StringBuffer stringBuffer) {
            int n;
            for (n = stringBuffer.length() - 1; n >= 0 && Character.isWhitespace(stringBuffer.charAt(n)); --n) {
            }
            stringBuffer.delete(n + 1, stringBuffer.length());
        }

        protected Enumeration outputs(List list) throws Exception {
            if (this.verboseCodegen) {
                Debug.say((String)"outputs called");
            }
            BuildXMLGenOutput buildXMLGenOutput = new BuildXMLGenOutput();
            buildXMLGenOutput.setTemplate("buildxml.j");
            buildXMLGenOutput.setOutputFile(this.buildFileName);
            Vector<BuildXMLGenOutput> vector = new Vector<BuildXMLGenOutput>();
            vector.add(buildXMLGenOutput);
            return vector.elements();
        }

        public static class BuildXMLGenOutput
        extends CodeGenerator.Output {
        }
    }
}

