/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class ExpandTask
extends Task {
    private String src;
    private String dest = ".";

    public void setSrc(String string) {
        this.src = string;
    }

    public void setDest(String string) {
        this.dest = string;
    }

    public void execute() throws BuildException {
        ZipInputStream zipInputStream = null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(3000000);
        File file = new File(this.dest);
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.src), 512));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                File file2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    ExpandTask.ensureDir(file2);
                    continue;
                }
                ExpandTask.ensureDir(file2.getParentFile());
                byte[] byArray = byteBuffer.array();
                int n2 = byArray.length;
                int n3 = 0;
                while ((n = zipInputStream.read(byArray, n3, n2)) != -1) {
                    n3 += n;
                    if ((n2 -= n) != 0) continue;
                    byteBuffer = ByteBuffer.allocate(2 * n3);
                    System.out.println("expanding from " + byArray.length + " to " + byteBuffer.capacity() + " for " + file2);
                    byteBuffer.put(byArray, 0, n3);
                    byArray = byteBuffer.array();
                    n2 = byArray.length - n3;
                }
                zipInputStream.closeEntry();
                byteBuffer.limit(n3);
                FileChannel fileChannel = new RandomAccessFile(file2, "rw").getChannel();
                fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n3).put(byteBuffer);
                fileChannel.close();
                byteBuffer.clear();
            }
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        finally {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void ensureDir(File file) throws IOException {
        if (file == null) {
            return;
        }
        if (file.exists() && file.isDirectory()) {
            return;
        }
        if (file.mkdirs()) {
            return;
        }
        throw new IOException("failed to create directory " + file.getPath());
    }

    public static void main(String[] stringArray) throws Exception {
        ExpandTask expandTask = new ExpandTask();
        expandTask.setDest(".");
        expandTask.setSrc(stringArray[0]);
        expandTask.execute();
    }
}

