/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import weblogic.ant.taskdefs.build.BuildCtx;
import weblogic.ant.taskdefs.utils.AntLibraryUtils;
import weblogic.ant.taskdefs.utils.LibraryElement;
import weblogic.application.library.LibraryInitializer;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.library.LibraryReference;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.j2ee.descriptor.wl.WeblogicWebAppBean;
import weblogic.servlet.internal.War;
import weblogic.servlet.internal.WebAppDescriptor;
import weblogic.servlet.utils.WarUtils;
import weblogic.servlet.utils.WebAppLibraryUtils;
import weblogic.utils.compiler.ToolFailureException;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class LibClasspathTask
extends Task {
    private File tmpdir = null;
    private boolean userSetTmpdir = false;
    private File basedir;
    private File basewar = null;
    private String property;
    private String classpathproperty;
    private String resourcepathproperty;
    private final Collection libdirs = new ArrayList();
    private final Collection libraries = new ArrayList();

    public void addConfiguredLibrary(LibraryElement libraryElement) {
        if (libraryElement.getFile() == null) {
            throw new BuildException("Location of Library must be set");
        }
        this.libraries.add(libraryElement);
    }

    public void addConfiguredLibrarydir(LibraryElement libraryElement) {
        if (libraryElement.getDir() == null) {
            throw new BuildException("Library dir must be set");
        }
        this.libdirs.add(libraryElement.getDir());
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setClasspathProperty(String string) {
        this.classpathproperty = string;
    }

    public void setResourcepathProperty(String string) {
        this.resourcepathproperty = string;
    }

    public void setlibraryDir(File file) {
        this.libdirs.add(file);
    }

    public void settmpdir(File file) {
        this.tmpdir = file;
        this.userSetTmpdir = true;
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public void setBasewar(File file) {
        this.basewar = file;
    }

    private void checkProperty() {
        if (this.property != null && this.classpathproperty == null) {
            this.classpathproperty = this.property;
            this.log("The \"property\" attribute has been deprecated, please use the \"classpathproperty\" attribute instead.");
        }
        if (this.classpathproperty == null && this.resourcepathproperty == null) {
            throw new BuildException("The \"classpathproperty\" and/or \"resourcepathproperty\" attributes must be set.");
        }
    }

    private void checktmpdir() {
        if (!this.userSetTmpdir) {
            throw new BuildException("tmpdir must be set.");
        }
        if (this.tmpdir.exists()) {
            if (!this.tmpdir.isDirectory()) {
                throw new BuildException("tmpdir: " + this.tmpdir.getAbsolutePath() + " is not a directory.");
            }
        } else if (!this.tmpdir.mkdirs()) {
            throw new BuildException("tmpdir " + this.tmpdir.getAbsolutePath() + " does not exist, and we were unable to create it.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkbasedir() {
        if (this.basewar == null) {
            if (this.basedir == null) {
                this.basedir = new File(this.getProject().getProperty("basedir"));
                if (this.basedir == null) {
                    this.basedir = new File(System.getProperty("user.dir"));
                }
            }
            if (!this.basedir.exists()) throw new BuildException("basedir " + this.basedir.getAbsolutePath() + " does not exist.");
            if (this.basedir.isDirectory()) return;
            throw new BuildException("basedir: " + this.basedir.getAbsolutePath() + " is not a directory.");
        }
        ArrayList<LibraryElement> arrayList = new ArrayList<LibraryElement>(1);
        LibraryElement libraryElement = new LibraryElement();
        libraryElement.setFile(this.basewar);
        arrayList.add(libraryElement);
        AntLibraryUtils.validateLibraries(this.libdirs, arrayList);
    }

    private void checkParameters() {
        this.checkProperty();
        this.checktmpdir();
        this.checkbasedir();
        AntLibraryUtils.validateLibraries(this.libdirs, this.libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.checkParameters();
        try {
            this.initLibraries();
            LibraryResources libraryResources = this.getLibraryResouces();
            if (libraryResources == null) {
                this.log("basedir does not point to an application or to a module that uses libraries");
                return;
            }
            if (libraryResources.getClassPath() != null && this.classpathproperty != null) {
                this.getProject().setProperty(this.classpathproperty, libraryResources.getClassPath());
            }
            if (libraryResources.getResourcePath() != null && this.resourcepathproperty != null) {
                this.getProject().setProperty(this.resourcepathproperty, libraryResources.getResourcePath());
            }
        }
        finally {
            LibraryLoggingUtils.partialCleanupAndRemove();
            this.libdirs.clear();
            this.libraries.clear();
        }
    }

    private void initLibraries() {
        LibraryInitializer libraryInitializer = new LibraryInitializer(this.tmpdir, LibraryUtils.initDumbAppLibraryFactories());
        AntLibraryUtils.registerLibraries(libraryInitializer, this.libdirs.toArray(new File[this.libdirs.size()]), this.libraries.toArray(new LibraryElement[this.libraries.size()]), false);
        this.log("Registered libraries: ", 3);
        AntLibraryUtils.logRegistryContent(this.getProject(), 3);
        try {
            libraryInitializer.initRegisteredLibraries();
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            loggableLibraryProcessingException.printStackTrace();
            throw new BuildException(loggableLibraryProcessingException.getLoggable().getMessage(), (Throwable)loggableLibraryProcessingException);
        }
    }

    private LibraryResources getLibraryResouces() {
        if (this.basewar != null) {
            return this.getWebAppLibResources(this.basewar);
        }
        if (new File(this.basedir, "META-INF/weblogic-application.xml").exists()) {
            return this.getAppLibResources(this.basedir);
        }
        if (new File(this.basedir, WarUtils.WEBLOGIC_XML).exists()) {
            return this.getWebAppLibResources(this.basedir);
        }
        return null;
    }

    private LibraryResources getAppLibResources(File file) {
        BuildCtx buildCtx = new BuildCtx();
        try {
            LibraryReference[] libraryReferenceArray = LibraryUtils.initLibRefs(file);
            LibraryManager libraryManager = new LibraryManager(LibraryUtils.initAppReferencer(), libraryReferenceArray);
            this.initAppLibManager(libraryManager);
            LibraryUtils.importAppLibraries(libraryManager, buildCtx, buildCtx);
            LibraryResources libraryResources = new LibraryResources(AntLibraryUtils.getClassPath(buildCtx.getLibraryFiles(), buildCtx.getLibraryClassFinder()), null);
            return libraryResources;
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new BuildException(loggableLibraryProcessingException.getLoggable().getMessage(), (Throwable)loggableLibraryProcessingException);
        }
        catch (LibraryProcessingException libraryProcessingException) {
            throw new BuildException((Throwable)libraryProcessingException);
        }
        finally {
            buildCtx.getLibraryClassFinder().close();
        }
    }

    private LibraryResources getWebAppLibResources(File file) {
        VirtualJarFile virtualJarFile = null;
        War war = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
            WebAppDescriptor webAppDescriptor = new WebAppDescriptor(virtualJarFile);
            war = new War("libclasspath", this.tmpdir, virtualJarFile);
            WeblogicWebAppBean weblogicWebAppBean = WarUtils.getWlWebAppBean(webAppDescriptor);
            LibraryManager libraryManager = WebAppLibraryUtils.getEmptyWebAppLibraryManager(file.getName());
            WebAppLibraryUtils.initWebAppLibraryManager(libraryManager, weblogicWebAppBean, file.getName());
            WebAppLibraryUtils.extractWebAppLibraries(libraryManager, war, this.tmpdir);
            LibraryResources libraryResources = this.getWebAppLibResources(war);
            return libraryResources;
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        catch (ToolFailureException toolFailureException) {
            throw new BuildException((Throwable)toolFailureException);
        }
        finally {
            if (virtualJarFile != null) {
                try {
                    virtualJarFile.close();
                }
                catch (IOException iOException) {}
            }
            if (war != null) {
                war.getClassFinder().close();
            }
        }
    }

    private LibraryResources getWebAppLibResources(War war) {
        String string = war.getClassFinder().getClassPath();
        String string2 = null;
        List list = war.getBeaExtensionRoots();
        if (list != null && list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                stringBuffer.append(file.getAbsolutePath());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(File.pathSeparator);
            }
            string2 = stringBuffer.toString();
        }
        return new LibraryResources(string, string2);
    }

    private void initAppLibManager(LibraryManager libraryManager) {
        try {
            LibraryLoggingUtils.verifyLibraryReferences(libraryManager);
            libraryManager.initializeReferencedLibraries();
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new BuildException(loggableLibraryProcessingException.getLoggable().getMessage(), (Throwable)loggableLibraryProcessingException);
        }
    }

    private static final class LibraryResources {
        private final String classpath;
        private final String resourcepath;

        LibraryResources(String string, String string2) {
            this.classpath = string != null && string.trim().length() > 0 ? string : null;
            this.resourcepath = string2 != null && string2.trim().length() > 0 ? string2 : null;
        }

        String getClassPath() {
            return this.classpath;
        }

        String getResourcePath() {
            return this.resourcepath;
        }
    }
}

