/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build;

import com.bea.wls.ejbgen.ant.EJBGenAntTask;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.selectors.FileSelector;
import weblogic.ant.taskdefs.build.Application;
import weblogic.ant.taskdefs.build.ApplicationFactory;
import weblogic.ant.taskdefs.build.BuildCtx;
import weblogic.ant.taskdefs.utils.AntLibraryUtils;
import weblogic.ant.taskdefs.utils.LibraryElement;
import weblogic.application.SplitDirectoryUtils;
import weblogic.application.library.LibraryInitializer;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryReferenceFactory;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryUtils;

public final class WLCompileTask
extends MatchingTask {
    public static final File libraryTmpDir = new File(System.getProperty("java.io.tmpdir"), "wlcmp_libraries");
    private File srcdir;
    private File destdir;
    private File libdir;
    private Path compileClasspath = (Path)Path.systemClasspath.clone();
    private Javac javacTask;
    private EJBGenAntTask ejbGenTask;
    private Collection libraries = new ArrayList();
    private LibraryInitializer libraryInitializer = null;

    public void addConfiguredJavac(Javac javac) {
        this.javacTask = javac;
    }

    public void addConfiguredEjbgen(EJBGenAntTask eJBGenAntTask) {
        this.ejbGenTask = eJBGenAntTask;
    }

    public void setClasspath(Path path) {
        this.compileClasspath.append(path);
    }

    public Path createClasspath() {
        return this.compileClasspath.createPath();
    }

    public void setSrcdir(File file) {
        this.srcdir = file;
    }

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void setlibraryDir(File file) {
        this.libdir = file;
    }

    public void addConfiguredLibrary(LibraryElement libraryElement) {
        this.libraries.add(libraryElement);
    }

    private void checkSrcdir() throws BuildException {
        if (this.srcdir == null) {
            throw new BuildException("srcdir must be set");
        }
        if (!this.srcdir.exists()) {
            throw new BuildException("srcdir: " + this.srcdir.getAbsolutePath() + " does not exist or cannot be read.");
        }
        if (!this.srcdir.isDirectory()) {
            throw new BuildException("srcdir: " + this.srcdir.getAbsolutePath() + " is not a directory.");
        }
    }

    private void checkDestdir() throws BuildException {
        if (this.destdir == null) {
            throw new BuildException("destdir must be set");
        }
        if (this.destdir.exists()) {
            if (!this.destdir.isDirectory()) {
                throw new BuildException("destdir: " + this.destdir.getAbsolutePath() + " is not a directory.");
            }
        } else if (!this.destdir.mkdirs()) {
            throw new BuildException("destdir " + this.destdir.getAbsolutePath() + " does not exist, and we were unable to create it.");
        }
    }

    private void checkParameters() throws BuildException {
        this.checkSrcdir();
        this.checkDestdir();
        AntLibraryUtils.validateLibraries(this.libdir, this.libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        ClassLoader classLoader2 = ((Object)((Object)this)).getClass().getClassLoader();
        if (classLoader != ((Object)((Object)this)).getClass().getClassLoader() && classLoader2 instanceof AntClassLoader) {
            this.setClasspath(new Path(this.project, ((AntClassLoader)classLoader2).getClasspath()));
        }
        try {
            thread2.setContextClassLoader(classLoader2);
            this.privateExecute();
        }
        finally {
            thread2.setContextClassLoader(classLoader);
            if (this.libraryInitializer != null) {
                this.libraryInitializer.cleanup();
            }
        }
    }

    private void privateExecute() throws BuildException {
        this.log("Executing WLCompileTask", 3);
        this.fileset.setDir(this.srcdir);
        this.fileset.appendSelector((FileSelector)new BaseDirSelector());
        this.checkParameters();
        this.log("srcdir: " + this.srcdir.getAbsolutePath(), 3);
        this.log("destdir: " + this.destdir.getAbsolutePath(), 3);
        BuildCtx buildCtx = new BuildCtx();
        buildCtx.setProject(this.project);
        buildCtx.setSrcDir(this.srcdir);
        buildCtx.setDestDir(this.destdir);
        buildCtx.setJavacTask(this.javacTask);
        buildCtx.setEJBGen(this.ejbGenTask);
        this.handleLibraries(buildCtx);
        Application application = ApplicationFactory.newApplication(buildCtx);
        application.build(this.compileClasspath, this.buildDirSet(this.fileset));
        try {
            SplitDirectoryUtils.generatePropFile(this.srcdir, this.destdir);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new BuildException("Error generating build properties file", (Throwable)iOException);
        }
    }

    private Set buildDirSet(FileSet fileSet) throws BuildException {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
        String[] stringArray = directoryScanner.getIncludedDirectories();
        if (stringArray == null || stringArray.length == 0) {
            throw new BuildException("No modules were found to build.  Please ensure that your srcdir: " + this.srcdir.getAbsolutePath() + " is not empty, and your excludes or includes parameters do not " + "eliminate all directories.");
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(new File(this.srcdir, stringArray[i]));
        }
        return hashSet;
    }

    private void handleLibraries(BuildCtx buildCtx) {
        if (this.libdir == null && this.libraries.isEmpty()) {
            return;
        }
        try {
            this.libraryInitializer = new LibraryInitializer(libraryTmpDir, LibraryUtils.initDumbAppLibraryFactories());
            File[] fileArray = null;
            if (this.libdir != null) {
                fileArray = new File[]{this.libdir};
            }
            AntLibraryUtils.registerLibraries(this.libraryInitializer, fileArray, this.libraries.toArray(new LibraryElement[this.libraries.size()]), false);
            this.libraryInitializer.initRegisteredLibraries();
            LibraryManager libraryManager = new LibraryManager(LibraryUtils.initAppReferencer(), LibraryReferenceFactory.getAppLibReference());
            LibraryUtils.importAppLibraries(libraryManager, buildCtx, buildCtx);
            this.addLibsToClasspath(buildCtx);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new BuildException(loggableLibraryProcessingException.getLoggable().getMessage());
        }
    }

    private void addLibsToClasspath(BuildCtx buildCtx) {
        String string = AntLibraryUtils.getClassPath(buildCtx.getLibraryFiles(), buildCtx.getLibraryClassFinder());
        buildCtx.getLibraryClassFinder().close();
        this.setClasspath(new Path(this.project, string));
    }

    private static class BaseDirSelector
    implements FileSelector {
        private BaseDirSelector() {
        }

        public boolean isSelected(File file, String string, File file2) {
            return file2.isDirectory() && file2.getParentFile().equals(file);
        }
    }
}

