/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import weblogic.ant.taskdefs.build.BaseTask;
import weblogic.application.SplitDirectoryConstants;

public final class WLPackageTask
extends BaseTask
implements SplitDirectoryConstants {
    private File toFile;
    private File toDir;
    private File srcDir;
    private File destDir;
    private List filesets = new ArrayList();

    public void setTofile(File file) {
        this.toFile = file;
    }

    public void setTodir(File file) {
        this.toDir = file;
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    private void validateDir(String string, File file) throws BuildException {
        if (file == null) {
            throw new BuildException("Parameter " + string + " must be set.");
        }
        if (!file.exists()) {
            throw new BuildException(string + ": " + file.getAbsolutePath() + " does not exist.");
        }
        if (!file.isDirectory()) {
            throw new BuildException(string + ": " + file.getAbsolutePath() + " exists, but it is not a directory.");
        }
    }

    private void validateParameters() throws BuildException {
        if (this.toDir == null && this.toFile == null) {
            throw new BuildException("Either toFile or toDir must be set");
        }
        if (this.toDir != null && this.toFile != null) {
            throw new BuildException("Either toFile or toDir cannot both be set");
        }
        if (this.toDir != null) {
            if (this.toDir.exists()) {
                if (!this.toDir.isDirectory()) {
                    throw new BuildException("toDir: " + this.toDir.getAbsolutePath() + " exists, but is not a directory");
                }
            } else if (!this.toDir.mkdirs()) {
                throw new BuildException("toDir: " + this.toDir.getAbsolutePath() + " does not exist, and we were unable to create it.");
            }
        }
        this.validateDir("srcdir", this.srcDir);
        this.validateDir("destdir", this.destDir);
    }

    private FileSet[] buildFileSet() {
        if (this.filesets.size() > 0) {
            return this.filesets.toArray(new FileSet[this.filesets.size()]);
        }
        FileSet[] fileSetArray = new FileSet[2];
        fileSetArray[0] = new FileSet();
        fileSetArray[0].setDir(this.srcDir);
        fileSetArray[0].setExcludes("**/*.java build.xml .beabuild.txt");
        fileSetArray[1] = new FileSet();
        fileSetArray[1].setDir(this.destDir);
        fileSetArray[1].setExcludes("**/*.java .beabuild.txt");
        return fileSetArray;
    }

    private void copy(FileSet[] fileSetArray, File file) {
        Copy copy = (Copy)this.project.createTask("copy");
        copy.setTodir(file);
        copy.setIncludeEmptyDirs(false);
        copy.setPreserveLastModified(true);
        for (int i = 0; i < fileSetArray.length; ++i) {
            copy.addFileset(fileSetArray[i]);
        }
        copy.execute();
    }

    private void jar(File file, FileSet[] fileSetArray) {
        Jar jar = (Jar)this.project.createTask("jar");
        jar.setDestFile(file);
        File file2 = new File(this.srcDir, "META-INF/MANIFEST.MF");
        if (file2.exists()) {
            jar.setManifest(file2);
        }
        for (int i = 0; i < fileSetArray.length; ++i) {
            jar.addFileset(fileSetArray[i]);
        }
        jar.execute();
    }

    public void privateExecute() throws BuildException {
        this.validateParameters();
        FileSet[] fileSetArray = this.buildFileSet();
        if (this.toFile != null) {
            this.jar(this.toFile, fileSetArray);
        } else {
            this.copy(fileSetArray, this.toDir);
        }
    }
}

