/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build.module;

import com.bea.wls.ejbgen.ant.EJBGenAntTask;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Move;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import weblogic.ant.taskdefs.build.BuildCtx;
import weblogic.ant.taskdefs.build.module.Module;
import weblogic.utils.FileUtils;

public final class EJBModule
extends Module {
    private final String srcDirPath;
    private final File[] ejbGenFiles;
    private static final String BEA_EJBGEN_NAME = "weblogic.ant.taskdefs.build.module.EJBModule.ejbgen";

    public EJBModule(BuildCtx buildCtx, File file, File file2, File[] fileArray) throws BuildException {
        super(buildCtx, file, file2);
        this.ejbGenFiles = fileArray;
        try {
            this.srcDirPath = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    public void addToClasspath(Path path) {
        this.addToClasspath(path, this.destDir);
    }

    private File getDestFile(File file) throws IOException {
        String string = file.getCanonicalPath();
        String string2 = string.substring(this.srcDirPath.length());
        return new File(this.destDir, string2.substring(0, string2.length() - 3) + "java");
    }

    private EJBGenAntTask findOrCreateEJBGen() {
        EJBGenAntTask eJBGenAntTask = this.ctx.getEJBGen();
        if (eJBGenAntTask != null) {
            return (EJBGenAntTask)eJBGenAntTask.clone();
        }
        Hashtable hashtable = this.project.getTaskDefinitions();
        if (!hashtable.contains(BEA_EJBGEN_NAME)) {
            this.project.addTaskDefinition(BEA_EJBGEN_NAME, EJBGenAntTask.class);
        }
        eJBGenAntTask = (EJBGenAntTask)this.project.createTask(BEA_EJBGEN_NAME);
        eJBGenAntTask.setTaskName("ejbgen");
        return eJBGenAntTask;
    }

    private void ejbGen(Path path) throws BuildException {
        Object object;
        Object object2;
        for (int i = 0; i < this.ejbGenFiles.length; ++i) {
            try {
                object2 = this.getDestFile(this.ejbGenFiles[i]);
                FileUtils.copy((File)this.ejbGenFiles[i], (File)object2);
                continue;
            }
            catch (IOException iOException) {
                throw new BuildException((Throwable)iOException);
            }
        }
        EJBGenAntTask eJBGenAntTask = this.findOrCreateEJBGen();
        object2 = eJBGenAntTask.createClasspath();
        object2.append(path);
        this.addToClasspath((Path)object2, this.srcDir);
        if (eJBGenAntTask.getOutputDir() == null) {
            eJBGenAntTask.setOutputDir(this.destDir);
        }
        if (eJBGenAntTask.getFileSet() == null) {
            object = new FileSet();
            object.setDir(this.srcDir);
            object.setIncludes("**/*.ejb");
            eJBGenAntTask.addConfiguredFileSet((FileSet)object);
        }
        eJBGenAntTask.setFork(true);
        eJBGenAntTask.execute();
        object = new File(this.destDir, "META-INF");
        ((File)object).mkdir();
        Move move = (Move)this.project.createTask("move");
        move.setTodir((File)object);
        FileSet fileSet = new FileSet();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ejb-jar.xml");
        if (new File(this.destDir, "weblogic-ejb-jar.xml").exists()) {
            stringBuffer.append(", weblogic-ejb-jar.xml");
        }
        if (new File(this.destDir, "weblogic-cmp-rdbms-jar.xml").exists()) {
            stringBuffer.append(", weblogic-cmp-rdbms-jar.xml");
        }
        fileSet.setDir(this.destDir);
        fileSet.setIncludes(stringBuffer.toString());
        move.addFileset(fileSet);
        move.execute();
    }

    public void build(Path path) throws BuildException {
        this.log("Compiling module: " + this.getClass().getName() + ": " + this.srcDir);
        if (this.ejbGenFiles != null && this.ejbGenFiles.length > 0) {
            this.ejbGen(path);
            this.javac(path, this.destDir, this.destDir, this.srcDir);
        }
        this.javac(path, this.srcDir, this.destDir);
    }
}

