/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build.module;

import java.io.File;
import java.io.FileFilter;
import org.apache.tools.ant.BuildException;
import weblogic.ant.taskdefs.build.BuildCtx;
import weblogic.ant.taskdefs.build.module.JavaModule;
import weblogic.ant.taskdefs.build.module.Module;
import weblogic.ant.taskdefs.build.module.ModuleFactory;
import weblogic.utils.FileUtils;

public final class JavaModuleFactory
extends ModuleFactory {
    private static FileFilter JAVA_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return !file.isDirectory() && file.getName().endsWith(".java");
        }
    };

    Module claim(BuildCtx buildCtx, File file, File file2) throws BuildException {
        if (this.hasJavaFiles(file)) {
            return new JavaModule(buildCtx, file, file2);
        }
        return null;
    }

    private boolean hasJavaFiles(File file) {
        if (file == null) {
            return false;
        }
        File[] fileArray = file.listFiles(JAVA_FILTER);
        if (fileArray != null && fileArray.length > 0) {
            return true;
        }
        File[] fileArray2 = file.listFiles(FileUtils.DIR);
        if (fileArray2 != null) {
            for (int i = 0; i < fileArray2.length; ++i) {
                if (!this.hasJavaFiles(fileArray2[i])) continue;
                return true;
            }
        }
        return false;
    }
}

