/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build.module;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import weblogic.ant.taskdefs.build.BuildCtx;
import weblogic.ant.taskdefs.build.module.JavacCloner;

public abstract class Module {
    protected BuildCtx ctx;
    protected Project project;
    protected final File srcDir;
    protected final File destDir;

    public Module(BuildCtx buildCtx, File file, File file2) {
        this.ctx = buildCtx;
        this.project = buildCtx.getProject();
        this.srcDir = file;
        this.destDir = file2;
    }

    public File getSrcdir() {
        return this.srcDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public abstract void addToClasspath(Path var1);

    public abstract void build(Path var1) throws BuildException;

    protected void addToClasspath(Path path, File file) {
        Path.PathElement pathElement = path.createPathElement();
        pathElement.setLocation(file);
    }

    protected void log(String string) {
        this.project.log(string, 3);
    }

    protected void javac(Path path, File file, File file2) {
        this.javac(path, file, file2, null);
    }

    protected void javac(Path path, File file, File file2, File file3) {
        this.log("javac javacDir: " + file + " outDir: " + file2);
        Javac javac = this.ctx.getJavacTask();
        Javac javac2 = (Javac)this.project.createTask("javac");
        if (javac != null) {
            JavacCloner.getJavaCloner().copy(javac, javac2);
        }
        javac2.setSrcdir(new Path(this.project, file.getAbsolutePath()));
        file2.mkdirs();
        javac2.setDestdir(file2);
        javac2.setClasspath(path);
        if (file3 != null) {
            javac2.setSourcepath(new Path(this.project, file3.getAbsolutePath()));
        }
        javac2.execute();
    }
}

