/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build.module;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import weblogic.ant.taskdefs.build.BuildCtx;
import weblogic.ant.taskdefs.build.module.EJBModuleFactory;
import weblogic.ant.taskdefs.build.module.JavaModuleFactory;
import weblogic.ant.taskdefs.build.module.Module;
import weblogic.ant.taskdefs.build.module.RARModuleFactory;
import weblogic.ant.taskdefs.build.module.WebModuleFactory;

public abstract class ModuleFactory {
    private static ModuleFactory[] factories = new ModuleFactory[]{new WebModuleFactory(), new RARModuleFactory(), new EJBModuleFactory(), new JavaModuleFactory()};

    protected static void logVerbose(Project project, String string) {
        project.log(string, 3);
    }

    abstract Module claim(BuildCtx var1, File var2, File var3) throws BuildException;

    public static List[] createModules(BuildCtx buildCtx, File[] fileArray) throws BuildException {
        Project project = buildCtx.getProject();
        ModuleFactory.logVerbose(project, "Creating Modules");
        List[] listArray = new List[factories.length];
        File file = buildCtx.getDestDir();
        for (int i = 0; i < fileArray.length; ++i) {
            Module module = null;
            Object var7_7 = null;
            for (int j = 0; j < factories.length; ++j) {
                module = factories[j].claim(buildCtx, fileArray[i], new File(file, fileArray[i].getName()));
                if (module == null) continue;
                ModuleFactory.logVerbose(project, "Adding module: " + module.getClass().getName() + " with srcdir: " + module.getSrcdir() + " and destdir: " + module.getDestdir());
                if (listArray[j] == null) {
                    listArray[j] = new ArrayList();
                }
                listArray[j].add(module);
                break;
            }
            if (module != null) continue;
            ModuleFactory.logVerbose(project, "Unable to determine module type of directory " + fileArray[i].getAbsolutePath());
        }
        return ModuleFactory.reverse(listArray);
    }

    private static List[] reverse(List[] listArray) {
        int n = listArray.length;
        List[] listArray2 = new List[n];
        for (int i = 0; i < n; ++i) {
            listArray2[i] = listArray[n - i - 1];
        }
        return listArray2;
    }
}

