/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.build.module;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import weblogic.ant.taskdefs.build.BuildCtx;
import weblogic.ant.taskdefs.build.WLCompileTask;
import weblogic.ant.taskdefs.build.module.Module;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryReferenceFactory;
import weblogic.servlet.internal.War;
import weblogic.servlet.utils.WebAppLibraryUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class WebModule
extends Module {
    private static final String WEBINF_CLASSES = File.separatorChar + "WEB-INF" + File.separatorChar + "classes";
    private static final String WEBINF_SRC = File.separatorChar + "WEB-INF" + File.separatorChar + "src";
    private static final File tmpDir = new File(System.getProperty("java.io.tmpdir"), "wlcmp");
    private War war = null;

    public WebModule(BuildCtx buildCtx, File file, File file2) {
        super(buildCtx, file, file2);
    }

    public void addToClasspath(Path path) {
        try {
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File[])new File[]{this.srcDir, this.destDir});
            this.war = new War(this.srcDir.getName(), tmpDir, virtualJarFile);
            this.addLibraries(this.war);
            this.addToClasspath(path, this.war.getClassFinder().getClassPath());
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    private void addLibraries(War war) throws IOException {
        LibraryManager libraryManager = WebAppLibraryUtils.getEmptyWebAppLibraryManager();
        libraryManager.lookup(LibraryReferenceFactory.getWebAppLibReference());
        WebAppLibraryUtils.extractWebAppLibraries(libraryManager, war, WLCompileTask.libraryTmpDir);
    }

    private void addToClasspath(Path path, String string) {
        Path.PathElement pathElement = path.createPathElement();
        pathElement.setPath(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(Path path) {
        try {
            this.log("Compiling module: " + this.getClass().getName() + ": " + this.srcDir);
            this.destDir.mkdir();
            File file = new File(this.srcDir, WEBINF_SRC);
            if (file.exists() && file.isDirectory()) {
                this.javac(path, file, new File(this.destDir, WEBINF_CLASSES));
            }
        }
        finally {
            if (this.war != null) {
                this.war.getClassFinder().close();
                this.war.remove();
            }
        }
    }
}

