/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.connector;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipOutputStream;

public class Rar
extends Jar {
    private File deploymentDescriptor;
    private File weblogicDeploymentDescriptor;
    private boolean descriptorAdded;
    private static final FileUtils fu = FileUtils.newFileUtils();

    public Rar() {
        this.archiveType = "rar";
        this.emptyBehavior = "create";
    }

    public void setWarfile(File file) {
        this.setDestFile(file);
    }

    public void setRaxml(File file) {
        this.deploymentDescriptor = file;
        if (!this.deploymentDescriptor.exists()) {
            throw new BuildException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(this.deploymentDescriptor);
        zipFileSet.setFullpath("META-INF/ra.xml");
        super.addFileset((FileSet)zipFileSet);
    }

    public void setWeblogicRaxml(File file) {
        this.weblogicDeploymentDescriptor = file;
        if (!this.weblogicDeploymentDescriptor.exists()) {
            throw new BuildException("Weblogic Deployment descriptor: " + this.weblogicDeploymentDescriptor + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(this.weblogicDeploymentDescriptor);
        zipFileSet.setFullpath("META-INF/weblogic-ra.xml");
        super.addFileset((FileSet)zipFileSet);
    }

    public void addLib(ZipFileSet zipFileSet) {
        super.addFileset((FileSet)zipFileSet);
    }

    public void addClasses(ZipFileSet zipFileSet) {
        super.addFileset((FileSet)zipFileSet);
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.deploymentDescriptor == null && !this.isInUpdateMode()) {
            throw new BuildException("raxml attribute is required", this.getLocation());
        }
        super.initZipOutputStream(zipOutputStream);
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        if (string.equalsIgnoreCase("META-INF/ra.xml")) {
            if (this.deploymentDescriptor == null || !fu.fileNameEquals(this.deploymentDescriptor, file) || this.descriptorAdded) {
                this.log("Warning: selected " + this.archiveType + " files include a META-INF/ra.xml which will be ignored " + "(please use raxmll attribute to " + this.archiveType + " task)", 1);
            } else {
                super.zipFile(file, zipOutputStream, string, n);
                this.descriptorAdded = true;
            }
        } else {
            super.zipFile(file, zipOutputStream, string, n);
        }
    }

    protected void cleanUp() {
        this.descriptorAdded = false;
        super.cleanUp();
    }
}

