/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.derby;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;

public class Derby
extends Java {
    private static final String DERBY_MAIN_CLASS = "org.apache.derby.drda.NetworkServerControl";
    private static final int DEFAULT_PORT = 1527;
    private String host = null;
    private Integer port = null;
    private String systemHome = null;
    private String operation = "ping";
    private boolean execFailed = false;

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setOperation(String string) {
        this.operation = string;
    }

    public void setSystemHome(String string) {
        this.systemHome = string;
    }

    public void execute() throws BuildException {
        this.executeDerby();
    }

    private void executeDerby() {
        this.setFork(true);
        this.setSpawn(true);
        this.setClassname(DERBY_MAIN_CLASS);
        this.setProperty("derby.system.home", this.systemHome);
        if (this.port != null) {
            this.setProperty("derby.drda.portNumber", this.port);
        }
        if (this.host != null) {
            this.setProperty("derby.drda.host", this.host);
        }
        if (this.operation != null) {
            this.createArg().setValue(this.operation);
        }
        System.out.println("invoking: " + this.getCommandLine());
        if (this.executeJava() != 0) {
            System.out.println("failed: ");
            this.execFailed = true;
        }
        System.out.println("finished");
    }

    private void setProperty(String string, Object object) {
        if (object != null) {
            this.createJvmarg().setValue("-D" + string + "=" + object.toString());
        }
    }

    private void setProperty(String string, boolean bl) {
        if (bl) {
            this.createJvmarg().setValue("-D" + string);
        }
    }

    public void run() {
        this.executeDerby();
    }
}

