/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.ear;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import weblogic.application.ApplicationDescriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorException;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.WebBean;

public class AddEarModules
extends Task {
    private static final int TYPE_None = 0;
    private static final int TYPE_Ejb = 1;
    private static final int TYPE_WebApp = 2;
    private static final String EXT_War = ".war";
    private static final String EXT_Jar = ".jar";
    private static final String DIR_AppLib = "app-inf/lib";
    private static final String DIR_WebLib = "web-inf/lib";
    private static final String WEBAPP = "web-inf/web.xml";
    private static final String EJB = "meta-inf/ejb-jar.xml";
    private File _earDir;
    private File _earFile;
    private EarFile _appXml;
    private boolean _update;
    private Vector _modules = new Vector();

    public void setEar(String string) {
        this._earDir = new File(string);
        if (!this._earDir.isDirectory()) {
            this._earFile = this._earDir;
            this._earDir = null;
        }
    }

    public void setUpdate(boolean bl) {
        this._update = bl;
    }

    public void addEjb(Ejb ejb) {
        this._modules.add(ejb);
    }

    public void addWeb(Web web) {
        this._modules.add(web);
    }

    public void execute() throws BuildException {
        if (this._earDir == null && this._earFile != null) {
            if (!this._earFile.exists()) {
                throw new BuildException("'" + this._earFile + "' is not a file or directory");
            }
            this.removeTmpDir();
            this._earDir = this.getTmpDir();
            this.expand();
        }
        if (!this._earDir.exists() || !this._earDir.isDirectory()) {
            throw new BuildException("'" + this._earDir + "' is not a directory");
        }
        this._appXml = new EarFile(this._earDir);
        Enumeration enumeration = this._modules.elements();
        while (enumeration.hasMoreElements()) {
            Ejb ejb = (Ejb)enumeration.nextElement();
            File file = new File(this._earDir, ejb.getUri());
            if (ejb instanceof Web) {
                Web web = (Web)ejb;
                this.copyModule(web);
                if (this.getModuleType(file) != 2) {
                    this.log("Module at '" + file + "' is not a web-app", 1);
                }
                this.addWebModule(file, web.getContext());
                continue;
            }
            this.copyModule(ejb);
            if (this.getModuleType(file) != 1) {
                this.log("Module at '" + file + "' is not an ejb", 1);
            }
            this.addEjbModule(file);
        }
        if (this._update) {
            this.checkDirectory();
        }
        try {
            this._appXml.write();
        }
        catch (IOException iOException) {
            throw new BuildException("Error updating application.xml in ear");
        }
        if (this._earFile != null) {
            this.zip();
        }
    }

    private void removeTmpDir() throws BuildException {
        File file = this.getTmpDir();
        if (!file.exists()) {
            return;
        }
        this.log("Deleting: " + file.getAbsolutePath());
        this.removeDir(file);
        file.delete();
    }

    private void removeDir(File file) throws BuildException {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                this.removeDir(file2);
                continue;
            }
            if (file2.delete()) continue;
            throw new BuildException("Unable to delete file " + file2.getAbsolutePath());
        }
        if (!file.delete()) {
            throw new BuildException("Unable to delete directory " + file.getAbsolutePath());
        }
    }

    private void checkDirectory() {
        this.check(this._earDir);
    }

    private void check(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.check(file2);
                continue;
            }
            String string = file2.getAbsolutePath();
            if ((string = string.replace('\\', '/')).toLowerCase().indexOf(DIR_AppLib) < 0 && string.toLowerCase().indexOf(DIR_WebLib) < 0) {
                switch (this.checkArchive(file2)) {
                    case 2: {
                        this.addWebModule(file2, null);
                        break;
                    }
                    case 1: {
                        this.addEjbModule(file2);
                    }
                }
            }
            if (string.toLowerCase().endsWith(EJB)) {
                string = file2.getAbsolutePath();
                string = string.substring(0, string.length() - EJB.length() - 1);
                this.addEjbModule(new File(string));
            }
            if (!string.toLowerCase().endsWith(WEBAPP)) continue;
            string = file2.getAbsolutePath();
            string = string.substring(0, string.length() - WEBAPP.length() - 1);
            this.addWebModule(new File(string), null);
        }
    }

    private int getModuleType(File file) {
        int n = this.checkArchive(file);
        if (n != 0) {
            return n;
        }
        File file2 = new File(file, WEBAPP);
        if (file2.exists()) {
            return 2;
        }
        file2 = new File(file, EJB);
        if (file2.exists()) {
            return 1;
        }
        return 0;
    }

    public void copyModule(Ejb ejb) {
        File file;
        Enumeration enumeration = ejb.getFileSets();
        String string = ejb.getUri();
        String string2 = ejb.getSrc();
        File file2 = new File(this._earDir, string);
        if (string2 != null) {
            file = new File(string2, string);
            FileSet fileSet = new FileSet();
            if (file.isDirectory()) {
                fileSet.setDir(file);
            } else {
                file2 = file2.getParentFile();
                fileSet.setFile(file);
            }
            this.copyFileset(fileSet, file2);
        }
        while (enumeration.hasMoreElements()) {
            file = (FileSet)enumeration.nextElement();
            this.copyFileset((FileSet)file, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyFileset(FileSet fileSet, File file) throws BuildException {
        Hashtable hashtable = new Hashtable();
        try {
            String[] stringArray = fileSet.getDirectoryScanner(this.getProject()).getIncludedFiles();
            this.scanDir(hashtable, fileSet.getDir(this.getProject()), file, stringArray);
            if (hashtable.size() == 0) {
                throw new BuildException("No files in fileset dir=" + fileSet.getDir(this.getProject()));
            }
            if (hashtable.size() <= 0) return;
            this.log("Copying " + hashtable.size() + " file" + (hashtable.size() == 1 ? "" : "s") + " to " + file.getAbsolutePath());
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                try {
                    this.getProject().copyFile(string, string2, false, true);
                }
                catch (IOException iOException) {
                    String string3 = "Failed to copy " + string + " to " + string2 + " due to " + iOException.getMessage();
                    throw new BuildException(string3, (Throwable)iOException, this.getLocation());
                    return;
                }
            }
        }
        finally {
            hashtable.clear();
        }
    }

    private void scanDir(Hashtable hashtable, File file, File file2, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file3 = new File(file, string);
            File file4 = new File(file2, string);
            hashtable.put(file3.getAbsolutePath(), file4.getAbsolutePath());
        }
    }

    private File getTmpDir() {
        return new File(System.getProperty("java.io.tmpdir"), this._earFile.getName());
    }

    private int checkArchive(File file) throws BuildException {
        String string = file.getAbsolutePath();
        if (!string.toLowerCase().endsWith(EXT_Jar) && !string.toLowerCase().endsWith(EXT_War)) {
            return 0;
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string2 = zipEntry.getName();
                if ((string2 = string2.replace('\\', '/')).toLowerCase().equals(WEBAPP)) {
                    return 2;
                }
                if (!string2.toLowerCase().equals(EJB)) continue;
                return 1;
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            throw new BuildException("Error processing " + file);
        }
        return 0;
    }

    protected void addWebModule(File file, String string) throws BuildException {
        try {
            String string2 = file.getAbsolutePath();
            boolean bl = this._appXml.isWebModule(file);
            if (string == null) {
                string = string2.substring(this._earDir.getAbsolutePath().length() + 1);
                if (!file.isDirectory() && (string.endsWith(EXT_Jar) || string.endsWith(EXT_War))) {
                    string = string.substring(0, string.length() - EXT_Jar.length());
                }
            }
            this.log((bl ? "Updating" : "Adding") + " web module '" + this.getRelativeFile(file) + "' with context '" + string + "'");
            this._appXml.addWebModule(file, string);
        }
        catch (IOException iOException) {
            throw new BuildException("Error updating application.xml in ear");
        }
    }

    protected void addEjbModule(File file) throws BuildException {
        try {
            if (!this._appXml.isEjbModule(file)) {
                this.log("Adding ebj module '" + this.getRelativeFile(file) + "'");
                this._appXml.addEjbModule(file);
            }
        }
        catch (IOException iOException) {
            throw new BuildException("Error updating application.xml in ear");
        }
    }

    private void expand() throws BuildException {
        Expand expand = new Expand();
        expand.setSrc(this._earFile);
        expand.setDest(this._earDir);
        expand.setProject(this.getProject());
        expand.setTaskName(this.getTaskName());
        expand.execute();
    }

    private void zip() throws BuildException {
        Zip zip = new Zip();
        zip.setFile(this._earFile);
        zip.setBasedir(this._earDir);
        zip.setProject(this.getProject());
        zip.setTaskName(this.getTaskName());
        zip.execute();
    }

    private String getRelativeFile(File file) throws IOException {
        String string = file.getCanonicalFile().getAbsolutePath().substring(this._earDir.getCanonicalFile().getAbsolutePath().length() + 1).replace('\\', '/');
        return string;
    }

    private static class EarFile {
        private File earDir = null;
        private boolean appBeanDirty = false;
        private ApplicationBean appBean = null;

        public EarFile(File file) {
            this.earDir = file;
        }

        public boolean isWebModule(File file) throws IOException {
            ApplicationBean applicationBean = this.getApplicationBean(true);
            String string = this.getRelativeFilePath(file);
            ModuleBean[] moduleBeanArray = applicationBean.getModules();
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                WebBean webBean = moduleBeanArray[i].getWeb();
                if (webBean == null || !webBean.getWebUri().equals(string)) continue;
                return true;
            }
            return false;
        }

        public void addWebModule(File file, String string) throws IOException {
            WebBean webBean;
            ApplicationBean applicationBean = this.getApplicationBean(true);
            String string2 = this.getRelativeFilePath(file);
            ModuleBean[] moduleBeanArray = applicationBean.getModules();
            boolean bl = false;
            for (int i = 0; i < moduleBeanArray.length && !bl; ++i) {
                webBean = moduleBeanArray[i].getWeb();
                if (webBean == null || !webBean.getWebUri().equals(string2)) continue;
                bl = true;
                if (webBean.getContextRoot().equals(string)) continue;
                webBean.setContextRoot(string);
                this.appBeanDirty = true;
            }
            if (!bl) {
                ModuleBean moduleBean = applicationBean.createModule();
                webBean = moduleBean.createWeb();
                webBean.setWebUri(string2);
                webBean.setContextRoot(string);
                this.appBeanDirty = true;
            }
        }

        public boolean isEjbModule(File file) throws IOException {
            ApplicationBean applicationBean = this.getApplicationBean(true);
            String string = this.getRelativeFilePath(file);
            ModuleBean[] moduleBeanArray = applicationBean.getModules();
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                String string2 = moduleBeanArray[i].getEjb();
                if (string2 == null || !string.equals(moduleBeanArray[i].getEjb())) continue;
                return true;
            }
            return false;
        }

        public void addEjbModule(File file) throws IOException {
            ApplicationBean applicationBean = this.getApplicationBean(true);
            String string = this.getRelativeFilePath(file);
            ModuleBean[] moduleBeanArray = applicationBean.getModules();
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                if (!string.equals(moduleBeanArray[i].getEjb())) continue;
                return;
            }
            ModuleBean moduleBean = applicationBean.createModule();
            moduleBean.setEjb(string);
            this.appBeanDirty = true;
        }

        private String getRelativeFilePath(File file) throws IOException {
            String string = file.getCanonicalFile().getAbsolutePath().substring(this.earDir.getCanonicalFile().getAbsolutePath().length() + 1).replace('\\', '/');
            return string;
        }

        private synchronized ApplicationBean getApplicationBean(boolean bl) throws IOException {
            if (this.appBean == null) {
                File file = new File(this.earDir, "META-INF/application.xml");
                if (file.exists()) {
                    try {
                        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(file, null, (File)null, null, null, null);
                        applicationDescriptor.setValidateSchema(false);
                        this.appBean = applicationDescriptor.getApplicationDescriptor();
                    }
                    catch (DescriptorException descriptorException) {
                        if (!bl) {
                            throw new IOException("The existing application.xml at " + file.getAbsolutePath() + " is corrupted.\n" + descriptorException.getMessage());
                        }
                        System.out.println("[AddEarModules] The existing application.xml at " + file.getAbsolutePath() + " is corrupted. " + descriptorException.getMessage());
                        System.out.println("[AddEarModules] Recreating a new application.xml");
                        this.createApplicationBean();
                    }
                    catch (Exception exception) {
                        throw new IOException("The existing application.xml at " + file.getAbsolutePath() + " is corrupted.\n" + exception.getMessage());
                    }
                }
                if (!file.exists() && bl) {
                    this.createApplicationBean();
                }
            }
            return this.appBean;
        }

        private void createApplicationBean() {
            this.appBean = (ApplicationBean)new EditableDescriptorManager().createDescriptorRoot(ApplicationBean.class).getRootBean();
            int n = this.earDir.getAbsolutePath().lastIndexOf("/");
            if (n == -1) {
                n = this.earDir.getAbsolutePath().lastIndexOf("\\");
            }
            String string = this.earDir.getAbsolutePath().substring(n + 1);
            this.appBean.setDisplayNames(new String[]{string});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() throws IOException {
            if (this.appBeanDirty) {
                FileOutputStream fileOutputStream = null;
                try {
                    File file = new File(this.earDir, "META-INF");
                    file.mkdirs();
                    File file2 = new File(file, "application.xml");
                    fileOutputStream = new FileOutputStream(file2);
                    new EditableDescriptorManager().writeDescriptorAsXML(((DescriptorBean)this.appBean).getDescriptor(), (OutputStream)fileOutputStream);
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public static class Web
    extends Ejb {
        private String _context;

        public void setContext(String string) {
            this._context = string;
        }

        public String getContext() {
            return this._context;
        }
    }

    public static class Ejb {
        private String _src;
        private String _uri;
        private Vector _srcs = new Vector();

        public void addFileSet(FileSet fileSet) {
            this._srcs.add(fileSet);
        }

        public void setUri(String string) {
            this._uri = string;
        }

        public void setSrc(String string) {
            this._src = string;
        }

        public String getUri() {
            return this._uri;
        }

        public String getSrc() {
            return this._src;
        }

        public Enumeration getFileSets() {
            return this._srcs.elements();
        }
    }
}

