/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.j2ee;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import weblogic.ant.taskdefs.utils.AntLibraryUtils;
import weblogic.ant.taskdefs.utils.LibraryElement;
import weblogic.application.compiler.AppMerge;

public final class AppMergeTask
extends MatchingTask {
    private String source = null;
    private String output = null;
    private String libdir = null;
    private String plan = null;
    private boolean verbose = false;
    private Collection libraries = new ArrayList();

    public void setSource(String string) {
        this.source = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public void setlibraryDir(String string) {
        this.libdir = string;
    }

    public void setPlan(String string) {
        this.plan = string;
    }

    public void addConfiguredLibrary(LibraryElement libraryElement) {
        this.libraries.add(libraryElement);
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void execute() {
        File file;
        ArrayList<String> arrayList = new ArrayList<String>();
        File file2 = null;
        if (this.output != null) {
            file2 = this.project.resolveFile(this.output);
            arrayList.add("-output");
            arrayList.add(file2.getAbsolutePath());
        }
        if ((file = this.project.resolveFile(this.source)) == null) {
            throw new BuildException("Source must be specified");
        }
        if (!file.exists()) {
            throw new BuildException("Source not found: " + file);
        }
        if (file2 != null && file2.isFile() && file.isFile() && file2.lastModified() > file.lastModified()) {
            this.log(file2 + " is up to date", 3);
            return;
        }
        if (this.plan != null) {
            arrayList.add("-plan");
            arrayList.add(this.project.resolveFile(this.plan).getAbsolutePath());
        }
        if (this.verbose) {
            arrayList.add("-verbose");
        }
        arrayList.add("-noexit");
        File file3 = null;
        if (this.libdir != null) {
            file3 = this.project.resolveFile(this.libdir);
        }
        arrayList.addAll(AntLibraryUtils.getLibraryFlags(file3, this.libraries));
        arrayList.add(file.getAbsolutePath());
        this.runAppMerge(arrayList.toArray(new String[arrayList.size()]));
    }

    private void runAppMerge(String[] stringArray) {
        try {
            AppMerge.main(stringArray);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }
}

