/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.j2ee;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import weblogic.ant.taskdefs.j2ee.CompilerTask;
import weblogic.ant.taskdefs.utils.AntLibraryUtils;
import weblogic.ant.taskdefs.utils.LibraryElement;
import weblogic.utils.Executable;

public class Appc
extends CompilerTask {
    private String source = null;
    private String output = null;
    private String iiopDirectory = null;
    private String idlDirectory = null;
    private String idlMethodSignatures = null;
    private String classpath = null;
    private String libdir = null;
    private String plan = null;
    private String clientJarOutputDir = null;
    private boolean forceGeneration = false;
    private boolean lineNumbers = false;
    private boolean basicClientJar = false;
    private boolean continueCompilation = false;
    private boolean idl = false;
    private boolean idlOverwrite = false;
    private boolean idlVerbose = false;
    private boolean idlNoValueTypes = false;
    private boolean idlNoAbstractInterfaces = false;
    private boolean idlFactories = false;
    private boolean idlVisibroker = false;
    private boolean idlOrbix = false;
    private boolean iiop = false;
    private boolean verbose = false;
    private boolean enableHotCodeGen = false;
    private Collection libraries = new ArrayList();

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public void setForceGeneration(boolean bl) {
        this.forceGeneration = bl;
    }

    public void setLineNumbers(boolean bl) {
        this.lineNumbers = bl;
    }

    public void setBasicClientJar(boolean bl) {
        this.basicClientJar = bl;
    }

    public void setContinueCompilation(boolean bl) {
        this.continueCompilation = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setEnableHotCodeGen(boolean bl) {
        this.enableHotCodeGen = bl;
    }

    public void setIiopDirectory(String string) {
        this.iiopDirectory = string;
    }

    public void setIdlDirectory(String string) {
        this.idlDirectory = string;
    }

    public void setIdl(boolean bl) {
        this.idl = bl;
    }

    public void setIdlOverwrite(boolean bl) {
        this.idlOverwrite = bl;
    }

    public void setIdlVerbose(boolean bl) {
        this.idlVerbose = bl;
    }

    public void setIdlNoValueTypes(boolean bl) {
        this.idlNoValueTypes = bl;
    }

    public void setIdlNoAbstractInterfaces(boolean bl) {
        this.idlNoAbstractInterfaces = bl;
    }

    public void setIdlFactories(boolean bl) {
        this.idlFactories = bl;
    }

    public void setIdlVisibroker(boolean bl) {
        this.idlVisibroker = bl;
    }

    public void setIdlOrbix(boolean bl) {
        this.idlOrbix = bl;
    }

    public void setIiop(boolean bl) {
        this.iiop = bl;
    }

    public void setIdlMethodSignatures(String string) {
        this.idlMethodSignatures = string;
    }

    public void setlibraryDir(String string) {
        this.libdir = string;
    }

    public void setPlan(String string) {
        this.plan = string;
    }

    public void setClientJarOutputDir(String string) {
        this.clientJarOutputDir = string;
    }

    public void addConfiguredLibrary(LibraryElement libraryElement) {
        if (libraryElement.getFile() == null) {
            throw new BuildException("Location of Library must be set");
        }
        this.libraries.add(libraryElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        ClassLoader classLoader2 = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            if (classLoader != classLoader2) {
                thread2.setContextClassLoader(classLoader2);
            }
            this.privateExecute();
        }
        finally {
            thread2.setContextClassLoader(classLoader);
        }
    }

    private void privateExecute() throws BuildException {
        boolean bl;
        File file = this.project.resolveFile(this.source);
        File file2 = null;
        if (this.output != null) {
            file2 = this.project.resolveFile(this.output);
        }
        if (file == null) {
            throw new BuildException("Source must be specified");
        }
        if (!file.exists()) {
            throw new BuildException("Source not found: " + file);
        }
        if (file2 != null && file2.isFile() && file.isFile() && file2.lastModified() > file.lastModified()) {
            this.log(file2 + " is up to date", 3);
            return;
        }
        boolean bl2 = bl = !this.canFindJavelinClasses();
        if (bl) {
            this.setExit();
        }
        Vector vector = super.getFlags();
        if (this.forceGeneration) {
            vector.addElement("-forceGeneration");
        }
        if (this.lineNumbers) {
            vector.addElement("-lineNumbers");
        }
        if (this.basicClientJar) {
            vector.addElement("-basicClientJar");
        }
        if (this.continueCompilation) {
            vector.addElement("-k");
        }
        if (this.verbose) {
            vector.addElement("-verbose");
        }
        if (this.idl) {
            vector.addElement("-idl");
        }
        if (this.idlOverwrite) {
            vector.addElement("-idlOverwrite");
        }
        if (this.idlVerbose) {
            vector.addElement("-idlVerbose");
        }
        if (this.idlNoValueTypes) {
            vector.addElement("-idlNoValueTypes");
        }
        if (this.idlNoAbstractInterfaces) {
            vector.addElement("-idlNoAbstractInterfaces");
        }
        if (this.idlFactories) {
            vector.addElement("-idlFactories");
        }
        if (this.idlVisibroker) {
            vector.addElement("-idlVisibroker");
        }
        if (this.idlOrbix) {
            vector.addElement("-idlOrbix");
        }
        if (this.iiop) {
            vector.addElement("-iiop");
        }
        if (this.enableHotCodeGen) {
            vector.addElement("-enableHotCodeGen");
        }
        if (this.iiopDirectory != null) {
            vector.addElement("-iiopDirectory");
            vector.addElement(this.iiopDirectory);
        }
        if (this.idlDirectory != null) {
            vector.addElement("-idlDirectory");
            vector.addElement(this.idlDirectory);
        }
        if (this.idlMethodSignatures != null) {
            vector.addElement("-idlMethodSignatures");
            vector.addElement(this.idlMethodSignatures);
        }
        if (file2 != null) {
            vector.addElement("-output");
            vector.addElement(file2.getAbsolutePath());
        }
        if (this.plan != null) {
            vector.addElement("-plan");
            vector.addElement(this.project.resolveFile(this.plan).getAbsolutePath());
        }
        if (this.clientJarOutputDir != null) {
            vector.addElement("-clientJarOutputDir");
            vector.addElement(this.project.resolveFile(this.clientJarOutputDir).getAbsolutePath());
        }
        this.addLibraryFlags(vector);
        vector.addElement(file.getAbsolutePath());
        String[] stringArray = this.getArgs(vector);
        if (bl) {
            this.execAppc(stringArray);
        } else {
            this.invokeMain("weblogic.appc", stringArray);
        }
    }

    private boolean canFindJavelinClasses() {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass("weblogic.servlet.jsp.JspcInvoker");
            Method method = clazz.getMethod("canFindJavelinClasses", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            return (Boolean)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void execAppc(String[] stringArray) throws BuildException {
        int n;
        Executable executable = new Executable((OutputStream)System.out, (OutputStream)System.err);
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = Runtime.getRuntime().maxMemory();
        if (l == Long.MAX_VALUE) {
            l = Runtime.getRuntime().totalMemory();
        }
        arrayList.add("java");
        arrayList.add("-mx" + l);
        arrayList.add("weblogic.appc");
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        this.log("[APPC_TASK] exec'ing appc", 3);
        n = executable.exec(arrayList.toArray(new String[arrayList.size()])) ? 1 : 0;
        if (n == 0) {
            throw new BuildException("Appc failed, see error messages above");
        }
    }

    private void addLibraryFlags(Vector vector) {
        File file = null;
        if (this.libdir != null) {
            file = this.project.resolveFile(this.libdir);
        }
        List list = AntLibraryUtils.getLibraryFlags(file, this.libraries);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
    }
}

