/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.j2ee;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public abstract class CompilerTask
extends MatchingTask {
    private static final Class[] MAIN_SIGNATURE = new Class[]{String[].class};
    private static final Set inProcessJavacNames = new HashSet();
    protected String compiler = null;
    protected String version = null;
    protected Path compileClasspath = null;
    protected String compilerClass = null;
    protected boolean keepgenerated = false;
    protected boolean commentary = false;
    protected String destdir = null;
    protected boolean debug = false;
    protected boolean optimize = false;
    protected boolean noexit = true;
    protected boolean nowarn = false;
    protected boolean nowrite = false;
    protected boolean normi = false;
    protected boolean deprecation = false;
    protected boolean verboseJavac = false;
    protected String dispatchPolicy = null;
    protected boolean supressCompiler = false;
    protected String runtimeFlags = null;

    public void setCompiler(String string) {
        this.compiler = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.project);
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setKeepGenerated(boolean bl) {
        this.keepgenerated = bl;
    }

    public void setCommentary(boolean bl) {
        this.commentary = bl;
    }

    public void setDestDir(String string) {
        this.destdir = string;
    }

    public void setDispatchPolicy(String string) {
        this.dispatchPolicy = string;
    }

    public void setRuntimeFlags(String string) {
        this.runtimeFlags = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public void setNoWarn(boolean bl) {
        this.nowarn = bl;
    }

    public void setNoWrite(boolean bl) {
        this.nowrite = bl;
    }

    public void setNoRmi(boolean bl) {
        this.normi = bl;
    }

    public void setDeprecation(boolean bl) {
        this.deprecation = bl;
    }

    public void setVerboseJavac(boolean bl) {
        this.verboseJavac = bl;
    }

    public void setExit() {
        this.noexit = false;
    }

    private void setCompilerFlags(Vector vector) {
        String string;
        if (this.version != null) {
            vector.addElement("-source");
            vector.addElement(this.version);
            vector.addElement("-target");
            vector.addElement(this.version);
        } else {
            vector.addElement("-source");
            vector.addElement(System.getProperty("java.specification.version"));
        }
        if (this.supressCompiler) {
            return;
        }
        if (this.compiler == null && this.compilerClass == null && (string = this.getProject().getProperty("build.compiler")) != null) {
            if ("weblogicx.ant.sj".equals(string)) {
                this.compiler = "sj";
            } else if ("extJavac".equals(string)) {
                this.compiler = "javac";
            } else if (inProcessJavacNames.contains(string)) {
                this.compilerClass = "com.sun.tools.javac.Main";
            }
        }
        if (this.compiler != null) {
            vector.addElement("-compiler");
            vector.addElement(this.compiler);
        } else if (this.compilerClass != null) {
            vector.addElement("-compilerClass");
            vector.addElement(this.compilerClass);
        }
    }

    protected Vector getFlags() {
        Vector<String> vector = new Vector<String>();
        this.setCompilerFlags(vector);
        if (this.destdir != null) {
            vector.addElement("-d");
            vector.addElement(this.destdir);
        }
        if (this.dispatchPolicy != null) {
            vector.addElement("-dispatchPolicy");
            vector.addElement(this.dispatchPolicy);
        }
        if (this.runtimeFlags != null) {
            vector.addElement(this.runtimeFlags);
        }
        if (this.keepgenerated) {
            vector.addElement("-keepgenerated");
        }
        if (this.commentary) {
            vector.addElement("-commentary");
        }
        if (this.debug) {
            vector.addElement("-g");
        }
        if (this.optimize) {
            vector.addElement("-O");
        }
        if (this.nowarn) {
            vector.addElement("-nowarn");
        }
        if (this.verboseJavac) {
            vector.addElement("-verboseJavac");
        }
        if (this.nowrite) {
            vector.addElement("-nowrite");
        }
        if (this.normi) {
            vector.addElement("-normi");
        }
        if (this.deprecation) {
            vector.addElement("-deprecation");
        }
        if (!this.supressCompiler) {
            Path path = this.getCompileClasspath();
            vector.addElement("-classpath");
            vector.addElement(path.toString());
        }
        if (this.noexit) {
            vector.addElement("-noexit");
        }
        return vector;
    }

    protected String[] getArgs(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    protected Path getCompileClasspath() {
        Object object;
        Path path = new Path(this.project);
        if (this.destdir != null) {
            object = this.project.resolveFile(this.destdir);
            path.addExisting(new Path(this.project, ((File)object).getAbsolutePath()));
        }
        if (this.compileClasspath != null) {
            path.addExisting(this.compileClasspath);
        }
        path.addExisting(Path.systemClasspath);
        if (Project.getJavaVersion().startsWith("1.2") && (object = System.getProperty("sun.boot.class.path")) != null) {
            path.addExisting(new Path(this.project, (String)object));
        }
        return path;
    }

    protected void invokeMain(String string, String[] stringArray) {
        try {
            File file = new File(this.getProject().getProperty("dest") + "/classes");
            URL[] uRLArray = new URL[]{file.toURL()};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, ((Object)((Object)this)).getClass().getClassLoader());
            Class<?> clazz = uRLClassLoader.loadClass(string);
            Method method = null;
            method = clazz.getMethod("main", MAIN_SIGNATURE);
            Object[] objectArray = new Object[]{stringArray};
            method.invoke(null, objectArray);
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable == null) {
                throwable = invocationTargetException;
            }
            throw new BuildException(throwable);
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    static {
        inProcessJavacNames.add("classic");
        inProcessJavacNames.add("javac1.1");
        inProcessJavacNames.add("javac1.2");
        inProcessJavacNames.add("modern");
        inProcessJavacNames.add("javac1.3");
        inProcessJavacNames.add("javac1.4");
    }
}

