/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.j2ee;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import weblogic.ant.taskdefs.j2ee.CompilerTask;

public class Ejbc
extends CompilerTask {
    protected String version;
    protected String source;
    protected String target;
    protected String iiopDirectory;
    protected String idlMethodSignatures;
    protected boolean idlOverwrite;
    protected boolean idlVerbose;
    protected boolean idlNoValueTypes;
    protected boolean iiop;
    protected boolean idl;
    protected boolean disableHotCodeGen;

    public void setDisableHotCodeGen(boolean bl) {
        this.disableHotCodeGen = bl;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setIiopDirectory(String string) {
        this.iiopDirectory = string;
    }

    public void setIdl(boolean bl) {
        this.idl = bl;
    }

    public void setIdlOverwrite(boolean bl) {
        this.idlOverwrite = bl;
    }

    public void setIdlVerbose(boolean bl) {
        this.idlVerbose = bl;
    }

    public void setIdlNoValueTypes(boolean bl) {
        this.idlNoValueTypes = bl;
    }

    public void setIiop(boolean bl) {
        this.iiop = bl;
    }

    public void setIdlMethodSignatures(String string) {
        this.idlMethodSignatures = string;
    }

    protected Vector getFlags() {
        Vector vector = super.getFlags();
        if (this.iiop) {
            vector.addElement("-iiop");
        }
        if (this.idl) {
            vector.addElement("-idl");
        }
        if (this.idlOverwrite) {
            vector.addElement("-idlOverwrite");
        }
        if (this.idlVerbose) {
            vector.addElement("-idlVerbose");
        }
        if (this.idlNoValueTypes) {
            vector.addElement("-idlNoValueTypes");
        }
        if (this.debug || this.disableHotCodeGen) {
            vector.addElement("-disableHotCodeGen");
        }
        if (this.iiopDirectory != null) {
            vector.addElement("-iiopDirectory");
            vector.addElement(this.iiopDirectory);
        }
        if (this.idlMethodSignatures != null) {
            vector.addElement("-idlMethodSignatures");
            vector.addElement(this.idlMethodSignatures);
        }
        if (this.compiler != null) {
            if (this.compiler.equals("javac")) {
                vector.addElement("-compilerclass");
                vector.addElement("com.sun.tools.javac.Main");
            } else {
                vector.addElement("-compiler");
                vector.addElement(this.compiler);
            }
        }
        if (this.version != null) {
            vector.addElement("-source");
            vector.addElement(this.version);
            vector.addElement("-target");
            vector.addElement(this.version);
        }
        if (!vector.contains("-classpath")) {
            Path path = this.getCompileClasspath();
            vector.addElement("-classpath");
            vector.addElement(path.toString());
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Object object;
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        thread2.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        if (System.getProperty("weblogic.home") == null && (object = this.getProject().getProperty("wl.home")) != null) {
            System.setProperty("weblogic.home", (String)object);
        }
        try {
            this.supressCompiler = true;
            object = this.project.resolveFile(this.source);
            File file = this.project.resolveFile(this.target);
            if (object == null) {
                throw new BuildException("Source must be specified");
            }
            if (!((File)object).exists()) {
                throw new BuildException("Source not found: " + object);
            }
            if (this.target == null) {
                throw new BuildException("Target must be specified");
            }
            if (((File)object).exists() && file.exists() && file.isFile() && file.lastModified() > ((File)object).lastModified()) {
                this.log(file + " is up to date", 3);
                return;
            }
            Vector vector = this.getFlags();
            vector.addElement(((File)object).getAbsolutePath());
            vector.addElement(file.getAbsolutePath());
            String[] stringArray = this.getArgs(vector);
            try {
                this.invokeMain("weblogic.ejbc", stringArray);
            }
            catch (BuildException buildException) {
                this.log(buildException.getMessage(), 0);
                throw buildException;
            }
        }
        finally {
            thread2.setContextClassLoader(classLoader);
        }
    }
}

