/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.j2ee;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import weblogic.ant.taskdefs.j2ee.Ejbc;
import weblogic.tools.ejbgen.EJBGen;

public class Ejbgen
extends Task {
    String outputJar;
    String tmpdir;
    String srcPath;
    String classpath;
    String ejbsource;
    String utils;
    String[] ejbcflags;
    boolean keepgenerated;
    String ejbPrefix;
    String ejbSuffix;
    String localHomePrefix;
    String localHomeSuffix;
    String remoteHomePrefix;
    String remoteHomeSuffix;
    String remotePrefix;
    String remoteSuffix;
    String valueObjectPrefix;
    String valueObjectSuffix;
    String propertyFile;
    String valueBaseClass;
    String jndiPrefix;
    String jndiSuffix;
    String localPrefix;
    String localSuffix;
    boolean valueClasses = true;
    boolean remoteInterfaces = true;
    boolean localInterfaces = true;

    public void addTask(Task task) {
        Ejbgen.p("addTask(" + task.getClass().getName() + ")");
    }

    private static void p(String string) {
        System.err.println("[ejbgen]: " + string);
    }

    public void setEjbs(String string) {
        this.ejbsource = string;
    }

    public void setUtils(String string) {
        this.utils = string;
    }

    public void setSrcpath(String string) {
        this.srcPath = string;
    }

    public void setOutputJar(String string) {
        this.outputJar = string;
    }

    public void setTmpdir(String string) {
        this.tmpdir = string;
    }

    public void setClasspath(String string) {
        this.classpath = string;
    }

    public void setKeepgenerated(boolean bl) {
        this.keepgenerated = bl;
    }

    public void setEjbcFlags(String string) {
        this.ejbcflags = Ejbgen.split(string);
    }

    public void setEjbprefix(String string) {
        this.ejbPrefix = string;
    }

    public void setEjbsuffix(String string) {
        this.ejbSuffix = string;
    }

    public void setRemotePrefix(String string) {
        this.remotePrefix = string;
    }

    public void setRemoteSuffix(String string) {
        this.remoteSuffix = string;
    }

    public void setLocalPrefix(String string) {
        this.localPrefix = string;
    }

    public void setLocalSuffix(String string) {
        this.localSuffix = string;
    }

    public void setRemoteHomePrefix(String string) {
        this.remoteHomePrefix = string;
    }

    public void setRemoteHomeSuffix(String string) {
        this.remoteHomeSuffix = string;
    }

    public void setLocalHomePrefix(String string) {
        this.localHomePrefix = string;
    }

    public void setLocalHomeSuffix(String string) {
        this.localHomeSuffix = string;
    }

    public void setJndiPrefix(String string) {
        this.jndiPrefix = string;
    }

    public void setJndiSuffix(String string) {
        this.jndiSuffix = string;
    }

    public void setValueObjectPrefix(String string) {
        this.valueObjectPrefix = string;
    }

    public void setValueObjectSuffix(String string) {
        this.valueObjectSuffix = string;
    }

    public void setPropertyFile(String string) {
        this.propertyFile = string;
    }

    public void setValuebaseclass(String string) {
        this.valueBaseClass = string;
    }

    public void setValueClasses(boolean bl) {
        this.valueClasses = bl;
    }

    public void setRemoteInterfaces(boolean bl) {
        this.remoteInterfaces = bl;
    }

    public void setLocalInterfaces(boolean bl) {
        this.localInterfaces = bl;
    }

    public void execute() throws BuildException {
        this.runJavaDoc();
        this.moveXML();
        this.runJavac();
        this.runEjbc();
        if (!this.keepgenerated) {
            this.deleteSrc();
        }
        this.runZip();
    }

    private void runEjbc() throws BuildException {
        Ejbc ejbc2 = new Ejbc();
        ejbc2.setTaskName("ejbc");
        ejbc2.setProject(this.getProject());
        ejbc2.setSource(this.tmpdir);
        ejbc2.setTarget(this.tmpdir);
        ejbc2.setKeepGenerated(this.keepgenerated);
        ejbc2.execute();
    }

    private void moveXML() throws BuildException {
        Project project = this.getProject();
        File file = project.resolveFile(this.tmpdir);
        File file2 = new File(file, "META-INF");
        if (!file2.isDirectory() && !file2.mkdirs()) {
            throw new BuildException("Cannot make directory: " + file2.getAbsolutePath());
        }
        File[] fileArray = file2.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".xml") || !fileArray[i].isFile() || fileArray[i].delete()) continue;
            throw new BuildException("Cannot delete file: " + fileArray[i].getAbsolutePath());
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file3;
            File file4;
            String string = stringArray[i];
            if (!string.endsWith(".xml") || (file4 = new File(file, string)).renameTo(file3 = new File(file2, string))) continue;
            throw new BuildException("Cannot copy to: " + file3.getAbsolutePath());
        }
    }

    private void deleteSrc() throws BuildException {
        this.log("deleting generated source...");
        FileSet fileSet = new FileSet();
        Project project = this.getProject();
        fileSet.setProject(project);
        File file = project.resolveFile(this.tmpdir);
        fileSet.setDir(file);
        fileSet.setIncludes("**/*.java");
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
        String[] stringArray = directoryScanner.getIncludedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.delete()) continue;
            throw new BuildException("Cannot delete: " + file2.getAbsolutePath());
        }
    }

    private void runZip() throws BuildException {
        this.log("runzip");
        Zip zip = new Zip();
        Project project = this.getProject();
        zip.setProject(project);
        zip.setTaskName("zip");
        File file = project.resolveFile(this.tmpdir);
        zip.setBasedir(file);
        zip.setZipfile(project.resolveFile(this.outputJar));
        zip.execute();
    }

    private void runJavaDoc() throws BuildException {
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        File file = null;
        file = this.getProject().getBaseDir();
        fileSet.setDir(file);
        fileSet.setIncludes(this.ejbsource);
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        Project project = this.getProject();
        Javadoc javadoc = new Javadoc();
        javadoc.setProject(project);
        javadoc.setTaskName("ejbgen");
        Javadoc.DocletInfo docletInfo = javadoc.createDoclet();
        javadoc.setDoclet(EJBGen.class.getName());
        this.addJavadocOptions(docletInfo);
        Javadoc.DocletParam docletParam = docletInfo.createParam();
        docletParam.setName("-d");
        docletParam.setValue(project.resolveFile(this.tmpdir).getAbsolutePath());
        this.log("outputting to " + this.tmpdir);
        for (int i = 0; i < stringArray.length; ++i) {
            Javadoc.SourceFile sourceFile = new Javadoc.SourceFile();
            sourceFile.setFile(new File(file, stringArray[i]));
            javadoc.addSource(sourceFile);
        }
        Path path = javadoc.createSourcepath();
        path.setPath(this.srcPath);
        javadoc.execute();
    }

    private void addJavadocOptions(Javadoc.DocletInfo docletInfo) {
        if (this.ejbPrefix != null) {
            this.addString(docletInfo, "-ejbPrefix", this.ejbPrefix);
        }
        if (this.ejbSuffix != null) {
            this.addString(docletInfo, "-ejbSuffix", this.ejbSuffix);
        }
        if (this.localHomePrefix != null) {
            this.addString(docletInfo, "-localHomePrefix", this.localHomePrefix);
        }
        if (this.localHomeSuffix != null) {
            this.addString(docletInfo, "-localHomeSuffix", this.localHomeSuffix);
        }
        if (this.remoteHomePrefix != null) {
            this.addString(docletInfo, "-remoteHomePrefix", this.remoteHomePrefix);
        }
        if (this.remoteHomeSuffix != null) {
            this.addString(docletInfo, "-remoteHomeSuffix", this.remoteHomeSuffix);
        }
        if (this.remotePrefix != null) {
            this.addString(docletInfo, "-remotePrefix", this.remotePrefix);
        }
        if (this.remoteSuffix != null) {
            this.addString(docletInfo, "-remoteSuffix", this.remoteSuffix);
        }
        if (this.propertyFile != null) {
            this.addString(docletInfo, "-propertyFile", this.propertyFile);
        }
        if (this.valueBaseClass != null) {
            this.addString(docletInfo, "-valueBaseClass", this.valueBaseClass);
        }
        if (this.jndiPrefix != null) {
            this.addString(docletInfo, "-jndiPrefix", this.jndiPrefix);
        }
        if (this.jndiSuffix != null) {
            this.addString(docletInfo, "-jndiSuffix", this.jndiSuffix);
        }
        if (this.localPrefix != null) {
            this.addString(docletInfo, "-localPrefix", this.localPrefix);
        }
        if (this.localSuffix != null) {
            this.addString(docletInfo, "-localSuffix", this.localSuffix);
        }
        if (this.valueObjectPrefix != null) {
            this.addString(docletInfo, "-valueObjectPrefix", this.valueObjectPrefix);
        }
        if (this.valueObjectSuffix != null) {
            this.addString(docletInfo, "-valueObjectSuffix", this.valueObjectSuffix);
        }
        if (!this.valueClasses) {
            this.addFlag(docletInfo, "-noValueClasses");
        }
        if (!this.remoteInterfaces) {
            this.addFlag(docletInfo, "-noRemoteInterfaces");
        }
        if (!this.localInterfaces) {
            this.addFlag(docletInfo, "-noLocalInterfaces");
        }
    }

    private void addString(Javadoc.DocletInfo docletInfo, String string, String string2) {
        Javadoc.DocletParam docletParam = docletInfo.createParam();
        docletParam.setName(string);
        docletParam.setValue(string2);
    }

    private void addFlag(Javadoc.DocletInfo docletInfo, String string) {
        Javadoc.DocletParam docletParam = docletInfo.createParam();
        docletParam.setName(string);
    }

    private void verifyRequired() throws BuildException {
        if (this.srcPath == null) {
            throw new BuildException("srcPath not specified");
        }
        File file = this.getProject().resolveFile(this.tmpdir);
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new BuildException("cannot make tmpdir: " + file.getAbsolutePath());
        }
        if (this.ejbsource == null) {
            throw new BuildException("ejbs not specified");
        }
        if (this.outputJar == null) {
            throw new BuildException("outputjar not specified");
        }
        if (this.tmpdir == null) {
            throw new BuildException("tmpdir not specified");
        }
    }

    private void runJavac() {
        Project project = this.getProject();
        Javac javac = null;
        javac = new Javac();
        javac.setTaskName("javac");
        javac.setProject(project);
        File file = project.resolveFile(this.tmpdir);
        javac.setDestdir(file);
        Path path = new Path(this.getProject());
        path.setLocation(project.getBaseDir());
        javac.setSrcdir(path);
        StringBuffer stringBuffer = new StringBuffer(this.tmpdir + "/**/*.java");
        stringBuffer.append(",");
        stringBuffer.append(this.ejbsource);
        if (this.utils != null) {
            stringBuffer.append(",");
            stringBuffer.append(this.utils);
        }
        String string = stringBuffer.toString();
        javac.setIncludes(string);
        Ejbgen.p("tmpdir=" + this.tmpdir);
        javac.setFailonerror(true);
        javac.execute();
    }

    private static String[] split(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }
}

