/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.j2ee;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import weblogic.ant.taskdefs.j2ee.CompilerTask;

public class Jspc
extends CompilerTask {
    private String src;
    private String jspname;
    private String contextpath;
    private String superclass;
    private String encoding;
    private String packagename;
    private String docroot;
    private boolean skipJavac;
    private String compiler;
    private String compileall;

    public void setCompileAll(String string) {
        this.compileall = string;
    }

    public void setCompiler(String string) {
        this.compiler = string;
    }

    public void setSrc(String string) {
        this.src = string;
    }

    public void setJspname(String string) {
        this.jspname = string;
    }

    public void setContextPath(String string) {
        this.contextpath = string;
    }

    public void setSuperClass(String string) {
        this.superclass = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setPackage(String string) {
        this.packagename = string;
    }

    public void setDocRoot(String string) {
        this.docroot = string;
    }

    public void setSkipJavac(boolean bl) {
        this.skipJavac = bl;
    }

    public void execute() throws BuildException {
        String[] stringArray;
        Vector vector = super.getFlags();
        if (this.compileall != null) {
            vector.addElement("-compileAll");
            vector.addElement(this.compileall);
        }
        if (this.compiler != null) {
            vector.addElement("-compiler");
            vector.addElement(this.compiler);
        }
        if (this.contextpath != null) {
            vector.addElement("-contextPath");
            vector.addElement(this.contextpath);
        }
        if (this.superclass != null) {
            vector.addElement("-superclass");
            vector.addElement(this.superclass);
        }
        if (this.encoding != null) {
            vector.addElement("-encoding");
            vector.addElement(this.encoding);
        }
        if (this.packagename != null) {
            vector.addElement("-package");
            vector.addElement(this.packagename);
        }
        if (this.docroot != null) {
            vector.addElement("-docroot");
            vector.addElement(this.docroot);
        }
        if (this.skipJavac) {
            vector.addElement("-skipJavac");
        }
        int n = vector.size();
        File file = this.src != null ? this.project.resolveFile(this.src) : new File(".");
        File file2 = this.project.resolveFile(this.destdir);
        if (this.jspname == null) {
            stringArray = this.getDirectoryScanner(file);
            String[] stringArray2 = stringArray.getIncludedFiles();
            this.scanDir(file, file2, stringArray2, vector);
        } else if (this.shouldCompile(this.jspname, file, file2)) {
            vector.addElement(this.jspname);
        }
        if (vector.size() > n) {
            stringArray = this.getArgs(vector);
            this.log("Compiling " + (stringArray.length - n) + " jsps to " + this.destdir, 2);
            this.invokeMain("weblogic.jspc", stringArray);
        }
    }

    protected void scanDir(File file, File file2, String[] stringArray, Vector vector) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".jsp") || !this.shouldCompile(stringArray[i], file, file2)) continue;
            vector.addElement(stringArray[i]);
        }
    }

    private File getTarget(File file, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.packagename != null) {
            stringBuffer.append(this.packagename.replace('.', File.separatorChar));
        } else {
            stringBuffer.append("jsp_servlet");
        }
        String string2 = string.substring(0, string.lastIndexOf(".jsp"));
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/\\");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            stringBuffer.append(File.separatorChar);
            stringBuffer.append("_");
            stringBuffer.append(string3);
        }
        stringBuffer.append(".class");
        return new File(file, stringBuffer.toString());
    }

    private boolean shouldCompile(String string, File file, File file2) {
        File file3 = new File(file, string);
        File file4 = this.getTarget(file2, string);
        if (!file4.exists()) {
            return true;
        }
        if (file4.lastModified() > System.currentTimeMillis()) {
            this.log("Warning: file modified in the future: " + file4, 1);
        }
        return file3.lastModified() > file4.lastModified();
    }
}

