/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.j2ee;

import java.io.File;
import java.rmi.Remote;
import java.util.Date;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import weblogic.ant.taskdefs.j2ee.CompilerTask;

public class Rmic
extends CompilerTask {
    private String classname;
    private boolean verify = false;
    private boolean clusterable = false;
    private boolean nontransactional = false;
    private boolean serversidestubs = false;
    private boolean propagateenvironment = false;
    private boolean nomanglednames = false;
    private boolean iiop = false;
    private boolean idl = false;
    private boolean oneway = false;
    private String iiopDirectory = null;
    private String idlDirectory = null;
    private String replicahandler = null;
    private String replicaListRefreshInterval = null;
    private String descriptor = null;
    private String dgcpolicy = null;
    private boolean replicaAware = false;
    private String loadAlgorithm;
    private String callRouter;
    private boolean methodsAreIdempotent = false;
    private boolean stickToFirstServer = false;
    private String compiler;
    private boolean verbose = false;
    private String src;

    public void setSrcDir(String string) {
        this.src = string;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public void setVerify(boolean bl) {
        this.verify = bl;
    }

    public void setIiopDirectory(String string) {
        this.iiopDirectory = string;
    }

    public void setIdlDirectory(String string) {
        this.idlDirectory = string;
    }

    public void setReplicaHandler(String string) {
        this.replicahandler = string;
    }

    public void setReplicaListRefreshInterval(String string) {
        this.replicaListRefreshInterval = string;
    }

    public void setClusterable(boolean bl) {
        this.clusterable = bl;
    }

    public void setReplicaAware(boolean bl) {
        this.replicaAware = bl;
    }

    public void setLoadAlgorithm(String string) {
        this.loadAlgorithm = string;
    }

    public void setCallRouter(String string) {
        this.callRouter = string;
    }

    public void setMethodsAreIdempotent(boolean bl) {
        this.methodsAreIdempotent = bl;
    }

    public void setStickToFirstServer(boolean bl) {
        this.stickToFirstServer = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setCompiler(String string) {
        this.compiler = string;
    }

    public void setTransactional(boolean bl) {
        this.nontransactional = !bl;
    }

    public void setNonTransactional(boolean bl) {
        this.nontransactional = bl;
    }

    public void setServerSideStubs(boolean bl) {
        this.serversidestubs = bl;
    }

    public void setPropagateEnvironment(boolean bl) {
        this.propagateenvironment = bl;
    }

    public void setNoMangledNames(boolean bl) {
        this.nomanglednames = bl;
    }

    public void setOneway(boolean bl) {
        this.oneway = bl;
    }

    public void setDescriptor(String string) {
        this.descriptor = this.src == null ? string : this.src + "/" + string;
    }

    public void setDgcPolicy(String string) {
        this.dgcpolicy = string;
    }

    public void setIiop(boolean bl) {
        this.iiop = bl;
    }

    public void setIdl(boolean bl) {
        this.idl = bl;
    }

    public void execute() throws BuildException {
        String[] stringArray;
        if (this.verify) {
            this.log("Verify has been turned on.", 2);
        }
        Vector vector = super.getFlags();
        if (this.clusterable) {
            vector.addElement("-clusterable");
        }
        if (this.nontransactional) {
            vector.addElement("-nontransactional");
        }
        if (this.serversidestubs) {
            vector.addElement("-serverSideStubs");
        }
        if (this.propagateenvironment) {
            vector.addElement("-propagateEnvironment");
        }
        if (this.nomanglednames) {
            vector.addElement("-nomanglednames");
        }
        if (this.iiop) {
            vector.addElement("-iiop");
        }
        if (this.idl) {
            vector.addElement("-idl");
        }
        if (this.replicaAware) {
            vector.addElement("-replicaAware");
        }
        if (this.methodsAreIdempotent) {
            vector.addElement("-methodsAreIdempotent");
        }
        if (this.stickToFirstServer) {
            vector.addElement("-stickToFirstServer");
        }
        if (this.verbose) {
            vector.addElement("-verbose");
        }
        if (this.oneway) {
            vector.addElement("-oneway");
        }
        if (this.callRouter != null) {
            vector.addElement("-callRouter");
            vector.addElement(this.callRouter);
        }
        if (this.loadAlgorithm != null) {
            vector.addElement("-loadAlgorithm");
            vector.addElement(this.loadAlgorithm);
        }
        if (this.compiler != null) {
            vector.addElement("-compiler");
            vector.addElement(this.compiler);
        }
        if (this.iiopDirectory != null) {
            vector.addElement("-iiopDirectory");
            vector.addElement(this.iiopDirectory);
        }
        if (this.idlDirectory != null) {
            vector.addElement("-idlDirectory");
            vector.addElement(this.idlDirectory);
        }
        if (this.replicahandler != null) {
            vector.addElement("-replicaHandler");
            vector.addElement(this.replicahandler);
        }
        if (this.descriptor != null) {
            vector.addElement("-descriptor");
            vector.addElement(this.descriptor);
        }
        if (this.dgcpolicy != null) {
            vector.addElement("-dgcPolicy");
            vector.addElement(this.dgcpolicy);
        }
        int n = vector.size();
        File file = this.project.resolveFile(this.destdir);
        if (this.classname == null) {
            stringArray = this.getDirectoryScanner(file);
            String[] stringArray2 = stringArray.getIncludedFiles();
            this.scanDir(file, stringArray2, this.verify, vector);
        } else if (this.shouldCompile(new File(file, this.classname.replace('.', File.separatorChar) + ".class"))) {
            vector.addElement(this.classname);
        }
        if (vector.size() > n) {
            stringArray = this.getArgs(vector);
            this.log("Compiling " + (stringArray.length - n) + " classes to " + this.destdir, 2);
            if (this.verbose) {
                System.out.print("weblogic.rmic(");
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.print(stringArray[i] + " ");
                }
                System.out.println(")");
            }
            this.invokeMain("weblogic.rmic", stringArray);
        }
    }

    protected void scanDir(File file, String[] stringArray, boolean bl, Vector vector) {
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (!stringArray[i].endsWith(".class") || !this.shouldCompile(file2)) continue;
            String string = stringArray[i].replace(File.separatorChar, '.');
            string = string.substring(0, string.indexOf(".class"));
            boolean bl2 = true;
            if (bl) {
                try {
                    Class<?> clazz = Class.forName(string);
                    if (clazz.isInterface() || !this.isValidRmiRemote(clazz)) {
                        bl2 = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log("Unable to verify class " + string + ". It could not be found.", 1);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    this.log("Unable to verify class " + string + ". It is not defined.", 1);
                }
            }
            if (!bl2) continue;
            this.log("Adding: " + string + " to compile list", 3);
            vector.addElement(string);
        }
    }

    private boolean isValidRmiRemote(Class clazz) {
        Class<Remote> clazz2 = Remote.class;
        if (clazz2.equals((Object)clazz)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (clazz2.equals(classArray[i])) {
                    return true;
                }
                if (!this.isValidRmiRemote(classArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldCompile(File file) {
        long l = new Date().getTime();
        File file2 = new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().indexOf(".class")) + "RTD.xml");
        if (!file2.exists()) {
            return true;
        }
        if (file.exists()) {
            File file3;
            if (file.lastModified() > l) {
                this.log("Warning: file modified in the future: " + file, 1);
            }
            if (file.lastModified() > file2.lastModified()) {
                return true;
            }
            return this.descriptor != null && (file3 = new File(this.descriptor)).exists() && file3.lastModified() > file2.lastModified();
        }
        return true;
    }
}

