/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.management;

import com.bea.staxb.buildtime.Java2SchemaTask;
import com.bea.staxb.buildtime.internal.mbean.MBeanJava2SchemaTask;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import weblogic.descriptor.beangen.beangen;
import weblogic.utils.FileUtils;

public final class DescriptorGen
extends Task {
    private static final String BEA_JAVA2SCHEMA_NAME = "weblogic.ant.taskdefs.management.DescriptorGen.java2schema";
    private static final String BEAN_SUFFIX = "Impl";
    private static final String BEAN_BASE_CLASS = "weblogic.descriptor.internal.AbstractDescriptorBean";
    private static final String BEAN_PATTERN = "**/*Bean.java";
    private static final String IMPL_PATTERN = "**/*BeanImpl.java";
    private File srcdir;
    private File destdir;
    private File bindingJarFile;
    private String targetNamespace;
    private Path classpath = Path.systemClasspath;

    public void setClasspath(Path path) {
        this.classpath.append(path);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        return this.classpath.createPath();
    }

    public void setSrcdir(File file) {
        this.srcdir = file;
    }

    public File getSrcdir() {
        return this.srcdir;
    }

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public File getDestdir() {
        return this.destdir;
    }

    public void setBindingJarFile(File file) {
        this.bindingJarFile = file;
    }

    public File getBindingJarFile() {
        return this.bindingJarFile;
    }

    public void setTargetNamespace(String string) {
        this.targetNamespace = string;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    private void validateOpts() throws BuildException {
        if (this.srcdir == null) {
            throw new BuildException("srcdir was not set");
        }
        if (!this.srcdir.exists()) {
            throw new BuildException("srcdir " + this.srcdir.getPath() + " does not exist or could not be read.");
        }
        if (!this.srcdir.isDirectory()) {
            throw new BuildException("srcdir " + this.srcdir.getPath() + " is not a directory.");
        }
        if (this.destdir == null) {
            throw new BuildException("destdir not set");
        }
        if (this.destdir.exists()) {
            if (!this.destdir.isDirectory()) {
                throw new BuildException("destdir " + this.destdir.getPath() + " is not a directory.");
            }
            this.destdir.mkdirs();
        }
        if (this.bindingJarFile == null) {
            throw new BuildException("bindingJarFile not set");
        }
    }

    public void execute() throws BuildException {
        this.validateOpts();
        this.classpath = new Path(this.project);
        this.classpath.add(Path.systemClasspath);
        this.classpath.add(new Path(this.project, this.destdir.getAbsolutePath()));
        this.beangen();
        this.compileGeneratedCode();
        try {
            this.java2schema();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    private String find(File file, String string) {
        FileSet fileSet = new FileSet();
        fileSet.setDir(file);
        fileSet.createInclude().setName(string);
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
        String[] stringArray = directoryScanner.getIncludedFiles();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" " + stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private Commandline.Argument buildArgList(Java java) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-d ").append(this.destdir.getAbsolutePath());
        stringBuffer.append(" -sourcedir ").append(this.srcdir.getAbsolutePath());
        stringBuffer.append(" -nolocalvalidation");
        stringBuffer.append(" -suffix ").append(BEAN_SUFFIX);
        stringBuffer.append(" -baseclass ").append(BEAN_BASE_CLASS);
        if (this.getTargetNamespace() != null) {
            stringBuffer.append(" -targetNamespace ").append(this.getTargetNamespace());
        }
        stringBuffer.append(this.find(this.srcdir, BEAN_PATTERN));
        String string = stringBuffer.toString();
        System.out.println("\n Using beangen command-line of " + string);
        Commandline.Argument argument = java.createArg();
        argument.setLine(string);
        return argument;
    }

    private void beangen() throws BuildException {
        Java java = (Java)this.project.createTask("java");
        java.setClassname(beangen.class.getName());
        java.setFork(true);
        java.setFailonerror(true);
        this.buildArgList(java);
        java.setClasspath(this.classpath);
        java.execute();
    }

    private void compileGeneratedCode() throws BuildException {
        Javac javac = (Javac)this.project.createTask("javac");
        javac.setSrcdir(new Path(this.project, this.destdir.getAbsolutePath()));
        javac.setDestdir(this.destdir);
        javac.setClasspath(this.classpath);
        javac.execute();
    }

    private Java2SchemaTask findOrCreateSchemaTask() {
        Hashtable hashtable = this.project.getTaskDefinitions();
        if (!hashtable.contains(BEA_JAVA2SCHEMA_NAME)) {
            this.project.addTaskDefinition(BEA_JAVA2SCHEMA_NAME, MBeanJava2SchemaTask.class);
        }
        Java2SchemaTask java2SchemaTask = (Java2SchemaTask)this.project.createTask(BEA_JAVA2SCHEMA_NAME);
        java2SchemaTask.setTaskName("java2Schema");
        return java2SchemaTask;
    }

    private void java2schema() throws BuildException, IOException {
        File file = FileUtils.createTempDir((String)"dgen");
        file.mkdirs();
        System.out.println("java2schema using tempdir " + file);
        Java2SchemaTask java2SchemaTask = this.findOrCreateSchemaTask();
        java2SchemaTask.setSrcdir(new Path(this.project, this.destdir.getAbsolutePath()));
        java2SchemaTask.setIncludes(IMPL_PATTERN);
        java2SchemaTask.setDestDir(file);
        java2SchemaTask.setClasspath(this.classpath);
        java2SchemaTask.execute();
        Jar jar = (Jar)this.project.createTask("jar");
        jar.setBasedir(file);
        jar.setDestFile(this.bindingJarFile);
        jar.execute();
        FileUtils.remove((File)file);
    }
}

