/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ant.taskdefs.management;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import weblogic.nodemanager.client.NMClient;

public class NMServer
extends Java
implements Runnable,
BuildListener {
    private String home = null;
    private String config = null;
    private File domainDir = null;
    private boolean verbose = false;
    private boolean debug = false;
    private String listenPort = "5555";
    private String listenAddress = "localhost";
    private boolean noExit = false;
    private String action = "start";
    private String userName;
    private String password;
    private String domainName = "mydomain";
    private boolean quitEnabled = true;
    private boolean acceptDemoTrust = false;
    private Process process = null;
    private static final String NM_MAIN_CLASS = "weblogic.nodemanager.server.NMServer";
    private boolean authenticationEnabled = true;

    public void setAcceptDemoTrust(boolean bl) {
        this.acceptDemoTrust = bl;
    }

    public void setQuitEnabled(boolean bl) {
        this.quitEnabled = bl;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public void setNoExit(boolean bl) {
        this.noExit = bl;
    }

    public void setListenPort(String string) {
        this.listenPort = string;
    }

    public void setListenAddress(String string) {
        this.listenAddress = string;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public void setHome(String string) {
        this.home = string;
    }

    public void setAuthenticationEnabled(boolean bl) {
        this.authenticationEnabled = bl;
    }

    public void setConfig(String string) {
        this.config = string;
    }

    public void setDir(File file) {
        this.domainDir = file;
        super.setDir(file);
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void execute() throws BuildException {
        if (this.action.equals("start")) {
            this.startAction();
            return;
        }
        if (this.action.equals("shutdown")) {
            this.shutdownAction();
            return;
        }
        System.err.println("Unknown action " + this.action);
        throw new BuildException("Unknown action " + this.action);
    }

    private void startAction() throws BuildException {
        this.getProject().addBuildListener((BuildListener)this);
        this.setClassname(NM_MAIN_CLASS);
        String string = this.getClass().getName();
        String string2 = this.getClass().getPackage().getName();
        string = string.substring(string2.length() + 1, string.length());
        this.setTaskName(string);
        this.setFork(true);
        this.setSpawn(true);
        if (this.domainDir != null && !this.domainDir.exists()) {
            throw new BuildException(this.domainDir + " doesn't exist.");
        }
        this.checkSuppliedCredentials();
        CommandlineJava commandlineJava = new CommandlineJava();
        commandlineJava.setClassname(NM_MAIN_CLASS);
        this.setNMProperty(commandlineJava, "ListenPort", this.listenPort);
        this.setNMProperty(commandlineJava, "ListenAddress", this.listenAddress);
        this.setNMProperty(commandlineJava, "QuitEnabled", Boolean.toString(this.quitEnabled));
        if (this.home != null) {
            this.setCMDLArg(commandlineJava, "NodeManagerHome", this.home);
        }
        if (this.config != null) {
            this.setCMDLArg(commandlineJava, "PropertiesFile", this.config);
        }
        if (!this.authenticationEnabled) {
            this.setCMDLArg(commandlineJava, "AuthenticationEnabled", "false");
        }
        if (this.verbose) {
            commandlineJava.createArgument().setValue("-v");
        }
        if (this.debug) {
            commandlineJava.createArgument().setValue("-d");
        }
        this.startProcess(commandlineJava);
        if (this.waitForNMStart()) {
            System.out.println("Nodemanager is started");
        } else {
            System.out.println("Nodemanager is not started. It may still be booting or has failed. Check nodemanager log for details.");
        }
    }

    private boolean waitForNMStart() {
        String string = System.getProperty("weblogic.security.TrustKeyStore");
        boolean bl = false;
        if (this.acceptDemoTrust && (string == null || !string.equals("DemoTrust"))) {
            System.setProperty("weblogic.security.TrustKeyStore", "DemoTrust");
            bl = true;
        }
        NMClient nMClient = NMClient.getInstance("ssl");
        nMClient.setDomainName(this.domainName);
        nMClient.setPort(Integer.parseInt(this.listenPort));
        nMClient.setHost(this.listenAddress);
        nMClient.setVerbose(true);
        nMClient.setNMUser(this.userName);
        nMClient.setNMPass(this.password);
        boolean bl2 = false;
        for (int i = 0; !bl2 && i < 20; ++i) {
            try {
                String string2 = nMClient.getVersion();
                nMClient.done();
                bl2 = true;
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Nodemanager is not started. Waiting...");
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            if (string == null) {
                System.clearProperty("weblogic.security.TrustKeyStore");
            } else {
                System.setProperty("weblogic.security.TrustKeyStore", string);
            }
        }
        return bl2;
    }

    private void startProcess(CommandlineJava commandlineJava) {
        try {
            System.out.println("Starting CommandLine " + commandlineJava.describeJavaCommand());
            this.process = Execute.launch((Project)this.getProject(), (String[])commandlineJava.getCommandline(), (String[])new Environment().getVariables(), (File)this.domainDir, (boolean)true);
            if (Os.isFamily((String)"windows")) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    this.getProject().log("interruption in the sleep after having spawned a process", 3);
                }
            }
            OutputStream outputStream = new OutputStream(){

                public void write(int n) {
                }
            };
            PumpStreamHandler pumpStreamHandler = new PumpStreamHandler(outputStream);
            pumpStreamHandler.setProcessErrorStream(this.process.getErrorStream());
            pumpStreamHandler.setProcessOutputStream(this.process.getInputStream());
            pumpStreamHandler.start();
            this.process.getOutputStream().close();
            this.getProject().log("spawned process " + this.process.toString(), 3);
        }
        catch (IOException iOException) {
            System.err.println("Unable to start a process for " + commandlineJava);
            iOException.printStackTrace();
        }
    }

    private void shutdownAction() throws BuildException {
        String string = System.getProperty("weblogic.security.TrustKeyStore");
        boolean bl = false;
        if (this.acceptDemoTrust && (string == null || !string.equals("DemoTrust"))) {
            System.setProperty("weblogic.security.TrustKeyStore", "DemoTrust");
            bl = true;
        }
        NMClient nMClient = NMClient.getInstance("ssl");
        nMClient.setDomainName(this.domainName);
        nMClient.setPort(Integer.parseInt(this.listenPort));
        nMClient.setHost(this.listenAddress);
        nMClient.setVerbose(true);
        this.checkSuppliedCredentials();
        nMClient.setNMUser(this.userName);
        nMClient.setNMPass(this.password);
        try {
            System.out.println("Shutting down the node manager");
            nMClient.quit();
            nMClient.done();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
        if (bl) {
            if (string == null) {
                System.clearProperty("weblogic.security.TrustKeyStore");
            } else {
                System.setProperty("weblogic.security.TrustKeyStore", string);
            }
        }
    }

    private void checkSuppliedCredentials() throws BuildException {
        if (this.userName == null || this.password == null) {
            throw new BuildException("NodeManager username and password must be supplied");
        }
    }

    private void setNMProperty(CommandlineJava commandlineJava, String string, Object object) {
        if (object != null) {
            String string2 = "-Dweblogic.nodemanager." + string + "=" + object;
            System.out.println("Adding NM argument" + string2);
            commandlineJava.createVmArgument().setValue(string2);
        }
    }

    private void setCMDLArg(CommandlineJava commandlineJava, String string, Object object) {
        if (object != null) {
            commandlineJava.createVmArgument().setValue("-D" + string + "=" + object.toString());
        }
    }

    public void run() {
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (!this.noExit) {
            System.out.println("Killing NodeManager Instance");
            this.shutdownAction();
        } else {
            System.out.println("Leaving the NodeManager running");
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }
}

